/*
 * Decompiled with CFR 0.152.
 */
package marytts.language.de.preprocess;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import marytts.datatypes.MaryXML;
import marytts.language.de.preprocess.AbbrevEP;
import marytts.language.de.preprocess.CompositeEP;
import marytts.language.de.preprocess.CurrencyEP;
import marytts.language.de.preprocess.DateEP;
import marytts.language.de.preprocess.DurationEP;
import marytts.language.de.preprocess.MeasureEP;
import marytts.language.de.preprocess.MultiWordEP;
import marytts.language.de.preprocess.NetEP;
import marytts.language.de.preprocess.NumberEP;
import marytts.language.de.preprocess.SpecialCharEP;
import marytts.language.de.preprocess.TelephoneEP;
import marytts.language.de.preprocess.TimeEP;
import marytts.util.MaryUtils;
import marytts.util.dom.MaryDomUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class ExpansionPattern {
    protected static MultiWordEP multiword;
    protected static CompositeEP composite;
    protected static NetEP net;
    protected static DateEP date;
    protected static TimeEP time;
    protected static DurationEP duration;
    protected static CurrencyEP currency;
    protected static MeasureEP measure;
    protected static TelephoneEP telephone;
    protected static NumberEP number;
    protected static AbbrevEP abbrev;
    protected static SpecialCharEP specialChar;
    private static List<ExpansionPattern> expansionPatterns;
    private static Map<String, ExpansionPattern> patternTable;
    private static Logger logger;

    public static List<ExpansionPattern> allPatterns() {
        return expansionPatterns;
    }

    public static ExpansionPattern getPattern(String typeString) {
        return patternTable.get(typeString);
    }

    public static Pattern reSplitAtChars() {
        return specialChar.getRESplitAtChars();
    }

    public static String getSplitAtChars() {
        return specialChar.splitAtChars();
    }

    protected boolean allowMultipleTokens() {
        return true;
    }

    protected boolean doesFullExpansion() {
        return true;
    }

    public abstract List<String> knownTypes();

    public abstract Pattern reMatchingChars();

    public boolean process(Element t, List<Element> expanded) {
        if (t == null || expanded == null) {
            throw new NullPointerException("Received null argument");
        }
        if (!t.getTagName().equals("t")) {
            throw new DOMException(15, "Expected t element");
        }
        if (!expanded.isEmpty()) {
            throw new IllegalArgumentException("Expected empty list, but list has " + expanded.size() + " elements.");
        }
        StringBuilder sb = new StringBuilder();
        int matchedType = -1;
        ArrayList<Element> candidates = new ArrayList<Element>();
        if (this.allowMultipleTokens()) {
            Element n = t;
            while (n != null && n.getTagName().equals("t") && !n.hasAttribute("ph") && !n.hasAttribute("sounds_like") && this.isCandidate(n)) {
                candidates.add(n);
                n = MaryDomUtils.getNextSiblingElement((Element)n);
            }
            if (candidates.isEmpty()) {
                return false;
            }
            while (!candidates.isEmpty()) {
                sb.setLength(0);
                Iterator it = candidates.iterator();
                while (it.hasNext()) {
                    sb.append(MaryDomUtils.tokenText((Element)((Element)it.next())));
                }
                matchedType = this.match(sb.toString(), 0);
                if (matchedType == -1) {
                    candidates.remove(candidates.size() - 1);
                    continue;
                }
                break;
            }
        } else if (!t.hasAttribute("ph") && !t.hasAttribute("sounds_like") && this.isCandidate(t)) {
            sb.setLength(0);
            sb.append(MaryDomUtils.tokenText((Element)t));
            matchedType = this.match(sb.toString(), 0);
            candidates.add(t);
        }
        if (matchedType != -1) {
            logger.debug((Object)("Found match, type " + this.knownTypes().get(matchedType) + ": " + sb.toString() + " (" + candidates.size() + " tokens)"));
            expanded.addAll(this.expand(candidates, sb.toString(), matchedType));
            if (expanded.isEmpty() && !this.knownTypes().get(matchedType).equals("specialChar")) {
                logger.info((Object)("Could match, but not expand string \"" + sb + "\" as type " + this.knownTypes().get(matchedType)));
            }
            return !expanded.isEmpty() && this.doesFullExpansion();
        }
        return false;
    }

    protected boolean isCandidate(Element t) {
        return this.reMatchingChars().matcher(MaryDomUtils.tokenText((Element)t)).find();
    }

    public void match(Element sayas, String typeString) throws DOMException {
        if (!sayas.getTagName().equals("say-as")) {
            throw new DOMException(15, "Expected say-as element, got " + sayas.getTagName());
        }
        List tokenNodes = MaryDomUtils.getNodeListAsList((NodeList)sayas.getElementsByTagName("t"));
        ArrayList<Element> tokens = new ArrayList<Element>();
        for (Node n : tokenNodes) {
            tokens.add((Element)n);
        }
        StringBuilder sb = new StringBuilder();
        Iterator it = tokens.iterator();
        while (it.hasNext()) {
            sb.append(MaryDomUtils.tokenText((Element)((Element)it.next())));
        }
        int type = this.knownTypes().indexOf(typeString);
        int expandType = this.canDealWith(sb.toString(), type);
        if (expandType != -1) {
            List<Element> expanded = this.expand(tokens, sb.toString(), expandType);
            if (expanded.isEmpty()) {
                logger.info((Object)("Failure expanding string \"" + sb + "\" as type \"" + this.knownTypes().get(expandType) + "\""));
            }
        } else {
            logger.info((Object)("Cannot expand string \"" + sb.toString() + "\" as requested type \"" + typeString + "\""));
        }
    }

    protected abstract int canDealWith(String var1, int var2);

    protected abstract int match(String var1, int var2);

    protected abstract List<Element> expand(List<Element> var1, String var2, int var3);

    protected List<Element> makeNewTokens(Document doc, String newText) {
        return this.makeNewTokens(doc, newText, false, null);
    }

    protected List<Element> makeNewTokens(Document doc, String newText, boolean createMtu, String origText) {
        return this.makeNewTokens(doc, newText, createMtu, origText, false);
    }

    protected List<Element> makeNewTokens(Document doc, String newText, boolean createMtu, String origText, boolean forceAccents) {
        if (newText == null || newText.length() == 0) {
            return null;
        }
        Pattern rePron = Pattern.compile("\\[(.*)\\]");
        StringTokenizer st = new StringTokenizer(newText);
        ArrayList<Element> newTokens = new ArrayList<Element>();
        while (st.hasMoreTokens()) {
            String text = st.nextToken();
            Element newT = MaryXML.createElement((Document)doc, (String)"t");
            Matcher remPron = rePron.matcher(text);
            if (remPron.find()) {
                String pron = remPron.group(1);
                text = rePron.matcher(text).replaceFirst("");
                newT.setAttribute("ph", pron);
            }
            MaryDomUtils.setTokenText((Element)newT, (String)text);
            if (forceAccents) {
                newT.setAttribute("accent", "unknown");
            }
            newTokens.add(newT);
        }
        if (createMtu) {
            Element mtu = MaryXML.createElement((Document)doc, (String)"mtu");
            mtu.setAttribute("orig", origText);
            mtu.setAttribute("accent", "last");
            Iterator<Element> it = newTokens.iterator();
            while (it.hasNext()) {
                mtu.appendChild(it.next());
            }
            ArrayList<Element> result = new ArrayList<Element>();
            result.add(mtu);
            return result;
        }
        return newTokens;
    }

    protected void replaceTokens(List<Element> oldTokens, List<Element> newTokens) {
        if (oldTokens == null || oldTokens.isEmpty() || newTokens == null || newTokens.isEmpty()) {
            throw new NullPointerException("Have received null or empty argument.");
        }
        Node oldT = null;
        Iterator<Element> itOld = oldTokens.iterator();
        for (Element newT : newTokens) {
            if (itOld.hasNext()) {
                oldT = itOld.next();
            }
            oldT.getParentNode().insertBefore(newT, oldT);
            if (!itOld.hasNext()) continue;
            oldT.getParentNode().removeChild(oldT);
        }
        if (!itOld.hasNext()) {
            oldT.getParentNode().removeChild(oldT);
        } else {
            while (itOld.hasNext()) {
                oldT = itOld.next();
                oldT.getParentNode().removeChild(oldT);
            }
        }
        for (Element mtu : newTokens) {
            Element parent;
            if (!mtu.getTagName().equals("mtu") || !(parent = (Element)mtu.getParentNode()).getTagName().equals("mtu") || MaryDomUtils.getPreviousSiblingElement((Element)mtu) != null || MaryDomUtils.getNextSiblingElement((Element)mtu) != null || !parent.getAttribute("orig").equals(mtu.getAttribute("orig"))) continue;
            Element grandParent = (Element)parent.getParentNode();
            grandParent.insertBefore(mtu, parent);
            grandParent.removeChild(parent);
        }
    }

    protected void slowDown(Element e) {
        Document doc = e.getOwnerDocument();
        Element whereToInsert = e;
        Element prosody = null;
        Element phonol = null;
        if (whereToInsert.getParentNode().getNodeName().equals("phonology")) {
            phonol = (Element)whereToInsert.getParentNode();
            if (phonol.getParentNode().getNodeName().equals("prosody")) {
                prosody = (Element)phonol.getParentNode();
            }
        } else {
            phonol = MaryXML.createElement((Document)doc, (String)"phonology");
            prosody = MaryXML.createElement((Document)doc, (String)"prosody");
            prosody.appendChild(phonol);
            whereToInsert.getParentNode().insertBefore(prosody, whereToInsert);
            phonol.appendChild(whereToInsert);
        }
        prosody.setAttribute("rate", "-20%");
        phonol.setAttribute("precision", "precise");
    }

    protected void slowDown(Element first, Element last) {
        Element phonol = MaryDomUtils.encloseNodesWithNewElement((Node)first, (Node)last, (String)"phonology");
        phonol.setAttribute("precision", "precise");
        Document doc = phonol.getOwnerDocument();
        Element prosody = MaryXML.createElement((Document)doc, (String)"prosody");
        prosody.setAttribute("rate", "-20%");
        phonol.getParentNode().insertBefore(prosody, phonol);
        prosody.appendChild(phonol);
    }

    static {
        expansionPatterns = new ArrayList<ExpansionPattern>();
        patternTable = new HashMap<String, ExpansionPattern>();
        multiword = new MultiWordEP();
        expansionPatterns.add(multiword);
        Iterator<String> it = multiword.knownTypes().iterator();
        while (it.hasNext()) {
            patternTable.put(it.next(), multiword);
        }
        net = new NetEP();
        expansionPatterns.add(net);
        it = net.knownTypes().iterator();
        while (it.hasNext()) {
            patternTable.put(it.next(), net);
        }
        composite = new CompositeEP();
        expansionPatterns.add(composite);
        it = composite.knownTypes().iterator();
        while (it.hasNext()) {
            patternTable.put(it.next(), composite);
        }
        date = new DateEP();
        expansionPatterns.add(date);
        it = date.knownTypes().iterator();
        while (it.hasNext()) {
            patternTable.put(it.next(), date);
        }
        time = new TimeEP();
        expansionPatterns.add(time);
        it = time.knownTypes().iterator();
        while (it.hasNext()) {
            patternTable.put(it.next(), time);
        }
        duration = new DurationEP();
        expansionPatterns.add(duration);
        it = duration.knownTypes().iterator();
        while (it.hasNext()) {
            patternTable.put(it.next(), duration);
        }
        currency = new CurrencyEP();
        expansionPatterns.add(currency);
        it = currency.knownTypes().iterator();
        while (it.hasNext()) {
            patternTable.put(it.next(), currency);
        }
        measure = new MeasureEP();
        expansionPatterns.add(measure);
        it = measure.knownTypes().iterator();
        while (it.hasNext()) {
            patternTable.put(it.next(), measure);
        }
        telephone = new TelephoneEP();
        expansionPatterns.add(telephone);
        it = telephone.knownTypes().iterator();
        while (it.hasNext()) {
            patternTable.put(it.next(), telephone);
        }
        abbrev = new AbbrevEP();
        expansionPatterns.add(abbrev);
        it = abbrev.knownTypes().iterator();
        while (it.hasNext()) {
            patternTable.put(it.next(), abbrev);
        }
        number = new NumberEP();
        expansionPatterns.add(number);
        it = number.knownTypes().iterator();
        while (it.hasNext()) {
            patternTable.put(it.next(), number);
        }
        specialChar = new SpecialCharEP();
        expansionPatterns.add(specialChar);
        it = specialChar.knownTypes().iterator();
        while (it.hasNext()) {
            patternTable.put(it.next(), specialChar);
        }
        logger = MaryUtils.getLogger((String)"ExpansionPattern");
    }
}

