/*
 * Decompiled with CFR 0.152.
 */
package marytts.language.de.preprocess;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import marytts.language.de.preprocess.ExpansionPattern;
import marytts.language.de.preprocess.REPattern;
import marytts.util.MaryUtils;
import marytts.util.dom.MaryDomUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AbbrevEP
extends ExpansionPattern {
    private final String[] _knownTypes = new String[]{"acronym"};
    private final List<String> knownTypes = Arrays.asList(this._knownTypes);
    private static final Map<String, String[]> abbrevDict = new HashMap<String, String[]>();
    private final Pattern reMatchingChars = null;
    private static final Logger logger = MaryUtils.getLogger((String)"AbbrevEP");

    @Override
    public List<String> knownTypes() {
        return this.knownTypes;
    }

    @Override
    public Pattern reMatchingChars() {
        return this.reMatchingChars;
    }

    @Override
    protected boolean isCandidate(Element t) {
        String str = MaryDomUtils.tokenText((Element)t);
        return this.isAbbrev(str) || REPattern.onlyDigits.matcher(str).find() || ".".equals(str);
    }

    @Override
    protected int canDealWith(String s, int type) {
        return this.match(s, type);
    }

    @Override
    protected int match(String s, int type) {
        if (s.length() > 1 && this.isAbbrev(s)) {
            return type;
        }
        return -1;
    }

    protected boolean isAbbrev(String s) {
        boolean isLetterDot = REPattern.letterDot.matcher(s).find();
        boolean isNonInitialCapital = REPattern.nonInitialCapital.matcher(s).find();
        boolean isOnlyConsonants = REPattern.onlyConsonants.matcher(s).find();
        boolean isInDict = abbrevDict.containsKey(s) || abbrevDict.containsKey(s + ".");
        return isLetterDot || isNonInitialCapital || isOnlyConsonants || isInDict;
    }

    @Override
    protected List<Element> expand(List<Element> tokens, String s, int type) {
        if (tokens == null) {
            throw new NullPointerException("Received null argument");
        }
        if (tokens.isEmpty()) {
            throw new IllegalArgumentException("Received empty list");
        }
        List<Element> expanded = null;
        expanded = this.expandAbbrev(tokens);
        this.replaceTokens(tokens, expanded);
        return expanded;
    }

    private List<Element> expandAbbrev(List<Element> abbrTokens) {
        ArrayList<Element> exp = new ArrayList<Element>();
        ArrayList<Element> abbr = new ArrayList<Element>(abbrTokens);
        ArrayList<Element> match = new ArrayList<Element>(abbr);
        boolean tryLowerCase = false;
        if (MaryDomUtils.isFirstOfItsKindIn((Node)abbr.get(0), (String)"s") && REPattern.initialCapitalLetter.matcher(MaryDomUtils.tokenText((Element)abbr.get(0))).find()) {
            tryLowerCase = true;
        }
        StringBuilder sb = new StringBuilder();
        while (!match.isEmpty()) {
            sb.setLength(0);
            Iterator<Element> it = match.iterator();
            while (it.hasNext()) {
                sb.append(MaryDomUtils.tokenText((Element)it.next()));
            }
            logger.debug((Object)("Looking up abbreviation in dictionary: `" + sb.toString() + "'"));
            if (abbrevDict.containsKey(sb.toString())) break;
            if (tryLowerCase) {
                sb.setCharAt(0, Character.toLowerCase(sb.charAt(0)));
                logger.debug((Object)("Looking up abbreviation in dictionary: `" + sb.toString() + "'"));
                if (abbrevDict.containsKey(sb.toString())) break;
            }
            sb.append(".");
            logger.debug((Object)("Looking up abbreviation in dictionary: `" + sb.toString() + "'"));
            if (abbrevDict.containsKey(sb.toString())) break;
            match.remove(match.size() - 1);
        }
        if (!match.isEmpty()) {
            exp.addAll(this.dictionaryExpandAbbrev(match, sb.toString()));
            abbr.removeAll(match);
            logger.debug((Object)("Have found abbreviation in dictionary: `" + sb.toString() + "'"));
        } else {
            Element token = abbr.get(0);
            String text = MaryDomUtils.tokenText((Element)token);
            if (REPattern.onlyDigits.matcher(text).find()) {
                logger.debug((Object)("Expanding as integer: `" + text + "'"));
                exp.addAll(this.makeNewTokens(token.getOwnerDocument(), number.expandInteger(text)));
            } else if (text.length() > 1) {
                logger.debug((Object)("Expanding one token by rule: `" + text + "'"));
                this.slowDown(token);
                exp.addAll(this.ruleExpandAbbrev(token));
            } else {
                exp.addAll(this.makeNewTokens(token.getOwnerDocument(), text));
            }
            abbr.remove(0);
        }
        if (!abbr.isEmpty()) {
            exp.addAll(this.expandAbbrev(abbr));
        }
        if (logger.getEffectiveLevel().equals((Object)Level.DEBUG)) {
            StringBuilder logBuf = new StringBuilder();
            for (Element elt : exp) {
                if (elt.getTagName().equals("t")) {
                    logBuf.append(MaryDomUtils.tokenText((Element)elt));
                } else {
                    logBuf.append(elt.getTagName());
                }
                logBuf.append(" ");
            }
            logger.debug((Object)("Expanded abbreviation: " + logBuf.toString()));
        }
        return exp;
    }

    private List<Element> dictionaryExpandAbbrev(List<Element> match, String abbrev) {
        Document doc = match.get(0).getOwnerDocument();
        ArrayList<Element> exp = new ArrayList<Element>();
        String[] value = abbrevDict.get(abbrev);
        String flex = value[0];
        String graph = value[1];
        if (MaryDomUtils.isFirstOfItsKindIn((Node)match.get(0), (String)"div") && REPattern.initialLowercaseLetter.matcher(graph).find()) {
            StringBuilder sb = new StringBuilder(graph);
            sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
            graph = sb.toString();
            sb.setLength(0);
            sb.append(abbrev);
            sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
            abbrev = sb.toString();
        }
        exp.addAll(this.makeNewTokens(doc, graph, true, abbrev));
        if (exp.isEmpty()) {
            return exp;
        }
        if (flex != null && flex.length() > 0) {
            Element t = exp.get(0);
            while (t != null && !t.getTagName().equals("t")) {
                t = MaryDomUtils.getFirstChildElement((Element)t);
            }
            if (t != null) {
                String firstWord = MaryDomUtils.tokenText((Element)t);
                t.setAttribute("ending", flex);
                t.setAttribute("sounds_like", firstWord);
                MaryDomUtils.setTokenText((Element)t, (String)abbrev);
            }
        }
        return exp;
    }

    protected List<Element> ruleExpandAbbrev(Element token) {
        Document doc = token.getOwnerDocument();
        String orig = MaryDomUtils.tokenText((Element)token);
        String expandedString = this.ruleExpandAbbrev(orig, false);
        return this.makeNewTokens(doc, expandedString, true, orig, true);
    }

    protected String ruleExpandAbbrev(String orig, boolean saySpecialChar) {
        if (orig.indexOf(46) == -1 && orig.length() <= 5 || orig.indexOf(46) == orig.length() - 1 && orig.length() <= 6) {
            return this.spellOutAbbrev(orig, saySpecialChar);
        }
        if (specialChar.reMatchingChars().matcher(orig).find()) {
            StringBuilder sb = new StringBuilder();
            StringTokenizer st = new StringTokenizer(orig, AbbrevEP.specialChar.sMatchingCharsSimpleString, saySpecialChar);
            while (st.hasMoreTokens()) {
                sb.append(this.ruleExpandAbbrev(st.nextToken(), saySpecialChar));
                sb.append(" ");
            }
            return sb.toString().trim();
        }
        return orig;
    }

    private String spellOutAbbrev(String s, boolean saySpecialChar) {
        if (s == null || s.length() == 0) {
            return s;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            if (specialChar.matchSpecialChar(s.substring(i, i + 1))) {
                if (!saySpecialChar) continue;
                sb.append(specialChar.expandSpecialChar(s.substring(i, i + 1)));
                sb.append(" ");
                continue;
            }
            if ((i + 2 == s.length() || i + 2 < s.length() && specialChar.matchSpecialChar(s.substring(i + 2, i + 3))) && Character.isUpperCase(s.charAt(i)) && s.charAt(i + 1) == 's') {
                sb.append(s.substring(i, i + 1));
                sb.append("[*s]");
                ++i;
                continue;
            }
            sb.append(s.substring(i, i + 1));
            sb.append(" ");
        }
        return sb.toString().trim();
    }

    private static void loadAbbrevDict() throws FileNotFoundException, IOException {
        String line;
        InputStream abbrevStream = AbbrevEP.class.getResourceAsStream("abbrev.dat");
        BufferedReader br = new BufferedReader(new InputStreamReader(abbrevStream, "UTF-8"));
        while ((line = br.readLine()) != null) {
            if (Pattern.compile("^\\#").matcher(line).find() || REPattern.emptyLine.matcher(line).find()) continue;
            StringTokenizer st = new StringTokenizer(line, "/");
            String key = st.nextToken().trim();
            String flex = st.nextToken().trim();
            String graph = st.nextToken().trim();
            graph = graph.replaceAll("\\s+", " ");
            if (Pattern.compile("\\s").matcher(key).find()) {
                logger.info((Object)("In abbrev.dat: Abbreviation \"" + key + "\" contains whitespace. Ignoring."));
                continue;
            }
            String[] value = new String[]{flex, graph};
            abbrevDict.put(key, value);
        }
    }

    static {
        try {
            AbbrevEP.loadAbbrevDict();
        }
        catch (FileNotFoundException e) {
            logger.warn((Object)"Could not load abbreviation file", (Throwable)e);
        }
        catch (IOException e) {
            logger.warn((Object)"Could not load abbreviation file", (Throwable)e);
        }
    }
}

