/*
 * Decompiled with CFR 0.152.
 */
package marytts.language.de.features;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import marytts.exceptions.MaryConfigurationException;
import marytts.features.MaryFeatureProcessor;
import marytts.features.MaryGenericFeatureProcessors;
import marytts.features.MaryLanguageFeatureProcessors;
import marytts.modules.phonemiser.AllophoneSet;
import marytts.modules.synthesis.Voice;
import marytts.server.MaryProperties;
import marytts.util.MaryRuntimeUtils;

public class FeatureProcessorManager
extends marytts.features.FeatureProcessorManager {
    public FeatureProcessorManager() {
        this.setupAdditionalFeatureProcessors();
    }

    public FeatureProcessorManager(Voice voice) throws MaryConfigurationException {
        super(voice.getLocale());
        this.setupAdditionalFeatureProcessors();
        this.registerAcousticModels(voice);
    }

    private void setupAdditionalFeatureProcessors() {
        try {
            String[] pos = new String[]{"0", "NN", "NE", "NNm", "ADJA", "ADJD", "CARD", "CARDj", "ORD", "ITJ", "PDS", "PPOSS", "TRUNC", "ADV", "ADVq", "ADVf", "APPR", "APPRbis", "APPRART", "APPO", "APZR", "ART", "ARTdna", "ARTg", "ARTngd", "FM", "KOUI", "KOUS", "KON", "KOKOM", "KOKOMa", "PDAT", "PIS", "PIAT", "PIDAT", "PIDAT2", "PPER", "PPOSAT", "PRELS", "PRELAT", "PRF", "PWS", "PWAT", "PWAV", "PAV", "PTKZU", "PTKNEG", "PTKVZ", "PTKANT", "PTKA", "SGML", "SPELL", "VVFIN", "VVIMP", "VVINF", "VVIZU", "VVPP", "VV", "VAFIN", "VAIMP", "VAINF", "VAPP", "VMFIN", "VMINF", "VMPP", "XY"};
            this.addFeatureProcessor((MaryFeatureProcessor)new MaryLanguageFeatureProcessors.Pos(pos));
            HashMap posConverter = new HashMap();
            this.addFeatureProcessor((MaryFeatureProcessor)new MaryLanguageFeatureProcessors.Gpos(posConverter));
            AllophoneSet allophoneSet = MaryRuntimeUtils.needAllophoneSet((String)"de.allophoneset");
            String[] phones = allophoneSet.getAllophoneNames().toArray(new String[0]);
            String[] phoneValues = new String[phones.length + 1];
            phoneValues[0] = "0";
            System.arraycopy(phones, 0, phoneValues, 1, phones.length);
            this.setupHardcodedPhoneFeatureValues();
            String[] cplaceValues = new String[]{"0", "l", "a", "p", "b", "d", "v", "u", "g"};
            this.phonefeatures2values.put("cplace", cplaceValues);
            String pauseSymbol = allophoneSet.getSilence().name();
            this.setupPhoneFeatureProcessors(allophoneSet, phoneValues, pauseSymbol, this.phonefeatures2values);
            String wordFrequencyFilename = MaryProperties.getProperty((String)"de.wordFrequency.fst");
            InputStream wordFrequencyStream = MaryProperties.getStream((String)"de.wordFrequency.fst");
            String wordFrequencyEncoding = MaryProperties.getProperty((String)"de.wordFrequency.encoding");
            this.addFeatureProcessor((MaryFeatureProcessor)new MaryLanguageFeatureProcessors.WordFrequency(wordFrequencyStream, wordFrequencyFilename, wordFrequencyEncoding));
            String[] phoneClasses = new String[]{"0", "c_labial", "c_alveolar", "c_palatal", "c_labiodental", "c_dental", "c_velar", "c_glottal", "c_uvular", "v_i", "v_u", "v_O", "v_E", "v_EI", "v_@", "v_aU", "v_6", "v_~", "v_a", "v_y", "v_2", "v_e", "v_o", "v_9", "v_OY", "v_Ya", "v_aI"};
            HashMap<String, String> phone2Classes = new HashMap<String, String>();
            phone2Classes.put("I", "v_i");
            phone2Classes.put("i", "v_i");
            phone2Classes.put("i:", "v_i");
            phone2Classes.put("U", "v_u");
            phone2Classes.put("u", "v_u");
            phone2Classes.put("u:", "v_u");
            phone2Classes.put("O", "v_O");
            phone2Classes.put("E", "v_E");
            phone2Classes.put("E:", "v_E");
            phone2Classes.put("EI", "v_EI");
            phone2Classes.put("@", "v_@");
            phone2Classes.put("aU", "v_aU");
            phone2Classes.put("6", "v_6");
            phone2Classes.put("a~", "v_~");
            phone2Classes.put("e~", "v_~");
            phone2Classes.put("o~", "v_~");
            phone2Classes.put("9~", "v_~");
            phone2Classes.put("a", "v_a");
            phone2Classes.put("a:", "v_a");
            phone2Classes.put("y", "v_y");
            phone2Classes.put("y:", "v_y");
            phone2Classes.put("Y", "v_y");
            phone2Classes.put("2", "v_2");
            phone2Classes.put("2:", "v_2");
            phone2Classes.put("e", "v_e");
            phone2Classes.put("e:", "v_e");
            phone2Classes.put("o", "v_o");
            phone2Classes.put("o:", "v_o");
            phone2Classes.put("9", "v_9");
            phone2Classes.put("OY", "v_OY");
            phone2Classes.put("Ya", "v_Ya");
            phone2Classes.put("aI", "v_aI");
            phone2Classes.put("b", "c_labial");
            phone2Classes.put("m", "c_labial");
            phone2Classes.put("p", "c_labial");
            phone2Classes.put("w", "c_labial");
            phone2Classes.put("pf", "c_labial");
            phone2Classes.put("d", "c_alveolar");
            phone2Classes.put("l", "c_alveolar");
            phone2Classes.put("n", "c_alveolar");
            phone2Classes.put("r", "c_alveolar");
            phone2Classes.put("s", "c_alveolar");
            phone2Classes.put("t", "c_alveolar");
            phone2Classes.put("z", "c_alveolar");
            phone2Classes.put("ts", "c_alveolar");
            phone2Classes.put("tS", "c_palatal");
            phone2Classes.put("S", "c_palatal");
            phone2Classes.put("j", "c_palatal");
            phone2Classes.put("Z", "c_palatal");
            phone2Classes.put("f", "c_labiodental");
            phone2Classes.put("v", "c_labiodental");
            phone2Classes.put("D", "c_dental");
            phone2Classes.put("T", "c_dental");
            phone2Classes.put("g", "c_velar");
            phone2Classes.put("k", "c_velar");
            phone2Classes.put("N", "c_velar");
            phone2Classes.put("C", "c_velar");
            phone2Classes.put("x", "c_uvular");
            phone2Classes.put("R", "c_uvular");
            phone2Classes.put("h", "c_glottal");
            phone2Classes.put("?", "c_glottal");
            phone2Classes.put("_", "0");
            MaryGenericFeatureProcessors.NextSegmentNavigator nextSegment = new MaryGenericFeatureProcessors.NextSegmentNavigator();
            MaryGenericFeatureProcessors.NextWordNavigator nextWord = new MaryGenericFeatureProcessors.NextWordNavigator();
            MaryGenericFeatureProcessors.FirstSegmentNextWordNavigator firstSegNextWord = new MaryGenericFeatureProcessors.FirstSegmentNextWordNavigator();
            this.addFeatureProcessor((MaryFeatureProcessor)new MaryLanguageFeatureProcessors.Selection_PhoneClass(phone2Classes, phoneClasses, (MaryGenericFeatureProcessors.TargetElementNavigator)nextSegment));
            this.addFeatureProcessor((MaryFeatureProcessor)new MaryLanguageFeatureProcessors.Pos("next_pos", pos, (MaryGenericFeatureProcessors.TargetElementNavigator)nextWord));
            this.addFeatureProcessor((MaryFeatureProcessor)new MaryLanguageFeatureProcessors.PhoneFeature(allophoneSet, "next_wordbegin_cplace", "cplace", cplaceValues, "_", (MaryGenericFeatureProcessors.TargetElementNavigator)firstSegNextWord));
            this.addFeatureProcessor((MaryFeatureProcessor)new MaryLanguageFeatureProcessors.PhoneFeature(allophoneSet, "next_wordbegin_ctype", "ctype", (String[])this.phonefeatures2values.get("ctype"), "_", (MaryGenericFeatureProcessors.TargetElementNavigator)firstSegNextWord));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Error("Problem building Pos or PhoneSet");
        }
    }

    public Locale getLocale() {
        return Locale.GERMAN;
    }
}

