/*
 * Decompiled with CFR 0.152.
 */
package marytts.unitselection.select;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import marytts.cart.CART;
import marytts.cart.LeafNode;
import marytts.cart.Node;
import marytts.cart.io.HTSCARTReader;
import marytts.exceptions.MaryConfigurationException;
import marytts.features.FeatureDefinition;
import marytts.features.FeatureVector;
import marytts.htsengine.HMMData;
import marytts.htsengine.PhoneTranslator;
import marytts.server.MaryProperties;
import marytts.signalproc.analysis.distance.DistanceComputer;
import marytts.unitselection.data.DiphoneUnit;
import marytts.unitselection.data.Unit;
import marytts.unitselection.select.DiphoneTarget;
import marytts.unitselection.select.HalfPhoneTarget;
import marytts.unitselection.select.JoinCostFeatures;
import marytts.unitselection.select.JoinCostFunction;
import marytts.unitselection.select.Target;

public class JoinModelCost
implements JoinCostFunction {
    protected int nCostComputations = 0;
    private JoinCostFeatures jcf = null;
    CART[] joinTree = null;
    private float f0Weight;
    private FeatureDefinition featureDef = null;
    private boolean debugShowCostGraph = false;

    @Override
    public void init(String configPrefix) throws MaryConfigurationException {
        try {
            String joinFileName = MaryProperties.needFilename(configPrefix + ".joinCostFile");
            InputStream joinPdfStream = MaryProperties.needStream(configPrefix + ".joinPdfFile");
            InputStream joinTreeStream = MaryProperties.needStream(configPrefix + ".joinTreeFile");
            String trickyPhonesFileName = MaryProperties.needFilename(configPrefix + ".trickyPhonesFile");
            this.load(joinFileName, joinPdfStream, joinTreeStream, trickyPhonesFileName);
        }
        catch (IOException ioe) {
            throw new MaryConfigurationException("Problem loading join file", (Throwable)ioe);
        }
    }

    @Override
    @Deprecated
    public void load(String a, InputStream b, String c, float d) {
        throw new RuntimeException("Do not use load() -- use init()");
    }

    public void load(String joinFileName, InputStream joinPdfStream, InputStream joinTreeStream, String trickyPhonesFile) throws IOException, MaryConfigurationException {
        this.jcf = new JoinCostFeatures(joinFileName);
        assert (this.featureDef != null) : "Expected to have a feature definition, but it is null!";
        HTSCARTReader htsReader = new HTSCARTReader();
        int numStates = 1;
        PhoneTranslator phTranslator = new PhoneTranslator(new FileInputStream(trickyPhonesFile));
        try {
            this.joinTree = htsReader.load(numStates, joinTreeStream, joinPdfStream, HMMData.PdfFileFormat.join, this.featureDef, phTranslator);
        }
        catch (Exception e) {
            IOException ioe = new IOException("Cannot load join model trees");
            ioe.initCause(e);
            throw ioe;
        }
    }

    public void setFeatureDefinition(FeatureDefinition def) {
        this.featureDef = def;
    }

    @Override
    public double cost(Target t1, Unit u1, Target t2, Unit u2) {
        if (u1.duration == 0 || u2.duration == 0) {
            return Double.POSITIVE_INFINITY;
        }
        if (u1 instanceof DiphoneUnit) {
            u1 = ((DiphoneUnit)u1).right;
        }
        if (u2 instanceof DiphoneUnit) {
            u2 = ((DiphoneUnit)u2).left;
        }
        if (u1.index + 1 == u2.index) {
            return 0.0;
        }
        double cost = 1.0;
        float[] v1 = this.jcf.getRightJCF(u1.index);
        float[] v2 = this.jcf.getLeftJCF(u2.index);
        double[] diff = new double[v1.length];
        for (int i = 0; i < v1.length; ++i) {
            diff[i] = (double)v1[i] - (double)v2[i];
        }
        assert (this.featureDef != null) : "Feature Definition was not set";
        FeatureVector fv1 = null;
        if (t1 instanceof DiphoneTarget) {
            HalfPhoneTarget hpt1 = ((DiphoneTarget)t1).right;
            assert (hpt1 != null);
            fv1 = hpt1.getFeatureVector();
        } else {
            fv1 = t1.getFeatureVector();
        }
        assert (fv1 != null) : "Target has no feature vector";
        int state = 0;
        Node node = this.joinTree[state].interpretToNode(fv1, 1);
        assert (node instanceof LeafNode.PdfLeafNode) : "The node must be a PdfLeafNode.";
        double[] mean = ((LeafNode.PdfLeafNode)node).getMean();
        double[] variance = ((LeafNode.PdfLeafNode)node).getVariance();
        double distance = DistanceComputer.getNormalizedEuclideanDistance((double[])diff, (double[])mean, (double[])variance);
        return cost += distance;
    }
}

