/*
 * Decompiled with CFR 0.152.
 */
package marytts.unitselection.data;

import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import marytts.exceptions.MaryConfigurationException;
import marytts.features.FeatureDefinition;
import marytts.features.FeatureVector;
import marytts.unitselection.data.FeatureFileReader;
import marytts.util.data.MaryHeader;

public class HalfPhoneFeatureFileReader
extends FeatureFileReader {
    protected FeatureDefinition leftWeights;
    protected FeatureDefinition rightWeights;

    public HalfPhoneFeatureFileReader() {
    }

    public HalfPhoneFeatureFileReader(String fileName) throws IOException, MaryConfigurationException {
        super(fileName);
    }

    @Override
    protected void loadFromStream(String fileName) throws IOException, MaryConfigurationException {
        DataInputStream dis = null;
        dis = new DataInputStream(new BufferedInputStream(new FileInputStream(fileName)));
        this.hdr = new MaryHeader((DataInput)dis);
        if (this.hdr.getType() != 301) {
            throw new IOException("File [" + fileName + "] is not a valid Mary Halfphone Features file.");
        }
        this.leftWeights = new FeatureDefinition(dis);
        this.rightWeights = new FeatureDefinition(dis);
        assert (this.leftWeights.featureEquals(this.rightWeights)) : "Halfphone unit feature file contains incompatible feature definitions for left and right units -- this should not happen!";
        this.featureDefinition = this.leftWeights;
        int numberOfUnits = dis.readInt();
        this.featureVectors = new FeatureVector[numberOfUnits];
        for (int i = 0; i < numberOfUnits; ++i) {
            this.featureVectors[i] = this.featureDefinition.readFeatureVector(i, dis);
        }
    }

    @Override
    protected void loadFromByteBuffer(String fileName) throws IOException, MaryConfigurationException {
        FileInputStream fis = new FileInputStream(fileName);
        FileChannel fc = fis.getChannel();
        MappedByteBuffer bb = fc.map(FileChannel.MapMode.READ_ONLY, 0L, fc.size());
        fis.close();
        this.hdr = new MaryHeader((ByteBuffer)bb);
        if (this.hdr.getType() != 301) {
            throw new MaryConfigurationException("File [" + fileName + "] is not a valid Mary Halfphone Features file.");
        }
        this.leftWeights = new FeatureDefinition(bb);
        this.rightWeights = new FeatureDefinition(bb);
        assert (this.leftWeights.featureEquals(this.rightWeights)) : "Halfphone unit feature file contains incompatible feature definitions for left and right units -- this should not happen!";
        this.featureDefinition = this.leftWeights;
        int numberOfUnits = bb.getInt();
        this.featureVectors = new FeatureVector[numberOfUnits];
        for (int i = 0; i < numberOfUnits; ++i) {
            this.featureVectors[i] = this.featureDefinition.readFeatureVector(i, bb);
        }
    }

    public FeatureDefinition getLeftWeights() {
        return this.leftWeights;
    }

    public FeatureDefinition getRightWeights() {
        return this.rightWeights;
    }
}

