/*
 * Decompiled with CFR 0.152.
 */
package marytts.unitselection.concat;

import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import marytts.unitselection.analysis.ProsodyAnalyzer;
import marytts.unitselection.concat.UnitConcatenator;
import marytts.unitselection.data.TimelineReader;
import marytts.unitselection.data.UnitDatabase;
import marytts.unitselection.select.SelectedUnit;
import marytts.util.MaryUtils;
import marytts.util.data.BufferedDoubleDataSource;
import marytts.util.data.Datagram;
import marytts.util.data.DatagramDoubleDataSource;
import marytts.util.data.DoubleDataSource;
import marytts.util.data.audio.DDSAudioInputStream;
import org.apache.log4j.Logger;

public class BaseUnitConcatenator
implements UnitConcatenator {
    protected Logger logger = MaryUtils.getLogger(this.getClass());
    protected UnitDatabase database;
    protected TimelineReader timeline;
    protected AudioFormat audioformat;
    protected double unitToTimelineSampleRateFactor;
    protected ProsodyAnalyzer prosodyAnalyzer;

    @Override
    public void load(UnitDatabase unitDatabase) {
        this.database = unitDatabase;
        this.timeline = this.database.getAudioTimeline();
        int sampleRate = this.timeline.getSampleRate();
        this.audioformat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, sampleRate, 16, 1, 2, sampleRate, true);
        this.unitToTimelineSampleRateFactor = (double)sampleRate / (double)this.database.getUnitFileReader().getSampleRate();
    }

    @Override
    public AudioFormat getAudioFormat() {
        return this.audioformat;
    }

    @Override
    public AudioInputStream getAudio(List<SelectedUnit> units) throws IOException {
        this.logger.debug((Object)("Getting audio for " + units.size() + " units"));
        this.getDatagramsFromTimeline(units);
        this.determineTargetPitchmarks(units);
        try {
            this.prosodyAnalyzer = new ProsodyAnalyzer(units, this.timeline.getSampleRate());
        }
        catch (Exception e) {
            throw new IOException("Could not analyze prosody!", e);
        }
        return this.generateAudioStream(units);
    }

    protected void getDatagramsFromTimeline(List<SelectedUnit> units) throws IOException {
        for (SelectedUnit unit : units) {
            UnitData unitData = new UnitData();
            unit.setConcatenationData(unitData);
            boolean nSamples = false;
            int unitSize = this.unitToTimeline(unit.getUnit().duration);
            long unitStart = this.unitToTimeline(unit.getUnit().startTime);
            Datagram[] datagrams = this.timeline.getDatagrams(unitStart, (long)unitSize);
            unitData.setFrames(datagrams);
        }
    }

    protected void determineTargetPitchmarks(List<SelectedUnit> units) {
        for (SelectedUnit unit : units) {
            UnitData unitData = (UnitData)unit.getConcatenationData();
            assert (unitData != null) : "Should not have null unitdata here";
            Datagram[] datagrams = unitData.getFrames();
            Datagram[] frames = null;
            if (datagrams != null && datagrams.length > 0) {
                frames = datagrams;
            } else {
                int targetLength = (int)(unit.getTarget().getTargetDurationInSeconds() * (float)this.timeline.getSampleRate());
                frames = new Datagram[]{this.createZeroDatagram(targetLength)};
            }
            int unitDuration = 0;
            for (int i = 0; i < frames.length; ++i) {
                int dur = (int)frames[i].getDuration();
                unitDuration = (int)((long)unitDuration + frames[i].getDuration());
            }
            unitData.setUnitDuration(unitDuration);
            unitData.setFrames(frames);
        }
    }

    protected AudioInputStream generateAudioStream(List<SelectedUnit> units) throws IOException {
        LinkedList<Datagram> datagrams = new LinkedList<Datagram>();
        for (SelectedUnit unit : units) {
            UnitData unitData = (UnitData)unit.getConcatenationData();
            assert (unitData != null) : "Should not have null unitdata here";
            Datagram[] frames = unitData.getFrames();
            assert (frames != null) : "Cannot generate audio from null frames";
            datagrams.addAll(Arrays.asList(frames));
        }
        DatagramDoubleDataSource audioSource = new DatagramDoubleDataSource(datagrams);
        return new DDSAudioInputStream((DoubleDataSource)new BufferedDoubleDataSource((DoubleDataSource)audioSource), this.audioformat);
    }

    protected Datagram createZeroDatagram(int length) {
        return new Datagram((long)length, new byte[2 * length]);
    }

    protected int unitToTimeline(int duration) {
        return (int)((double)duration * this.unitToTimelineSampleRateFactor);
    }

    protected long unitToTimeline(long time) {
        return (long)((double)time * this.unitToTimelineSampleRateFactor);
    }

    public static class UnitData {
        protected int[] pitchmarks;
        protected Datagram[] frames;
        protected Datagram rightContextFrame;
        protected int unitDuration = -1;

        public void setPitchmarks(int[] pitchmarks) {
            this.pitchmarks = pitchmarks;
        }

        public int[] getPitchmarks() {
            return this.pitchmarks;
        }

        public int getPitchmark(int periodIndex) {
            return this.pitchmarks[periodIndex];
        }

        public int getPeriodLength(int periodIndex) {
            if (0 <= periodIndex && periodIndex < this.pitchmarks.length) {
                if (periodIndex > 0) {
                    return this.pitchmarks[periodIndex] - this.pitchmarks[periodIndex - 1];
                }
                return this.pitchmarks[periodIndex];
            }
            return 0;
        }

        public int getNumberOfPitchmarks() {
            return this.pitchmarks.length;
        }

        public void setFrames(Datagram[] frames) {
            this.frames = frames;
        }

        public Datagram[] getFrames() {
            return this.frames;
        }

        public void setFrame(int frameIndex, Datagram frame) {
            this.frames[frameIndex] = frame;
        }

        public Datagram getFrame(int frameIndex) {
            return this.frames[frameIndex];
        }

        public void setRightContextFrame(Datagram aRightContextFrame) {
            this.rightContextFrame = aRightContextFrame;
        }

        public Datagram getRightContextFrame() {
            return this.rightContextFrame;
        }

        public void setUnitDuration(int duration) {
            this.unitDuration = duration;
        }

        public int getUnitDuration() {
            return this.unitDuration;
        }
    }
}

