/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.effects;

import marytts.signalproc.effects.BaseAudioEffect;
import marytts.signalproc.process.FrameOverlapAddSource;
import marytts.signalproc.process.InlineDataProcessor;
import marytts.signalproc.process.LPCWhisperiser;
import marytts.util.data.BufferedDoubleDataSource;
import marytts.util.data.DoubleDataSource;
import marytts.util.math.MathUtils;

public class LpcWhisperiserEffect
extends BaseAudioEffect {
    int frameLength;
    int predictionOrder;
    float amount;
    public static float DEFAULT_AMOUNT = 100.0f;
    public static float MAX_AMOUNT = 100.0f;
    public static float MIN_AMOUNT = 0.0f;

    public LpcWhisperiserEffect() {
        this(16000);
    }

    public LpcWhisperiserEffect(int samplingRate) {
        super(samplingRate);
        this.setExampleParameters("amount" + chParamEquals + "100.0" + chParamSeparator);
        this.strHelpText = this.getHelpText();
    }

    @Override
    public void parseParameters(String param) {
        super.parseParameters(param);
        this.amount = this.expectFloatParameter("amount");
        if (this.amount == NULL_FLOAT_PARAM) {
            this.amount = DEFAULT_AMOUNT;
        }
        this.amount = MathUtils.CheckLimits((float)this.amount, (float)MIN_AMOUNT, (float)MAX_AMOUNT);
        this.frameLength = Integer.getInteger("signalproc.lpcanalysissynthesis.framelength", 512);
        this.predictionOrder = Integer.getInteger("signalproc.lpcwhisperiser.predictionorder", 20);
    }

    @Override
    public DoubleDataSource process(DoubleDataSource input) {
        LPCWhisperiser whisperiser = new LPCWhisperiser(this.predictionOrder, (double)(this.amount / 100.0f));
        FrameOverlapAddSource foas = new FrameOverlapAddSource(input, 3, true, this.frameLength, this.fs, (InlineDataProcessor)whisperiser);
        return new BufferedDoubleDataSource((DoubleDataSource)foas);
    }

    @Override
    public String getHelpText() {
        String strHelp = "Whisper Effect:" + strLineBreak + "Creates a whispered voice by replacing the LPC residual with white noise." + strLineBreak + "Parameter:" + strLineBreak + "   <amount>" + "   Definition : The amount of whisperised voice at the output" + strLineBreak + "   Range      : [" + String.valueOf(MIN_AMOUNT) + "," + String.valueOf(MAX_AMOUNT) + "]" + strLineBreak + "Example:" + strLineBreak + this.getExampleParameters();
        return strHelp;
    }

    @Override
    public String getName() {
        return "Whisper";
    }
}

