/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.effects;

import marytts.signalproc.effects.BaseAudioEffect;
import marytts.util.data.DoubleDataSource;
import marytts.util.math.MathUtils;

public class HMMF0ScaleEffect
extends BaseAudioEffect {
    public float f0Scale;
    public static float NO_MODIFICATION = 1.0f;
    public static float DEFAULT_F0_SCALE = 2.0f;
    public static float MAX_F0_SCALE = 3.0f;
    public static float MIN_F0_SCALE = 0.0f;

    public HMMF0ScaleEffect() {
        super(16000);
        this.setHMMEffect(true);
        this.setExampleParameters("f0Scale" + chParamEquals + Float.toString(DEFAULT_F0_SCALE) + chParamSeparator);
    }

    @Override
    public void parseParameters(String param) {
        super.parseParameters(param);
        this.f0Scale = this.expectFloatParameter("f0Scale");
        if (this.f0Scale == NULL_FLOAT_PARAM) {
            this.f0Scale = DEFAULT_F0_SCALE;
        }
        this.f0Scale = MathUtils.CheckLimits((float)this.f0Scale, (float)MIN_F0_SCALE, (float)MAX_F0_SCALE);
    }

    @Override
    public DoubleDataSource process(DoubleDataSource input) {
        return input;
    }

    @Override
    public String getHelpText() {
        String strHelp = "F0 scaling effect for HMM voices:" + strLineBreak + "All voiced f0 values are multiplied by <f0Scale> for HMM voices." + strLineBreak + "This operation effectively scales the range of f0 values." + strLineBreak + "Note that mean f0 is preserved during the operation." + strLineBreak + "Parameter:" + strLineBreak + "   <f0Scale>" + "   Definition : Scale ratio for modifying the dynamic range of the f0 contour" + strLineBreak + "                If f0Scale>1.0, the range is expanded (i.e. voice with more variable pitch)" + strLineBreak + "                If f0Scale<1.0, the range is compressed (i.e. more monotonic voice)" + strLineBreak + "                If f0Scale=1.0 results in no changes in range" + strLineBreak + "   Range      : [" + String.valueOf(MIN_F0_SCALE) + "," + String.valueOf(MAX_F0_SCALE) + "]" + strLineBreak + "Example:" + strLineBreak + this.getExampleParameters();
        return strHelp;
    }

    @Override
    public String getName() {
        return "F0Scale";
    }
}

