/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.effects;

import marytts.signalproc.effects.BaseAudioEffect;
import marytts.signalproc.filter.BandPassFilter;
import marytts.signalproc.filter.BandRejectFilter;
import marytts.signalproc.filter.HighPassFilter;
import marytts.signalproc.filter.LowPassFilter;
import marytts.signalproc.process.FrameOverlapAddSource;
import marytts.signalproc.process.InlineDataProcessor;
import marytts.util.data.BufferedDoubleDataSource;
import marytts.util.data.DoubleDataSource;
import marytts.util.math.MathUtils;
import marytts.util.signal.SignalProcUtils;

public class FilterEffectBase
extends BaseAudioEffect {
    double cutOffFreqInHz1;
    double cutOffFreqInHz2;
    int filterType;
    int frameLength;
    double normalizedCutOffFreq1;
    double normalizedCutOffFreq2;
    InlineDataProcessor filter;
    public static int NULL_FILTER = 0;
    public static int LOWPASS_FILTER = 1;
    public static int HIGHPASS_FILTER = 2;
    public static int BANDPASS_FILTER = 3;
    public static int BANDREJECT_FILTER = 4;
    public static int DEFAULT_FILTER = BANDPASS_FILTER;
    public static double DEFAULT_CUTOFF1 = 500.0;
    public static double DEFAULT_CUTOFF2 = 2000.0;
    double MIN_CUTOFF1;
    double MAX_CUTOFF1;
    double MAX_CUTOFF2;
    double MIN_CUTOFF2;

    public FilterEffectBase() {
        this(4000.0, 16000);
    }

    public FilterEffectBase(double cutOffHz, int samplingRate, int type) {
        super(samplingRate);
        this.setExampleParameters("type" + chParamEquals + String.valueOf(BANDPASS_FILTER) + chParamSeparator + " " + "fc1" + chParamEquals + String.valueOf(DEFAULT_CUTOFF1) + chParamSeparator + " " + "fc2" + chParamEquals + String.valueOf(DEFAULT_CUTOFF2));
        this.strHelpText = this.getHelpText();
        this.cutOffFreqInHz1 = cutOffHz;
        this.cutOffFreqInHz2 = -1.0;
        this.filterType = type;
        this.MIN_CUTOFF1 = 20.0;
        this.MAX_CUTOFF1 = 0.5 * (double)samplingRate - 20.0;
        this.MIN_CUTOFF2 = 20.0;
        this.MAX_CUTOFF2 = 0.5 * (double)samplingRate - 20.0;
    }

    public FilterEffectBase(double cutOffHz, int samplingRate) {
        this(cutOffHz, samplingRate, LOWPASS_FILTER);
    }

    public FilterEffectBase(double cutOffHz1, double cutOffHz2, int samplingRate, int type) {
        super(samplingRate);
        this.setExampleParameters("type" + chParamEquals + String.valueOf(BANDPASS_FILTER) + chParamSeparator + " " + "fc1" + chParamEquals + String.valueOf(DEFAULT_CUTOFF1) + chParamSeparator + " " + "fc2" + chParamEquals + String.valueOf(DEFAULT_CUTOFF2));
        this.strHelpText = this.getHelpText();
        this.cutOffFreqInHz1 = cutOffHz1;
        this.cutOffFreqInHz2 = cutOffHz2;
        this.filterType = type;
        this.MIN_CUTOFF1 = 20.0;
        this.MAX_CUTOFF1 = 0.5 * (double)samplingRate - 20.0;
        this.MIN_CUTOFF2 = 20.0;
        this.MAX_CUTOFF2 = 0.5 * (double)samplingRate - 20.0;
    }

    public FilterEffectBase(double cutOffHz1, double cutOffHz2, int samplingRate) {
        this(cutOffHz1, cutOffHz2, samplingRate, BANDPASS_FILTER);
    }

    public FilterEffectBase(int samplingRate) {
        super(samplingRate);
        this.setExampleParameters("type" + chParamEquals + String.valueOf(BANDPASS_FILTER) + chParamSeparator + " " + "fc1" + chParamEquals + String.valueOf(DEFAULT_CUTOFF1) + chParamSeparator + " " + "fc2" + chParamEquals + String.valueOf(DEFAULT_CUTOFF2));
        this.strHelpText = this.getHelpText();
        this.cutOffFreqInHz1 = -1.0;
        this.cutOffFreqInHz2 = -1.0;
        this.filterType = NULL_FILTER;
        this.MIN_CUTOFF1 = 20.0;
        this.MAX_CUTOFF1 = 0.5 * (double)samplingRate - 20.0;
        this.MIN_CUTOFF2 = 20.0;
        this.MAX_CUTOFF2 = 0.5 * (double)samplingRate - 20.0;
    }

    @Override
    public void parseParameters(String param) {
        super.parseParameters(param);
        this.filterType = this.expectIntParameter("type");
        if (this.filterType == NULL_INT_PARAM) {
            this.filterType = DEFAULT_FILTER;
        }
        this.cutOffFreqInHz1 = this.filterType == LOWPASS_FILTER || this.filterType == HIGHPASS_FILTER ? this.expectDoubleParameter("fc1") : this.expectDoubleParameter("fc1");
        if (this.cutOffFreqInHz1 == NULL_DOUBLE_PARAM) {
            this.cutOffFreqInHz1 = DEFAULT_CUTOFF1;
        }
        this.cutOffFreqInHz2 = this.expectDoubleParameter("fc2");
        if (this.cutOffFreqInHz2 == NULL_DOUBLE_PARAM) {
            this.cutOffFreqInHz2 = DEFAULT_CUTOFF2;
        }
        this.cutOffFreqInHz1 = MathUtils.CheckLimits((double)this.cutOffFreqInHz1, (double)this.MIN_CUTOFF1, (double)this.MAX_CUTOFF1);
        this.cutOffFreqInHz2 = MathUtils.CheckLimits((double)this.cutOffFreqInHz2, (double)this.MIN_CUTOFF1, (double)this.MAX_CUTOFF2);
        if (this.cutOffFreqInHz2 < this.cutOffFreqInHz1) {
            double tmp = this.cutOffFreqInHz1;
            this.cutOffFreqInHz1 = this.cutOffFreqInHz2;
            this.cutOffFreqInHz2 = tmp;
        }
        this.initialise();
    }

    public void initialise() {
        this.frameLength = 8 * SignalProcUtils.getDFTSize((int)this.fs);
        this.normalizedCutOffFreq1 = this.cutOffFreqInHz1 / (double)this.fs;
        this.normalizedCutOffFreq2 = this.cutOffFreqInHz2 / (double)this.fs;
        this.filter = null;
        if (this.filterType == LOWPASS_FILTER && this.normalizedCutOffFreq1 > 0.0) {
            this.filter = new LowPassFilter(this.normalizedCutOffFreq1);
        } else if (this.filterType == HIGHPASS_FILTER && this.normalizedCutOffFreq1 > 0.0) {
            this.filter = new HighPassFilter(this.normalizedCutOffFreq1);
        } else if (this.filterType == BANDPASS_FILTER && this.normalizedCutOffFreq1 > 0.0 && this.normalizedCutOffFreq2 > 0.0) {
            if (this.normalizedCutOffFreq1 > this.normalizedCutOffFreq2) {
                double tmp = this.normalizedCutOffFreq1;
                this.normalizedCutOffFreq1 = this.normalizedCutOffFreq2;
                this.normalizedCutOffFreq2 = tmp;
            }
            this.filter = new BandPassFilter(this.normalizedCutOffFreq1, this.normalizedCutOffFreq2);
        } else if (this.filterType == BANDREJECT_FILTER && this.normalizedCutOffFreq1 > 0.0 && this.normalizedCutOffFreq2 > 0.0) {
            if (this.normalizedCutOffFreq1 > this.normalizedCutOffFreq2) {
                double tmp = this.normalizedCutOffFreq1;
                this.normalizedCutOffFreq1 = this.normalizedCutOffFreq2;
                this.normalizedCutOffFreq2 = tmp;
            }
            this.filter = new BandRejectFilter(this.normalizedCutOffFreq1, this.normalizedCutOffFreq2);
        }
    }

    @Override
    public DoubleDataSource process(DoubleDataSource input) {
        if (this.filter != null) {
            FrameOverlapAddSource foas = new FrameOverlapAddSource(input, 3, true, this.frameLength, this.fs, this.filter);
            return new BufferedDoubleDataSource((DoubleDataSource)foas);
        }
        return input;
    }

    @Override
    public String getHelpText() {
        String strRange1 = "";
        for (int i = LOWPASS_FILTER; i < BANDREJECT_FILTER; ++i) {
            strRange1 = strRange1 + String.valueOf(i) + ",";
        }
        strRange1 = strRange1 + String.valueOf(BANDREJECT_FILTER);
        String strRange2 = "[0.0, fs/2.0] where fs is the sampling rate in Hz";
        String strHelp = "FIR filtering:" + strLineBreak + "Filters the input signal by an FIR filter." + strLineBreak + "Parameters:" + strLineBreak + "   <type>" + strLineBreak + "   Definition : Type of filter (1:Lowpass, 2:Highpass, 3:Bandpass, 4:Bandreject)" + strLineBreak + "   Range      : {" + strRange1 + "}" + strLineBreak + "   <fc>" + "   Definition : Cutoff frequency in Hz for lowpass and highpass filters" + strLineBreak + "   Range      : " + strRange2 + strLineBreak + "   <fc1>" + "   Definition : Lower frequency cutoff in Hz for bandpass and bandreject filters" + strLineBreak + "   Range      : " + strRange2 + strLineBreak + "   <fc2>" + "   Definition : Higher frequency cutoff in Hz for bandpass and bandreject filters" + strLineBreak + "   Range      : " + strRange2 + strLineBreak + "Example: (A band-pass filter)" + strLineBreak + this.getExampleParameters();
        return strHelp;
    }

    @Override
    public String getName() {
        return "FIRFilter";
    }
}

