/*
 * Decompiled with CFR 0.152.
 */
package marytts.server.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import marytts.server.Request;
import marytts.server.http.MaryHttpServerUtils;
import marytts.util.MaryUtils;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.entity.ContentOutputStream;
import org.apache.http.nio.entity.ProducingNHttpEntity;
import org.apache.http.nio.util.ByteBufferAllocator;
import org.apache.http.nio.util.ContentOutputBuffer;
import org.apache.http.nio.util.HeapByteBufferAllocator;
import org.apache.http.nio.util.SharedOutputBuffer;
import org.apache.log4j.Logger;

public class AudioStreamNHttpEntity
extends AbstractHttpEntity
implements ProducingNHttpEntity,
Runnable {
    private Request maryRequest;
    private AudioInputStream audio;
    private AudioFileFormat.Type audioType;
    private Logger logger;
    private Object mutex;
    private SharedOutputBuffer out;

    public AudioStreamNHttpEntity(Request maryRequest) {
        this.maryRequest = maryRequest;
        this.audio = maryRequest.getAudio();
        this.audioType = maryRequest.getAudioFileFormat().getType();
        this.setContentType(MaryHttpServerUtils.getMimeType(this.audioType));
        this.mutex = new Object();
    }

    public void finish() {
        assert (this.logger != null) : "we should never be able to write if run() is not called";
        this.logger.info((Object)"Completed sending streaming audio");
        this.maryRequest = null;
        this.audio = null;
        this.audioType = null;
        this.logger = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void produceContent(ContentEncoder encoder, IOControl ioctrl) throws IOException {
        if (this.out == null) {
            Object object = this.mutex;
            synchronized (object) {
                this.out = new SharedOutputBuffer(8192, ioctrl, (ByteBufferAllocator)new HeapByteBufferAllocator());
                this.mutex.notify();
            }
        }
        while (!encoder.isCompleted()) {
            this.out.produceContent(encoder);
        }
    }

    public long getContentLength() {
        return -1L;
    }

    public boolean isRepeatable() {
        return false;
    }

    public boolean isStreaming() {
        return true;
    }

    public InputStream getContent() {
        return null;
    }

    public void writeTo(OutputStream outstream) throws IOException {
        throw new RuntimeException("Should not be called");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.logger = MaryUtils.getLogger((String)Thread.currentThread().getName());
        while (this.out == null) {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    this.mutex.wait();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
        assert (this.out != null);
        ContentOutputStream outStream = new ContentOutputStream((ContentOutputBuffer)this.out);
        try {
            AudioSystem.write(this.audio, this.audioType, (OutputStream)outStream);
            outStream.flush();
            outStream.close();
            this.logger.info((Object)"Finished writing output");
        }
        catch (IOException ioe) {
            this.logger.info((Object)"Cannot write output, client seems to have disconnected. ", (Throwable)ioe);
            this.maryRequest.abort();
        }
    }
}

