/*
 * Decompiled with CFR 0.152.
 */
package marytts.modules.phonemiser;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import marytts.cart.CART;
import marytts.cart.LeafNode;
import marytts.cart.io.MaryCARTReader;
import marytts.exceptions.MaryConfigurationException;
import marytts.features.FeatureDefinition;
import marytts.features.FeatureVector;
import marytts.modules.phonemiser.AllophoneSet;
import marytts.modules.phonemiser.Syllabifier;

public class TrainedLTS {
    public static final String PREDICTED_STRING_FEATURENAME = "predicted-string";
    private CART tree;
    private FeatureDefinition featureDefinition;
    private int indexPredictedFeature;
    private int context;
    private AllophoneSet allophoneSet;
    private boolean convertToLowercase;
    protected boolean removeTrailingOneFromPhones = true;

    public TrainedLTS(AllophoneSet aPhonSet, InputStream treeStream, boolean removeTrailingOneFromPhones) throws IOException, MaryConfigurationException {
        this.allophoneSet = aPhonSet;
        this.loadTree(treeStream);
        this.removeTrailingOneFromPhones = removeTrailingOneFromPhones;
    }

    public TrainedLTS(AllophoneSet aPhonSet, InputStream treeStream) throws IOException, MaryConfigurationException {
        this(aPhonSet, treeStream, true);
    }

    public TrainedLTS(AllophoneSet aPhonSet, CART predictionTree) {
        this.allophoneSet = aPhonSet;
        this.tree = predictionTree;
        this.featureDefinition = this.tree.getFeatureDefinition();
        this.indexPredictedFeature = this.featureDefinition.getFeatureIndex(PREDICTED_STRING_FEATURENAME);
        Properties props = this.tree.getProperties();
        if (props == null) {
            throw new IllegalArgumentException("Prediction tree does not contain properties");
        }
        this.convertToLowercase = Boolean.parseBoolean(props.getProperty("lowercase"));
        this.context = Integer.parseInt(props.getProperty("context"));
    }

    public void loadTree(InputStream treeStream) throws IOException, MaryConfigurationException {
        MaryCARTReader cartReader = new MaryCARTReader();
        this.tree = cartReader.loadFromStream(treeStream);
        this.featureDefinition = this.tree.getFeatureDefinition();
        this.indexPredictedFeature = this.featureDefinition.getFeatureIndex(PREDICTED_STRING_FEATURENAME);
        this.convertToLowercase = false;
        Properties props = this.tree.getProperties();
        if (props == null) {
            throw new IllegalArgumentException("Prediction tree does not contain properties");
        }
        this.convertToLowercase = Boolean.parseBoolean(props.getProperty("lowercase"));
        this.context = Integer.parseInt(props.getProperty("context"));
    }

    public String predictPronunciation(String graphemes) {
        if (this.convertToLowercase) {
            graphemes = graphemes.toLowerCase(this.allophoneSet.getLocale());
        }
        String returnStr = "";
        for (int i = 0; i < graphemes.length(); ++i) {
            byte[] byteFeatures = new byte[2 * this.context + 1];
            for (int fnr = 0; fnr < 2 * this.context + 1; ++fnr) {
                int pos = i - this.context + fnr;
                String grAtPos = pos < 0 || pos >= graphemes.length() ? "null" : graphemes.substring(pos, pos + 1);
                try {
                    byteFeatures[fnr] = this.tree.getFeatureDefinition().getFeatureValueAsByte(fnr, grAtPos);
                    continue;
                }
                catch (IllegalArgumentException iae) {
                    byteFeatures[fnr] = this.tree.getFeatureDefinition().getFeatureValueAsByte(fnr, "null");
                }
            }
            FeatureVector fv = new FeatureVector(byteFeatures, new short[0], new float[0], 0);
            LeafNode.StringAndFloatLeafNode leaf = (LeafNode.StringAndFloatLeafNode)this.tree.interpretToNode(fv, 0);
            String prediction = leaf.mostProbableString(this.featureDefinition, this.indexPredictedFeature);
            returnStr = returnStr + prediction.substring(1, prediction.length() - 1);
        }
        return returnStr;
    }

    public String syllabify(String phones) {
        Syllabifier sfr = new Syllabifier(this.allophoneSet, this.removeTrailingOneFromPhones);
        return sfr.syllabify(phones);
    }

    public static void main(String[] args) throws IOException, MaryConfigurationException {
        String line;
        if (args.length < 2) {
            System.out.println("Usage:");
            System.out.println("java marytts.modules.phonemiser.TrainedLTS allophones.xml lts-model.lts [removeTrailingOneFromPhones]");
            System.exit(0);
        }
        String allophoneFile = args[0];
        String ltsFile = args[1];
        boolean myRemoveTrailingOneFromPhones = true;
        if (args.length > 2) {
            myRemoveTrailingOneFromPhones = Boolean.getBoolean(args[2]);
        }
        TrainedLTS lts = new TrainedLTS(AllophoneSet.getAllophoneSet((String)allophoneFile), new FileInputStream(ltsFile), myRemoveTrailingOneFromPhones);
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        while ((line = br.readLine()) != null) {
            line = line.trim();
            String pron = lts.predictPronunciation(line);
            String syl = lts.syllabify(pron);
            String sylStripped = syl.replaceAll("[-' ]+", "");
            System.out.println(sylStripped);
        }
    }
}

