/*
 * Decompiled with CFR 0.152.
 */
package marytts.modules;

import com.sun.speech.freetts.FeatureSet;
import com.sun.speech.freetts.Item;
import com.sun.speech.freetts.Relation;
import com.sun.speech.freetts.Utterance;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import marytts.datatypes.MaryData;
import marytts.datatypes.MaryDataType;
import marytts.datatypes.MaryXML;
import marytts.modules.InternalModule;
import marytts.modules.XML2UttBase;
import marytts.modules.phonemiser.AllophoneSet;
import marytts.modules.phonemiser.Syllabifier;
import marytts.modules.synthesis.FreeTTSVoices;
import marytts.modules.synthesis.Voice;
import marytts.util.MaryUtils;
import marytts.util.dom.MaryDomUtils;
import marytts.util.dom.MaryNormalisedWriter;
import org.apache.log4j.Level;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class Utt2XMLBase
extends InternalModule {
    protected DocumentBuilderFactory factory = null;
    protected DocumentBuilder docBuilder = null;

    public Utt2XMLBase(String name, MaryDataType input, MaryDataType output, Locale locale) {
        super(name, input, output, locale);
    }

    @Override
    public void startup() throws Exception {
        if (this.factory == null) {
            this.factory = DocumentBuilderFactory.newInstance();
            this.factory.setNamespaceAware(true);
        }
        if (this.docBuilder == null) {
            this.docBuilder = this.factory.newDocumentBuilder();
        }
        super.startup();
        FreeTTSVoices.load();
    }

    @Override
    public MaryData process(MaryData d) throws Exception {
        Document doc = MaryXML.newDocument();
        Element root = doc.getDocumentElement();
        Locale locale = d.getLocale();
        if (locale != null) {
            root.setAttribute("xml:lang", MaryUtils.locale2xmllang((Locale)locale));
        }
        Element paragraph = MaryXML.appendChildElement(root, "p");
        List<Utterance> utterances = d.getUtterances();
        for (Utterance utterance : utterances) {
            Element insertHere = paragraph;
            if (this.logger.getEffectiveLevel().equals((Object)Level.DEBUG)) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                utterance.dump(pw, 2, this.name(), true);
                this.logger.debug((Object)("Converting the following Utterance to XML:\n" + sw.toString()));
            }
            Voice maryVoice = null;
            if (utterance.getVoice() != null) {
                maryVoice = FreeTTSVoices.getMaryVoice(utterance.getVoice());
            }
            if (maryVoice != null) {
                Element newVoice;
                if (insertHere.getTagName().equals("voice")) {
                    if (!maryVoice.hasName(insertHere.getAttribute("name"))) {
                        Element parent = (Element)insertHere.getParentNode();
                        newVoice = MaryXML.createElement(doc, "voice");
                        parent.appendChild(newVoice);
                        newVoice.setAttribute("name", maryVoice.getName());
                        insertHere = newVoice;
                    }
                } else {
                    Element lastChild = MaryDomUtils.getLastChildElement((Element)insertHere);
                    if (lastChild != null && lastChild.getTagName().equals("voice") && maryVoice.hasName(lastChild.getAttribute("name"))) {
                        insertHere = lastChild;
                    } else {
                        newVoice = MaryXML.createElement(doc, "voice");
                        insertHere.appendChild(newVoice);
                        newVoice.setAttribute("name", maryVoice.getName());
                        insertHere = newVoice;
                    }
                }
                Element prosody = this.insertProsodySettings(insertHere, (FeatureSet)utterance);
                if (prosody != null) {
                    insertHere = prosody;
                }
            }
            Element sentence = MaryXML.createElement(doc, "s");
            insertHere.appendChild(sentence);
            this.fillSentence(sentence, utterance);
        }
        if (this.logger.getEffectiveLevel().equals((Object)Level.DEBUG)) {
            this.logger.debug((Object)"Constructed the following XML structure:");
            MaryNormalisedWriter mnw = new MaryNormalisedWriter();
            ByteArrayOutputStream debugOut = new ByteArrayOutputStream();
            mnw.output((Node)doc, (OutputStream)debugOut);
            this.logger.debug((Object)debugOut.toString());
        }
        MaryData output = new MaryData(this.outputType(), d.getLocale());
        output.setDocument(doc);
        return output;
    }

    protected final void fillSentence(Element sentence, Utterance utterance) {
        Item tokenItem;
        Document doc = sentence.getOwnerDocument();
        Relation tokenRelation = utterance.getRelation("Token");
        if (tokenRelation == null) {
            return;
        }
        Relation phraseRelation = utterance.getRelation("Phrase");
        Item phraseItem = null;
        if (phraseRelation != null) {
            for (phraseItem = phraseRelation.getHead(); phraseItem != null; phraseItem = phraseItem.getNext()) {
                Element phrase = MaryXML.createElement(doc, "phrase");
                sentence.appendChild(phrase);
                Element insertHere = phrase;
                while (tokenItem != null && tokenItem.getDaughter().findItem("R:Phrase.parent").equals(phraseItem)) {
                    Element prosody;
                    FeatureSet tokenFeatures = tokenItem.getFeatures();
                    if (tokenFeatures.isPresent("prosody-start") && (prosody = this.insertProsodySettings(insertHere, tokenFeatures)) != null) {
                        insertHere = prosody;
                    }
                    this.insertToken(tokenItem, phrase, true);
                    if (tokenFeatures.isPresent("prosody-end")) {
                        assert (insertHere.getTagName().equals("prosody"));
                        insertHere = (Element)insertHere.getParentNode();
                    }
                    tokenItem = tokenItem.getNext();
                }
            }
        } else {
            Element insertHere = sentence;
            for (tokenItem = tokenRelation.getHead(); tokenItem != null; tokenItem = tokenItem.getNext()) {
                Element prosody;
                FeatureSet tokenFeatures = tokenItem.getFeatures();
                if (tokenFeatures.isPresent("prosody-start") && (prosody = this.insertProsodySettings(insertHere, tokenFeatures)) != null) {
                    insertHere = prosody;
                }
                this.insertToken(tokenItem, insertHere);
                if (!tokenFeatures.isPresent("prosody-end") || !insertHere.getTagName().equals("prosody")) continue;
                insertHere = (Element)insertHere.getParentNode();
            }
        }
    }

    protected void insertToken(Item tokenItem, Element parent) {
        this.insertToken(tokenItem, parent, false);
    }

    protected void insertToken(Item tokenItem, Element parent, boolean deep) {
        String puncString;
        Element markEl;
        String markStr;
        StringTokenizer markTok;
        String marks;
        AllophoneSet allophoneSet;
        if (tokenItem == null || parent == null) {
            throw new NullPointerException("Null arguments to insertToken()");
        }
        Document doc = parent.getOwnerDocument();
        Voice maryVoice = null;
        if (tokenItem.getUtterance().getVoice() != null) {
            maryVoice = FreeTTSVoices.getMaryVoice(tokenItem.getUtterance().getVoice());
        }
        if ((allophoneSet = (AllophoneSet)tokenItem.getUtterance().getObject("allophoneset")) == null) {
            throw new NullPointerException("Utterance does not have an AllophoneSet -- should have been set in XML2UttBase.process()");
        }
        Element insertHere = parent;
        boolean needMtu = false;
        boolean insertPhonesFromToken = tokenItem.getFeatures().isPresent("phones");
        Item testWordItem = null;
        if (tokenItem.getFeatures().isPresent("precedingMarks")) {
            String marks2 = tokenItem.getFeatures().getString("precedingMarks");
            StringTokenizer markTok2 = new StringTokenizer(marks2, ",");
            while (markTok2.hasMoreTokens()) {
                String markStr2 = markTok2.nextToken();
                Element markEl2 = MaryXML.createElement(doc, "mark");
                markEl2.setAttribute("name", markStr2);
                insertHere.appendChild(markEl2);
            }
        }
        if (tokenItem.getFeatures().isPresent("precedingBoundaryTone") || tokenItem.getFeatures().isPresent("precedingBoundaryBreakindex") || tokenItem.getFeatures().isPresent("precedingBoundaryDuration")) {
            Element boundary = MaryXML.createElement(doc, "boundary");
            insertHere.appendChild(boundary);
            if (tokenItem.getFeatures().isPresent("precedingBoundaryTone")) {
                boundary.setAttribute("tone", tokenItem.getFeatures().getString("precedingBoundaryTone"));
            }
            if (tokenItem.getFeatures().isPresent("precedingBoundaryBreakindex")) {
                boundary.setAttribute("breakindex", tokenItem.getFeatures().getString("precedingBoundaryBreakindex"));
            }
            if (tokenItem.getFeatures().isPresent("precedingBoundaryDuration")) {
                boundary.setAttribute("duration", tokenItem.getFeatures().getString("precedingBoundaryDuration"));
            }
        }
        if (tokenItem.getNthDaughter(1) != null || (testWordItem = tokenItem.getDaughter()) != null && !testWordItem.toString().equals(tokenItem.toString().toLowerCase())) {
            needMtu = true;
            Element mtu = MaryXML.createElement(doc, "mtu");
            parent.appendChild(mtu);
            mtu.setAttribute("orig", tokenItem.toString());
            insertHere = mtu;
        }
        FeatureSet tokenFeatureSet = tokenItem.getFeatures();
        Item tokenDaughter = tokenItem.getDaughter();
        if (tokenDaughter == null) {
            Element t = MaryXML.createElement(doc, "t");
            insertHere.appendChild(t);
            MaryDomUtils.setTokenText(t, tokenItem.toString());
            if (insertPhonesFromToken) {
                String[] phones = (String[])tokenItem.getFeatures().getObject("phones");
                t.setAttribute("ph", this.phoneArray2phoneString(allophoneSet, phones));
                insertPhonesFromToken = false;
            }
            if (tokenFeatureSet.isPresent("accent")) {
                t.setAttribute("accent", tokenFeatureSet.getString("accent"));
            }
        }
        while (tokenDaughter != null) {
            Item sylStruct;
            Item wordItem = tokenDaughter.getItemAs("Word");
            Element t = null;
            StringBuilder sampa = new StringBuilder();
            if (wordItem != null) {
                FeatureSet wordFeatureSet;
                String[] phones;
                t = MaryXML.createElement(doc, "t");
                insertHere.appendChild(t);
                String tokenText = null;
                tokenText = needMtu ? wordItem.toString() : tokenItem.toString();
                MaryDomUtils.setTokenText(t, tokenText);
                if (insertPhonesFromToken) {
                    phones = (String[])tokenItem.getFeatures().getObject("phones");
                    t.setAttribute("ph", this.phoneArray2phoneString(allophoneSet, phones));
                    insertPhonesFromToken = false;
                } else if (wordItem.getFeatures().isPresent("phones")) {
                    phones = (String[])wordItem.getFeatures().getObject("phones");
                    t.setAttribute("ph", this.phoneArray2phoneString(allophoneSet, phones));
                }
                if (tokenFeatureSet.isPresent("accent")) {
                    t.setAttribute("accent", tokenFeatureSet.getString("accent"));
                }
                if ((wordFeatureSet = wordItem.getFeatures()).isPresent("pos")) {
                    t.setAttribute("pos", wordFeatureSet.getString("pos"));
                }
            }
            if ((sylStruct = tokenDaughter.getItemAs("SylStructure")) != null && sylStruct.hasDaughters()) {
                for (Item syllableItem = sylStruct.getDaughter(); syllableItem != null; syllableItem = syllableItem.getNext()) {
                    if (sampa.length() > 0) {
                        sampa.append(" - ");
                    }
                    sampa.append(this.insertSyllable(syllableItem, t, deep));
                }
            }
            if (sampa.length() > 0) {
                t.setAttribute("ph", sampa.toString());
            }
            tokenDaughter = tokenDaughter.getNext();
        }
        if (tokenItem.getFeatures().isPresent("prePuncMarks")) {
            marks = tokenItem.getFeatures().getString("prePuncMarks");
            markTok = new StringTokenizer(marks, ",");
            while (markTok.hasMoreTokens()) {
                markStr = markTok.nextToken();
                markEl = MaryXML.createElement(doc, "mark");
                markEl.setAttribute("name", markStr);
                insertHere.appendChild(markEl);
            }
        }
        if (tokenItem.getFeatures().isPresent("punc") && !(puncString = tokenItem.getFeatures().getString("punc")).equals("")) {
            Element punctuation = MaryXML.createElement(doc, "t");
            MaryDomUtils.setTokenText(punctuation, puncString);
            String pos = null;
            pos = puncString.equals(",") ? "$," : "$PUNCT";
            punctuation.setAttribute("pos", pos);
            parent.appendChild(punctuation);
        }
        if (tokenItem.getFeatures().isPresent("followingMarks")) {
            marks = tokenItem.getFeatures().getString("followingMarks");
            markTok = new StringTokenizer(marks, ",");
            while (markTok.hasMoreTokens()) {
                markStr = markTok.nextToken();
                markEl = MaryXML.createElement(doc, "mark");
                markEl.setAttribute("name", markStr);
                insertHere.appendChild(markEl);
            }
        }
        if (this.tokenItemHasFollowingBoundary(tokenItem)) {
            Element boundary = MaryXML.createElement(doc, "boundary");
            insertHere.appendChild(boundary);
            if (tokenItem.getFeatures().isPresent("followingBoundaryTone")) {
                boundary.setAttribute("tone", tokenItem.getFeatures().getString("followingBoundaryTone"));
            }
            int breakindex = 0;
            if (tokenItem.getFeatures().isPresent("followingBoundaryBreakindex")) {
                String breakindexString = tokenItem.getFeatures().getString("followingBoundaryBreakindex");
                boundary.setAttribute("breakindex", breakindexString);
                try {
                    breakindex = Integer.parseInt(breakindexString);
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
            if (tokenItem.getFeatures().isPresent("followingBoundaryDuration")) {
                boundary.setAttribute("duration", tokenItem.getFeatures().getString("followingBoundaryDuration"));
            } else if (breakindex >= 4) {
                boundary.setAttribute("duration", "400");
            } else if (breakindex == 3) {
                boundary.setAttribute("duration", "200");
            }
        }
    }

    private boolean tokenItemHasFollowingBoundary(Item tokenItem) {
        assert (tokenItem.getOwnerRelation().getName().equals("Token"));
        return tokenItem.getFeatures().isPresent("followingBoundaryTone") || tokenItem.getFeatures().isPresent("followingBoundaryBreakindex") || tokenItem.getFeatures().isPresent("followingBoundaryDuration");
    }

    protected String insertSyllable(Item syllableItem, Element token, boolean deep) {
        String endtone;
        String stressString;
        if (syllableItem == null || token == null) {
            throw new NullPointerException("Null arguments to insertSyllable()");
        }
        if (!token.getTagName().equals("t")) {
            throw new IllegalArgumentException("Syllables can only be inserted in <t> elements");
        }
        Document doc = token.getOwnerDocument();
        Element syllable = null;
        StringBuilder sampa = new StringBuilder();
        if (deep) {
            syllable = MaryXML.createElement(doc, "syllable");
            token.appendChild(syllable);
        }
        if (syllableItem.getFeatures().isPresent("accent")) {
            String accentString = syllableItem.getFeatures().getString("accent");
            if (deep) {
                syllable.setAttribute("accent", accentString);
            }
            token.setAttribute("accent", accentString);
        }
        if (syllableItem.getFeatures().isPresent("stress") && !(stressString = syllableItem.getFeatures().getString("stress")).equals("0")) {
            if (deep) {
                syllable.setAttribute("stress", stressString);
            }
            if (stressString.equals("1")) {
                sampa.append("'");
            } else if (stressString.equals("2")) {
                sampa.append(",");
            }
        }
        for (Item segmentItem = syllableItem.getDaughter(); segmentItem != null; segmentItem = segmentItem.getNext()) {
            if (sampa.length() > 0) {
                sampa.append(" ");
            }
            sampa.append(this.insertSegment(segmentItem, syllable, deep));
        }
        String sampaString = sampa.toString();
        if (deep) {
            syllable.setAttribute("ph", sampaString);
        }
        if (syllableItem.getFeatures().isPresent("endtone") && !this.tokenItemHasFollowingBoundary(syllableItem.getParent().getItemAs("Token").getParent()) && !(endtone = syllableItem.getFeatures().getString("endtone")).equals("")) {
            Element boundary = MaryXML.createElement(doc, "boundary");
            boundary.setAttribute("tone", endtone);
            boundary.setAttribute("breakindex", "4");
            boundary.setAttribute("duration", "200");
            token.getParentNode().appendChild(boundary);
        }
        return sampaString;
    }

    protected String insertSegment(Item segmentItem, Element syllable, boolean deep) {
        if (segmentItem == null || deep && syllable == null) {
            throw new NullPointerException("Null arguments to insertSegment()");
        }
        if (deep && !syllable.getTagName().equals("syllable")) {
            throw new IllegalArgumentException("Segments can only be inserted in <syllable> elements");
        }
        String segmentString = segmentItem.toString();
        Voice maryVoice = FreeTTSVoices.getMaryVoice(segmentItem.getUtterance().getVoice());
        if (deep) {
            String mbrTargets;
            Document doc = syllable.getOwnerDocument();
            Element segment = MaryXML.createElement(doc, "ph");
            syllable.appendChild(segment);
            segment.setAttribute("p", segmentString);
            if (segmentItem.getFeatures().isPresent("end")) {
                float endInSeconds = segmentItem.getFeatures().getFloat("end");
                int endInMillis = (int)(1000.0f * endInSeconds);
                segment.setAttribute("end", String.valueOf(endInMillis));
            }
            if (segmentItem.getFeatures().isPresent("mbr_dur")) {
                int mbrDur = segmentItem.getFeatures().getInt("mbr_dur");
                segment.setAttribute("d", String.valueOf(mbrDur));
            }
            if (segmentItem.getFeatures().isPresent("mbr_targets") && !(mbrTargets = segmentItem.getFeatures().getString("mbr_targets")).equals("")) {
                segment.setAttribute("f0", mbrTargets);
            }
        }
        return segmentString;
    }

    protected Element insertProsodySettings(Element insertHere, FeatureSet featureSet) {
        if (insertHere == null || featureSet == null) {
            throw new NullPointerException("I thoroughly dislike getting null arguments!");
        }
        boolean haveProsodyInfo = false;
        for (String att : XML2UttBase.PROSODY_ATTRIBUTES) {
            if (featureSet.getString(att) == null) continue;
            haveProsodyInfo = true;
            break;
        }
        if (!haveProsodyInfo) {
            return null;
        }
        Document doc = insertHere.getOwnerDocument();
        Element prosody = MaryXML.createElement(doc, "prosody");
        insertHere.appendChild(prosody);
        for (String att : XML2UttBase.PROSODY_ATTRIBUTES) {
            String val = featureSet.getString(att);
            if (val == null) continue;
            prosody.setAttribute(att, val);
        }
        return prosody;
    }

    public String phoneArray2phoneString(AllophoneSet allophoneSet, String[] voicePhones) {
        StringBuilder phoneBuf = new StringBuilder();
        for (int i = 0; i < voicePhones.length; ++i) {
            phoneBuf.append(voicePhones[i]);
        }
        Syllabifier syllabifier = new Syllabifier(allophoneSet);
        return syllabifier.syllabify(phoneBuf.toString());
    }
}

