/*
 * Decompiled with CFR 0.152.
 */
package marytts.modules;

import marytts.datatypes.MaryData;
import marytts.datatypes.MaryDataType;
import marytts.modules.InternalModule;
import marytts.util.dom.NameNodeFilter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;

public class RealisedDurationsExtractor
extends InternalModule {
    public RealisedDurationsExtractor() {
        super("Realised durations extractor", MaryDataType.AUDIO, MaryDataType.REALISED_DURATIONS, null);
    }

    @Override
    public MaryData process(MaryData d) throws Exception {
        Document doc = d.getDocument();
        MaryData result = new MaryData(this.outputType(), d.getLocale());
        StringBuilder buf = new StringBuilder();
        buf.append("#\n");
        NodeIterator ni = ((DocumentTraversal)((Object)doc)).createNodeIterator(doc, 1, (NodeFilter)new NameNodeFilter(new String[]{"s", "ph", "boundary"}), false);
        Element element = null;
        float end = 0.0f;
        float sentenceEnd = 0.0f;
        while ((element = (Element)ni.nextNode()) != null) {
            String sampa = null;
            String durString = null;
            String endString = null;
            if (element.getTagName().equals("ph")) {
                sampa = element.getAttribute("p");
                endString = element.getAttribute("end");
            } else if (element.getTagName().equals("s")) {
                sentenceEnd += end;
            } else {
                assert (element.getTagName().equals("boundary"));
                sampa = "_";
                durString = element.getAttribute("duration");
            }
            boolean printme = false;
            if (endString != null && !endString.equals("")) {
                end = Float.parseFloat(endString);
                printme = true;
            } else if (durString != null && !durString.equals("")) {
                float dur = Float.parseFloat(durString) * 0.001f;
                end += dur;
                printme = true;
            }
            if (!printme) continue;
            buf.append(end + sentenceEnd + " 125 " + sampa + "\n");
        }
        result.setPlainText(buf.toString());
        return result;
    }
}

