/*
 * Decompiled with CFR 0.152.
 */
package marytts.modules;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import marytts.cart.StringPredictionTree;
import marytts.datatypes.MaryData;
import marytts.datatypes.MaryDataType;
import marytts.datatypes.MaryXML;
import marytts.features.FeatureDefinition;
import marytts.features.FeatureProcessorManager;
import marytts.features.TargetFeatureComputer;
import marytts.modules.InternalModule;
import marytts.modules.phonemiser.Allophone;
import marytts.modules.phonemiser.AllophoneSet;
import marytts.server.MaryProperties;
import marytts.unitselection.select.Target;
import marytts.util.MaryRuntimeUtils;
import marytts.util.dom.MaryDomUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.TreeWalker;

public class PronunciationModel
extends InternalModule {
    private Map<String, StringPredictionTree> treeMap;
    private FeatureDefinition featDef;
    private TargetFeatureComputer featureComputer;

    public PronunciationModel() {
        this(null);
    }

    public PronunciationModel(Locale locale) {
        super("PronunciationModel", MaryDataType.INTONATION, MaryDataType.ALLOPHONES, locale);
    }

    @Override
    public void startup() throws Exception {
        super.startup();
        String fdFilename = null;
        if (this.getLocale() != null) {
            fdFilename = MaryProperties.getFilename(MaryProperties.localePrefix(this.getLocale()) + ".pronunciation.featuredefinition");
        }
        if (fdFilename != null) {
            File fdFile = new File(fdFilename);
            this.featDef = new FeatureDefinition(new BufferedReader(new FileReader(fdFile)), false);
            File treePath = new File(MaryProperties.needFilename(MaryProperties.localePrefix(this.getLocale()) + ".pronunciation.treepath"));
            Pattern treeFilePattern = Pattern.compile("^prediction_(.*)\\.tree$");
            this.treeMap = new HashMap<String, StringPredictionTree>();
            File[] fileArray = treePath.listFiles();
            for (int fileIndex = 0; fileIndex < fileArray.length; ++fileIndex) {
                File f = fileArray[fileIndex];
                Matcher filePatternMatcher = treeFilePattern.matcher(f.getName());
                if (!filePatternMatcher.matches()) continue;
                String phoneId = filePatternMatcher.group(1);
                StringPredictionTree predictionTree = new StringPredictionTree(new BufferedReader(new FileReader(f)), this.featDef);
                int index = this.featDef.getFeatureIndex("phone");
                this.treeMap.put(this.featDef.getFeatureValueAsString(index, Short.parseShort(phoneId)), predictionTree);
            }
            this.logger.debug((Object)"Reading in feature definition and decision trees finished.");
            String managerClass = MaryProperties.needProperty(MaryProperties.localePrefix(this.getLocale()) + ".pronunciation.targetfeaturelister.featuremanager");
            FeatureProcessorManager manager = (FeatureProcessorManager)Class.forName(managerClass).newInstance();
            String features = MaryProperties.needProperty(MaryProperties.localePrefix(this.getLocale()) + ".pronunciation.targetfeaturelister.features");
            this.featureComputer = new TargetFeatureComputer(manager, features);
        }
        this.logger.debug((Object)"Building feature computer finished.");
    }

    protected boolean postlexicalRules(Element token, AllophoneSet allophoneSet) {
        return false;
    }

    @Override
    public MaryData process(MaryData d) throws Exception {
        Element t;
        Document doc = d.getDocument();
        this.logger.debug((Object)"Getting xml-data from document finished.");
        TreeWalker tw = MaryDomUtils.createTreeWalker((Document)doc, (Node)doc, (String[])new String[]{"t"});
        AllophoneSet allophoneSet = null;
        while ((t = (Element)tw.nextNode()) != null) {
            Element syllable;
            if (allophoneSet == null) {
                allophoneSet = MaryRuntimeUtils.determineAllophoneSet(t);
            }
            this.createSubStructure(t, allophoneSet);
            boolean changedSomething = this.postlexicalRules(t, allophoneSet);
            if (changedSomething) {
                this.updatePhAttributesFromPhElements(t);
            }
            if (this.treeMap == null) continue;
            assert (this.featureComputer != null);
            StringBuilder tPh = new StringBuilder();
            TreeWalker sylWalker = MaryDomUtils.createTreeWalker((Document)doc, (Node)t, (String[])new String[]{"syllable"});
            while ((syllable = (Element)sylWalker.nextNode()) != null) {
                Element seg;
                StringBuilder sylPh = new StringBuilder();
                String stressed = syllable.getAttribute("stress");
                if (stressed.equals("1")) {
                    sylPh.append("'");
                } else if (stressed.equals("2")) {
                    sylPh.append(",");
                }
                TreeWalker segWalker = MaryDomUtils.createTreeWalker((Document)doc, (Node)syllable, (String[])new String[]{"ph"});
                ArrayList<Element> originalSegments = new ArrayList<Element>();
                while ((seg = (Element)segWalker.nextNode()) != null) {
                    originalSegments.add(seg);
                }
                for (Element s : originalSegments) {
                    Object predicted;
                    String phoneString = s.getAttribute("p");
                    if (this.treeMap.containsKey(phoneString)) {
                        Target tgt = new Target(phoneString, s);
                        tgt.setFeatureVector(this.featureComputer.computeFeatureVector(tgt));
                        StringPredictionTree tree = this.treeMap.get(phoneString);
                        String predictStr = tree.getMostProbableString(tgt);
                        if (sylPh.length() > 0) {
                            sylPh.append(" ");
                        }
                        sylPh.append(predictStr);
                        predicted = predictStr.equals("") ? null : predictStr.split(" ");
                    } else {
                        this.logger.debug((Object)("didn't find decision tree for phone (" + phoneString + "). Just keeping it."));
                        predicted = new String[]{phoneString};
                    }
                    this.logger.debug((Object)("  Predicted phone in sequence of " + ((String[])predicted).length + " phones."));
                    if (predicted == null || ((String[])predicted).length == 0) {
                        syllable.removeChild(s);
                        continue;
                    }
                    assert (predicted != null && ((String[])predicted).length > 0);
                    for (int lc = 0; lc < ((String[])predicted).length - 1; ++lc) {
                        Element newPh = MaryXML.createElement(doc, "ph");
                        newPh.setAttribute("p", predicted[lc]);
                        syllable.insertBefore(newPh, s);
                    }
                    if (phoneString.equals(predicted[((String[])predicted).length - 1])) continue;
                    s.setAttribute("p", predicted[((String[])predicted).length - 1]);
                }
                String newSylPh = sylPh.toString();
                syllable.setAttribute("ph", newSylPh);
                if (tPh.length() > 0) {
                    tPh.append(" -");
                }
                tPh.append(newSylPh);
            }
            t.setAttribute("ph", tPh.toString());
        }
        MaryData result = new MaryData(this.outputType(), d.getLocale());
        result.setDocument(doc);
        this.logger.debug((Object)"Setting the changed xml document finished.");
        return result;
    }

    private void createSubStructure(Element token, AllophoneSet allophoneSet) {
        String phone = token.getAttribute("ph");
        if (phone.equals("")) {
            return;
        }
        if (token.getElementsByTagName("syllable").getLength() > 0) {
            return;
        }
        StringTokenizer tok = new StringTokenizer(phone, "-");
        Document document = token.getOwnerDocument();
        Element prosody = (Element)MaryDomUtils.getAncestor((Node)token, (String)"prosody");
        String vq = null;
        if (prosody != null) {
            String volumeString = prosody.getAttribute("volume");
            int volume = -1;
            try {
                volume = Integer.parseInt(volumeString);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (volume >= 0) {
                vq = volume >= 60 ? "loud" : (volume <= 40 ? "soft" : null);
            }
        }
        while (tok.hasMoreTokens()) {
            String sylString = tok.nextToken();
            if (sylString.trim().isEmpty()) continue;
            Allophone[] allophones = allophoneSet.splitIntoAllophones(sylString);
            Element syllable = MaryXML.createElement(document, "syllable");
            token.appendChild(syllable);
            String syllableText = "";
            for (int i = 0; i < allophones.length; ++i) {
                if (allophones[i].isTone()) {
                    syllable.setAttribute("tone", allophones[i].name());
                    continue;
                }
                syllableText = i == 0 ? allophones[i].name() : syllableText + " " + allophones[i].name();
            }
            String first = sylString.trim().substring(0, 1);
            if (first.equals("'")) {
                syllable.setAttribute("stress", "1");
                if (token.hasAttribute("accent")) {
                    syllable.setAttribute("accent", token.getAttribute("accent"));
                }
            } else if (first.equals(",")) {
                syllable.setAttribute("stress", "2");
            }
            syllable.setAttribute("ph", syllableText);
            for (int i = 0; i < allophones.length; ++i) {
                if (allophones[i].isTone()) continue;
                Element segment = MaryXML.createElement(document, "ph");
                syllable.appendChild(segment);
                segment.setAttribute("p", allophones[i].name());
                if (vq == null || allophones[i].name().equals("_") || allophones[i].name().equals("?")) continue;
                segment.setAttribute("vq", vq);
            }
        }
    }

    protected void updatePhAttributesFromPhElements(Element token) {
        Element syl;
        if (token == null) {
            throw new NullPointerException("Got null token");
        }
        if (!token.getTagName().equals("t")) {
            throw new IllegalArgumentException("Argument should be a <t>, not a <" + token.getTagName() + ">");
        }
        StringBuilder tPh = new StringBuilder();
        TreeWalker sylWalker = MaryDomUtils.createTreeWalker((Node)token, (String[])new String[]{"syllable"});
        while ((syl = (Element)sylWalker.nextNode()) != null) {
            Element ph;
            StringBuilder sylPh = new StringBuilder();
            String stress = syl.getAttribute("stress");
            if (stress.equals("1")) {
                sylPh.append("'");
            } else if (stress.equals("2")) {
                sylPh.append(",");
            }
            TreeWalker phWalker = MaryDomUtils.createTreeWalker((Node)syl, (String[])new String[]{"ph"});
            while ((ph = (Element)phWalker.nextNode()) != null) {
                if (sylPh.length() > 0) {
                    sylPh.append(" ");
                }
                sylPh.append(ph.getAttribute("p"));
            }
            String sylPhString = sylPh.toString();
            syl.setAttribute("ph", sylPhString);
            if (tPh.length() > 0) {
                tPh.append(" - ");
            }
            tPh.append(sylPhString);
            if (!syl.hasAttribute("tone")) continue;
            tPh.append(" " + syl.getAttribute("tone"));
        }
        token.setAttribute("ph", tPh.toString());
    }
}

