/*
 * Decompiled with CFR 0.152.
 */
package marytts.modules;

import marytts.datatypes.MaryData;
import marytts.datatypes.MaryDataType;
import marytts.modules.InternalModule;
import marytts.util.data.text.PraatInterval;
import marytts.util.data.text.PraatIntervalTier;
import marytts.util.data.text.PraatTextGrid;
import marytts.util.data.text.PraatTier;
import marytts.util.dom.NameNodeFilter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;

public class PraatTextGridGenerator
extends InternalModule {
    public PraatTextGridGenerator() {
        super("Praat TextGrid generator", MaryDataType.AUDIO, MaryDataType.PRAAT_TEXTGRID, null);
    }

    @Override
    public MaryData process(MaryData d) throws Exception {
        Element element;
        Document doc = d.getDocument();
        Double xmin = 0.0;
        Double xmax = 0.0;
        String phone = null;
        Double sentenceStart = 0.0;
        PraatIntervalTier phoneTier = new PraatIntervalTier("phones");
        Double basenameDuration = 0.0;
        int prevUnitIndex = Integer.MIN_VALUE;
        int numberOfConsecutiveUnits = 0;
        PraatInterval sourceInterval = new PraatInterval(basenameDuration.doubleValue());
        PraatIntervalTier unitTier = new PraatIntervalTier("units");
        PraatIntervalTier sourceTier = new PraatIntervalTier("sources");
        NodeIterator ni = ((DocumentTraversal)((Object)doc)).createNodeIterator(doc, 1, (NodeFilter)new NameNodeFilter(new String[]{"s", "ph", "boundary"}), false);
        while ((element = (Element)ni.nextNode()) != null) {
            Double duration;
            String tagName = element.getTagName();
            if (tagName.equals("s")) {
                sentenceStart = xmax;
                continue;
            }
            if (tagName.equals("ph")) {
                phone = element.getAttribute("p");
                xmin = xmax;
                xmax = Double.parseDouble(element.getAttribute("end")) + sentenceStart;
                duration = xmax - xmin;
                xmin = xmax;
            } else {
                phone = "_";
                try {
                    duration = Double.parseDouble(element.getAttribute("duration")) / 1000.0;
                    xmax = xmax + duration;
                }
                catch (NumberFormatException nfe) {
                    continue;
                }
            }
            PraatInterval phoneInterval = new PraatInterval(duration.doubleValue(), phone);
            if (element.hasAttribute("units")) {
                String units = element.getAttribute("units");
                String[] unitStrings = units.split("; ");
                boolean differentSource = false;
                String basename = null;
                String unitRange = null;
                for (String unitString : unitStrings) {
                    String[] unitFields = unitString.split(" ");
                    String unitName = unitFields[0];
                    basename = unitFields[1];
                    int unitIndex = Integer.parseInt(unitFields[2]);
                    Double unitDuration = Double.parseDouble(unitFields[3]);
                    unitTier.appendInterval(new PraatInterval(unitDuration.doubleValue(), unitString));
                    boolean bl = differentSource = unitIndex != prevUnitIndex + 1;
                    if (differentSource) {
                        numberOfConsecutiveUnits = 0;
                        basenameDuration = 0.0;
                    }
                    basenameDuration = basenameDuration + unitDuration;
                    unitRange = Integer.toString(unitIndex - ++numberOfConsecutiveUnits + 1);
                    if (numberOfConsecutiveUnits > 1) {
                        unitRange = unitRange + "-" + unitIndex;
                    }
                    if (differentSource) {
                        sourceInterval = new PraatInterval(basenameDuration.doubleValue(), basename + ": " + unitRange);
                        sourceTier.appendInterval(sourceInterval);
                    } else {
                        sourceInterval.setDuration(basenameDuration.doubleValue());
                        sourceInterval.setText(basename + ": " + unitRange);
                    }
                    prevUnitIndex = unitIndex;
                }
            } else if (duration > 10.0) {
                phoneInterval.setDuration(duration / 1000.0);
            }
            phoneTier.appendInterval(phoneInterval);
        }
        PraatTextGrid textGrid = new PraatTextGrid();
        phoneTier.updateBoundaries();
        textGrid.appendTier((PraatTier)phoneTier);
        if (unitTier.getNumberOfIntervals() > 0) {
            unitTier.updateBoundaries();
            textGrid.appendTier((PraatTier)unitTier);
            sourceTier.updateBoundaries();
            textGrid.appendTier((PraatTier)sourceTier);
        }
        MaryData result = new MaryData(this.outputType(), d.getLocale());
        result.setPlainText(textGrid.toString());
        return result;
    }
}

