/*
 * Decompiled with CFR 0.152.
 */
package marytts.modules;

import java.io.InputStream;
import marytts.datatypes.MaryData;
import marytts.datatypes.MaryDataType;
import marytts.fst.FSTLookup;
import marytts.modules.InternalModule;
import marytts.server.MaryProperties;
import marytts.util.MaryUtils;
import marytts.util.dom.MaryDomUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;
import org.w3c.dom.traversal.TreeWalker;

public class MinimalisticPosTagger
extends InternalModule {
    private String propertyPrefix;
    private FSTLookup posFST = null;
    private String punctuationList;

    public MinimalisticPosTagger(String locale, String propertyPrefix) throws Exception {
        super("OpenNLPPosTagger", MaryDataType.WORDS, MaryDataType.PARTSOFSPEECH, MaryUtils.string2locale((String)locale));
        if (!propertyPrefix.endsWith(".")) {
            propertyPrefix = propertyPrefix + ".";
        }
        this.propertyPrefix = propertyPrefix + "partsofspeech.";
    }

    @Override
    public void startup() throws Exception {
        super.startup();
        InputStream posFSTStream = MaryProperties.getStream(this.propertyPrefix + "fst");
        if (posFSTStream != null) {
            this.posFST = new FSTLookup(posFSTStream, MaryProperties.getProperty(this.propertyPrefix + "fst"));
        }
        this.punctuationList = MaryProperties.getProperty(this.propertyPrefix + "punctuation", ",.?!;");
    }

    @Override
    public MaryData process(MaryData d) throws Exception {
        Element sentence;
        Document doc = d.getDocument();
        NodeIterator sentenceIt = MaryDomUtils.createNodeIterator((Document)doc, (Node)doc, (String[])new String[]{"s"});
        while ((sentence = (Element)sentenceIt.nextNode()) != null) {
            Element t;
            TreeWalker tokenIt = MaryDomUtils.createTreeWalker((Node)sentence, (String[])new String[]{"t"});
            while ((t = (Element)tokenIt.nextNode()) != null) {
                String[] result;
                String pos = "content";
                String tokenText = MaryDomUtils.tokenText(t);
                if (this.punctuationList.contains(tokenText)) {
                    pos = "$PUNCT";
                } else if (this.posFST != null && (result = this.posFST.lookup(tokenText)).length != 0) {
                    pos = "function";
                }
                t.setAttribute("pos", pos);
            }
        }
        MaryData output = new MaryData(this.outputType(), d.getLocale());
        output.setDocument(doc);
        return output;
    }
}

