/*
 * Decompiled with CFR 0.152.
 */
package marytts.htsengine;

import java.io.IOException;
import marytts.cart.CART;
import marytts.cart.LeafNode;
import marytts.cart.io.HTSCARTReader;
import marytts.exceptions.MaryConfigurationException;
import marytts.features.FeatureDefinition;
import marytts.features.FeatureVector;
import marytts.htsengine.HMMData;
import marytts.htsengine.HTSModel;
import marytts.htsengine.PhoneTranslator;
import marytts.util.MaryUtils;
import org.apache.log4j.Logger;

public class CartTreeSet {
    private Logger logger = MaryUtils.getLogger((String)"CartTreeSet");
    private CART[] durTree;
    private CART[] lf0Tree;
    private CART[] mgcTree;
    private CART[] strTree;
    private CART[] magTree;
    private int numStates;
    private int lf0Stream;
    private int mcepVsize;
    private int strVsize;
    private int magVsize;

    public int getNumStates() {
        return this.numStates;
    }

    public int getLf0Stream() {
        return this.lf0Stream;
    }

    public int getMcepVsize() {
        return this.mcepVsize;
    }

    public int getStrVsize() {
        return this.strVsize;
    }

    public int getMagVsize() {
        return this.magVsize;
    }

    public int getVsize(HMMData.FeatureType type) {
        switch (type) {
            case MGC: {
                return this.mcepVsize;
            }
            case STR: {
                return this.strVsize;
            }
            case MAG: {
                return this.magVsize;
            }
        }
        return 1;
    }

    public void loadTreeSet(HMMData htsData, FeatureDefinition featureDef, PhoneTranslator trickyPhones) throws IOException, MaryConfigurationException {
        PhoneTranslator phTranslator = trickyPhones;
        HTSCARTReader htsReader = new HTSCARTReader();
        if (htsData.getTreeDurStream() != null) {
            this.logger.debug((Object)"Loading duration tree...");
            this.durTree = htsReader.load(1, htsData.getTreeDurStream(), htsData.getPdfDurStream(), HMMData.PdfFileFormat.dur, featureDef, phTranslator);
            this.numStates = htsReader.getVectorSize();
        }
        if (htsData.getTreeLf0Stream() != null) {
            this.logger.debug((Object)"Loading log F0 tree...");
            this.lf0Tree = htsReader.load(this.numStates, htsData.getTreeLf0Stream(), htsData.getPdfLf0Stream(), HMMData.PdfFileFormat.lf0, featureDef, phTranslator);
            this.lf0Stream = htsReader.getVectorSize();
        }
        if (htsData.getTreeMgcStream() != null) {
            this.logger.debug((Object)"Loading mgc tree...");
            this.mgcTree = htsReader.load(this.numStates, htsData.getTreeMgcStream(), htsData.getPdfMgcStream(), HMMData.PdfFileFormat.mgc, featureDef, phTranslator);
            this.mcepVsize = htsReader.getVectorSize();
        }
        if (htsData.getTreeStrStream() != null) {
            this.logger.debug((Object)"Loading str tree...");
            this.strTree = htsReader.load(this.numStates, htsData.getTreeStrStream(), htsData.getPdfStrStream(), HMMData.PdfFileFormat.str, featureDef, phTranslator);
            this.strVsize = htsReader.getVectorSize();
        }
        if (htsData.getTreeMagStream() != null) {
            this.logger.debug((Object)"Loading mag tree...");
            this.magTree = htsReader.load(this.numStates, htsData.getTreeMagStream(), htsData.getPdfMagStream(), HMMData.PdfFileFormat.mag, featureDef, phTranslator);
            this.magVsize = htsReader.getVectorSize();
        }
    }

    public double searchDurInCartTree(HTSModel m, FeatureVector fv, HMMData htsData, double diffdur) {
        return this.searchDurInCartTree(m, fv, htsData, false, false, diffdur);
    }

    public double searchDurInCartTree(HTSModel m, FeatureVector fv, HMMData htsData, boolean firstPh, boolean lastPh, double diffdur) {
        double rho = htsData.getRho();
        double durscale = htsData.getDurationScale();
        LeafNode.PdfLeafNode node = (LeafNode.PdfLeafNode)this.durTree[0].interpretToNode(fv, 0);
        double[] meanVector = node.getMean();
        double[] varVector = node.getVariance();
        double dd = diffdur;
        for (int s = 0; s < this.numStates; ++s) {
            double data = (meanVector[s] + rho * varVector[s]) * durscale;
            m.setDur(s, (int)(data + dd + 0.5));
            if (m.getDur(s) < 1) {
                m.setDur(s, 1);
            }
            m.incrTotalDur(m.getDur(s));
            dd += data - (double)m.getDur(s);
        }
        m.setDurError(dd);
        return dd;
    }

    public void searchLf0InCartTree(HTSModel m, FeatureVector fv, FeatureDefinition featureDef, double uvthresh) {
        for (int s = 0; s < this.numStates; ++s) {
            LeafNode.PdfLeafNode node = (LeafNode.PdfLeafNode)this.lf0Tree[s].interpretToNode(fv, 1);
            m.setLf0Mean(s, node.getMean());
            m.setLf0Variance(s, node.getVariance());
            if (node.getVoicedWeight() > uvthresh) {
                m.setVoiced(s, true);
                continue;
            }
            m.setVoiced(s, false);
        }
    }

    public void searchMgcInCartTree(HTSModel m, FeatureVector fv, FeatureDefinition featureDef) {
        for (int s = 0; s < this.numStates; ++s) {
            LeafNode.PdfLeafNode node = (LeafNode.PdfLeafNode)this.mgcTree[s].interpretToNode(fv, 1);
            m.setMcepMean(s, node.getMean());
            m.setMcepVariance(s, node.getVariance());
        }
    }

    public void searchStrInCartTree(HTSModel m, FeatureVector fv, FeatureDefinition featureDef) {
        for (int s = 0; s < this.numStates; ++s) {
            LeafNode.PdfLeafNode node = (LeafNode.PdfLeafNode)this.strTree[s].interpretToNode(fv, 1);
            m.setStrMean(s, node.getMean());
            m.setStrVariance(s, node.getVariance());
        }
    }

    public void searchMagInCartTree(HTSModel m, FeatureVector fv, FeatureDefinition featureDef) {
        for (int s = 0; s < this.numStates; ++s) {
            LeafNode.PdfLeafNode node = (LeafNode.PdfLeafNode)this.magTree[s].interpretToNode(fv, 1);
            m.setMagMean(s, node.getMean());
            m.setMagVariance(s, node.getVariance());
        }
    }

    public HTSModel generateHTSModel(HMMData htsData, FeatureDefinition feaDef, FeatureVector fv, double oldErr) {
        HTSModel m = new HTSModel(this.getNumStates());
        String phoneFeature = fv.getFeatureAsString(feaDef.getFeatureIndex("phone"), feaDef);
        m.setPhoneName(phoneFeature);
        try {
            double diffDur = this.searchDurInCartTree(m, fv, htsData, oldErr);
            m.setDurError(diffDur);
            this.searchLf0InCartTree(m, fv, feaDef, htsData.getUV());
            this.searchMgcInCartTree(m, fv, feaDef);
            if (htsData.getTreeStrStream() != null) {
                this.searchStrInCartTree(m, fv, feaDef);
            }
            if (htsData.getTreeMagStream() != null) {
                this.searchMagInCartTree(m, fv, feaDef);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return m;
    }
}

