/*
 * Decompiled with CFR 0.152.
 */
package marytts.datatypes;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import marytts.modules.ModuleRegistry;
import marytts.util.MaryUtils;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class MaryDataType {
    public static final Traits PLAIN_TEXT = new Traits(true, false, false, false);
    public static final Traits EXTERNAL_MARKUP = new Traits(true, true, false, false);
    public static final Traits MARYXML = new Traits(true, true, true, false);
    public static final Traits UTTERANCES = new Traits(false, false, false, true);
    public static final Traits BINARY = new Traits(false, false, false, false);
    public static final MaryDataType ACOUSTPARAMS = new MaryDataType("ACOUSTPARAMS", true, true, MARYXML, "maryxml");
    public static final MaryDataType ALLOPHONES = new MaryDataType("ALLOPHONES", true, true, MARYXML, "maryxml");
    public static final MaryDataType APML = new MaryDataType("APML", true, false, EXTERNAL_MARKUP, "apml");
    public static final MaryDataType AUDIO = new MaryDataType("AUDIO", false, true, BINARY);
    public static final MaryDataType DURATIONS = new MaryDataType("DURATIONS", true, true, MARYXML, "maryxml");
    public static final MaryDataType EMOTIONML = new MaryDataType("EMOTIONML", true, false, EXTERNAL_MARKUP, "emotionml");
    public static final MaryDataType FESTIVAL_UTT = new MaryDataType("FESTIVAL_UTT", true, true, PLAIN_TEXT);
    public static final MaryDataType HALFPHONE_TARGETFEATURES = new MaryDataType("HALFPHONE_TARGETFEATURES", false, true, PLAIN_TEXT);
    public static final MaryDataType HTSCONTEXT = new MaryDataType("HTSCONTEXT", true, true, PLAIN_TEXT);
    public static final MaryDataType INTONATION = new MaryDataType("INTONATION", true, true, MARYXML, "maryxml");
    public static final MaryDataType MBROLA = new MaryDataType("MBROLA", true, true, PLAIN_TEXT);
    public static final MaryDataType PARTSOFSPEECH = new MaryDataType("PARTSOFSPEECH", true, true, MARYXML, "maryxml");
    public static final MaryDataType PHONEMES = new MaryDataType("PHONEMES", true, true, MARYXML, "maryxml");
    public static final MaryDataType PRAAT_TEXTGRID = new MaryDataType("PRAAT_TEXTGRID", false, true, PLAIN_TEXT);
    public static final MaryDataType RAWMARYXML = new MaryDataType("RAWMARYXML", true, true, MARYXML, "maryxml");
    public static final MaryDataType REALISED_ACOUSTPARAMS = new MaryDataType("REALISED_ACOUSTPARAMS", false, true, MARYXML, "maryxml");
    public static final MaryDataType REALISED_DURATIONS = new MaryDataType("REALISED_DURATIONS", false, true, PLAIN_TEXT);
    public static final MaryDataType SABLE = new MaryDataType("SABLE", true, false, EXTERNAL_MARKUP, "SABLE");
    public static final MaryDataType SIMPLEPHONEMES = new MaryDataType("SIMPLEPHONEMES", true, false, PLAIN_TEXT);
    public static final MaryDataType SSML = new MaryDataType("SSML", true, false, EXTERNAL_MARKUP, "speak");
    public static final MaryDataType TARGETFEATURES = new MaryDataType("TARGETFEATURES", false, true, PLAIN_TEXT);
    public static final MaryDataType TEXT = new MaryDataType("TEXT", true, false, PLAIN_TEXT);
    public static final MaryDataType TOKENS = new MaryDataType("TOKENS", true, true, MARYXML, "maryxml");
    public static final MaryDataType WORDS = new MaryDataType("WORDS", true, true, MARYXML, "maryxml");
    public static final MaryDataType FREETTS_ACOUSTPARAMS = new MaryDataType("FREETTS_ACOUSTPARAMS", false, false, UTTERANCES);
    private String name;
    private boolean isInputType;
    private boolean isOutputType;
    private Traits traits;
    private String rootElement;
    private String endMarker;
    private static List<MaryDataType> knownDataTypes = new LinkedList<MaryDataType>();
    private static Map<String, MaryDataType> dataTypesByName = new HashMap<String, MaryDataType>();
    private static boolean registrationComplete = false;
    private static Logger logger = MaryUtils.getLogger((String)"MaryDataType");

    public MaryDataType(String name, boolean isInputType, boolean isOutputType, Traits traits) {
        this(name, isInputType, isOutputType, traits, null);
    }

    public MaryDataType(String name, boolean isInputType, boolean isOutputType, Traits traits, String rootElement) {
        this.name = name;
        this.isInputType = isInputType;
        this.isOutputType = isOutputType;
        this.traits = traits;
        this.rootElement = rootElement;
    }

    public String name() {
        return this.name;
    }

    public boolean isInputType() {
        return this.isInputType;
    }

    public boolean isOutputType() {
        return this.isOutputType;
    }

    public boolean isTextType() {
        return this.traits.isTextType();
    }

    public boolean isXMLType() {
        return this.traits.isXMLType();
    }

    public boolean isMaryXML() {
        return this.traits.isMaryXML();
    }

    public boolean isUtterances() {
        return this.traits.isUtterances();
    }

    public String rootElement() {
        return this.rootElement;
    }

    public String endMarker() {
        if (this.isXMLType()) {
            return "</" + this.rootElement() + ">";
        }
        return this.endMarker;
    }

    public String exampleText(Locale locale) {
        return MaryDataType.getExampleText(this, locale);
    }

    public String toString() {
        return this.name;
    }

    protected Traits getTraits() {
        return this.traits;
    }

    public static void registerDataType(MaryDataType type) {
        if (!dataTypesByName.containsKey(type.name())) {
            dataTypesByName.put(type.name(), type);
            knownDataTypes.add(type);
        }
    }

    public static boolean getRegistrationComplete() {
        return registrationComplete;
    }

    public static void setRegistrationComplete() throws IllegalStateException {
        if (registrationComplete) {
            throw new IllegalStateException("Registration has already completed, cannot do that a second time");
        }
        MaryDataType.sortDataTypes();
        registrationComplete = true;
    }

    private static void sortDataTypes() {
        Collections.sort(knownDataTypes, new Comparator<MaryDataType>(){

            @Override
            public int compare(MaryDataType one, MaryDataType two) {
                if (one.isInputType() && !two.isInputType()) {
                    return -1;
                }
                if (two.isInputType() && !one.isInputType()) {
                    return 1;
                }
                if (one.isOutputType() && !two.isOutputType()) {
                    return 1;
                }
                if (two.isOutputType() && !one.isOutputType()) {
                    return -1;
                }
                if (one.isInputType() && two.isInputType() && !one.isOutputType() && !two.isOutputType()) {
                    if (!one.isXMLType() && two.isXMLType()) {
                        return -1;
                    }
                    if (!two.isXMLType() && one.isXMLType()) {
                        return 1;
                    }
                } else if (!(one.isInputType() || two.isInputType() || one.isOutputType() || two.isOutputType())) {
                    return 0;
                }
                if (one.isMaryXML() && two.isXMLType() && !two.isMaryXML()) {
                    return 1;
                }
                if (two.isMaryXML() && one.isXMLType() && !one.isMaryXML()) {
                    return -1;
                }
                if (one.name().equals("TEXT") && !two.name().equals("TEXT")) {
                    return -1;
                }
                if (two.name().equals("TEXT") && !one.name().equals("TEXT")) {
                    return 1;
                }
                if (one.name().startsWith("TEXT") && !two.name().startsWith("TEXT")) {
                    return -1;
                }
                if (two.name().startsWith("TEXT") && !one.name().startsWith("TEXT")) {
                    return 1;
                }
                if (ModuleRegistry.modulesRequiredForProcessing(one, two, null) == null) {
                    return 1;
                }
                return -1;
            }
        });
    }

    public static Vector<String> getInputTypeStrings() {
        if (!registrationComplete) {
            throw new IllegalStateException("Cannot inquire about data types while registration is ongoing");
        }
        Vector<String> result = new Vector<String>(10);
        for (MaryDataType t : knownDataTypes) {
            if (!t.isInputType()) continue;
            result.add(t.name());
        }
        return result;
    }

    public static Vector<String> getOutputTypeStrings() {
        if (!registrationComplete) {
            throw new IllegalStateException("Cannot inquire about data types while registration is ongoing");
        }
        Vector<String> result = new Vector<String>(10);
        for (MaryDataType t : knownDataTypes) {
            if (!t.isOutputType()) continue;
            result.add(t.name());
        }
        return result;
    }

    public static List<MaryDataType> getInputTypes() {
        if (!registrationComplete) {
            throw new IllegalStateException("Cannot inquire about data types while registration is ongoing");
        }
        Vector<MaryDataType> result = new Vector<MaryDataType>(10);
        for (MaryDataType t : knownDataTypes) {
            if (!t.isInputType()) continue;
            result.add(t);
        }
        return result;
    }

    public static List<MaryDataType> getOutputTypes() {
        if (!registrationComplete) {
            throw new IllegalStateException("Cannot inquire about data types while registration is ongoing");
        }
        Vector<MaryDataType> result = new Vector<MaryDataType>(10);
        for (MaryDataType t : knownDataTypes) {
            if (!t.isOutputType()) continue;
            result.add(t);
        }
        return result;
    }

    public static MaryDataType get(String name) {
        if (!registrationComplete) {
            throw new IllegalStateException("Cannot inquire about data types while registration is ongoing");
        }
        return dataTypesByName.get(name);
    }

    public static List<MaryDataType> getDataTypes() {
        if (!registrationComplete) {
            throw new IllegalStateException("Cannot inquire about data types while registration is ongoing");
        }
        return Collections.unmodifiableList(knownDataTypes);
    }

    public static String getExampleText(MaryDataType type, Locale locale) {
        InputStream exampleStream = locale == null ? type.getClass().getResourceAsStream(type.name() + ".example") : type.getClass().getResourceAsStream("/marytts/language/" + locale.toString() + "/datatypes/" + type.name() + "." + locale.toString() + ".example");
        if (exampleStream == null) {
            return null;
        }
        try {
            return IOUtils.toString((InputStream)exampleStream, (String)"UTF-8");
        }
        catch (IOException e) {
            logger.debug((Object)("Could not get example text for " + type.name() + " / locale " + locale));
            return null;
        }
    }

    public static class Traits {
        private boolean isTextType;
        private boolean isXMLType;
        private boolean isMaryXML;
        private boolean isUtterances;

        public Traits(boolean isTextType, boolean isXMLType, boolean isMaryXML, boolean isUtterances) {
            if (isMaryXML) assert (isXMLType);
            if (isXMLType) assert (isTextType);
            if (isTextType) assert (!isUtterances);
            this.isTextType = isTextType;
            this.isXMLType = isXMLType;
            this.isMaryXML = isMaryXML;
            this.isUtterances = isUtterances;
        }

        public boolean isTextType() {
            return this.isTextType;
        }

        public boolean isXMLType() {
            return this.isXMLType;
        }

        public boolean isMaryXML() {
            return this.isMaryXML;
        }

        public boolean isUtterances() {
            return this.isUtterances;
        }
    }
}

