/*
 * Decompiled with CFR 0.152.
 */
package marytts.config;

import java.io.InputStream;
import java.util.Locale;
import marytts.config.MaryConfig;
import marytts.exceptions.MaryConfigurationException;
import marytts.util.MaryUtils;

public class VoiceConfig
extends MaryConfig {
    public VoiceConfig(InputStream propertyStream) throws MaryConfigurationException {
        super(propertyStream);
        if (this.getName() == null) {
            throw new MaryConfigurationException("Voice does not have a name");
        }
        if (this.getLocale() == null) {
            throw new MaryConfigurationException("Voice '" + this.getName() + "' does not have a locale");
        }
    }

    @Override
    public boolean isVoiceConfig() {
        return true;
    }

    public String getName() {
        return this.getProperties().getProperty("name");
    }

    public Locale getLocale() {
        String localeString = this.getProperties().getProperty("locale");
        if (localeString == null) {
            return null;
        }
        return MaryUtils.string2locale((String)localeString);
    }
}

