/*
 * Decompiled with CFR 0.152.
 */
package marytts.language.it.preprocess;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import marytts.language.it.preprocess.ExpansionPattern;
import marytts.util.MaryUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SpecialCharEP
extends ExpansionPattern {
    private final String[] _knownTypes = new String[]{"specialChar"};
    private final List knownTypes = Arrays.asList(this._knownTypes);
    private final Map specialCharNames = this.createSpecialCharNames();
    protected final String sMatchingChars = this.createMatchingChars();
    protected final String sMatchingCharsSimpleString = this.createMatchingCharsSimpleString();
    private final String sSplitAtChars = this.createSplitAtChars();
    private final String sSplitAtCharsSimpleString = this.createSplitAtCharsSimpleString();
    private final Pattern reMatchingChars = Pattern.compile(this.sMatchingChars);
    private final Pattern reSplitAtChars = Pattern.compile(this.sSplitAtChars);
    private Logger logger = MaryUtils.getLogger((String)"SpecialCharEP");

    @Override
    public List knownTypes() {
        return this.knownTypes;
    }

    private Map createSpecialCharNames() {
        HashMap<String, SCEntry> m = new HashMap<String, SCEntry>();
        m.put("$", new SCEntry("dollaro", false, true));
        m.put("@", new SCEntry("chiocciola", true, true));
        return m;
    }

    private String createMatchingChars() {
        StringBuilder sb = new StringBuilder("[");
        Iterator it = this.specialCharNames.keySet().iterator();
        while (it.hasNext()) {
            sb.append("\\" + (String)it.next());
        }
        sb.append("]");
        return sb.toString();
    }

    private String createMatchingCharsSimpleString() {
        StringBuilder sb = new StringBuilder();
        Iterator it = this.specialCharNames.keySet().iterator();
        while (it.hasNext()) {
            sb.append((String)it.next());
        }
        return sb.toString();
    }

    private String createSplitAtChars() {
        StringBuilder sb = new StringBuilder("[");
        for (String sc : this.specialCharNames.keySet()) {
            if (!((SCEntry)this.specialCharNames.get((Object)sc)).splitAt) continue;
            sb.append("\\" + sc);
        }
        sb.append("]");
        return sb.toString();
    }

    private String createSplitAtCharsSimpleString() {
        StringBuilder sb = new StringBuilder();
        for (String sc : this.specialCharNames.keySet()) {
            if (!((SCEntry)this.specialCharNames.get((Object)sc)).splitAt) continue;
            sb.append(sc);
        }
        return sb.toString();
    }

    @Override
    public Pattern reMatchingChars() {
        return this.reMatchingChars;
    }

    protected Pattern getRESplitAtChars() {
        return this.reSplitAtChars;
    }

    protected String splitAtChars() {
        return this.sSplitAtCharsSimpleString;
    }

    @Override
    protected int canDealWith(String s, int type) {
        return this.match(s, type);
    }

    @Override
    protected int match(String s, int type) {
        switch (type) {
            case 0: {
                if (!this.matchSpecialChar(s)) break;
                return 0;
            }
        }
        return -1;
    }

    @Override
    protected List expand(List tokens, String s, int type) {
        if (tokens == null) {
            throw new NullPointerException("Received null argument");
        }
        if (tokens.isEmpty()) {
            throw new IllegalArgumentException("Received empty list");
        }
        Document doc = ((Element)tokens.get(0)).getOwnerDocument();
        List expanded = null;
        switch (type) {
            case 0: {
                expanded = this.expandSpecialChar(doc, s);
            }
        }
        if (expanded != null && !expanded.isEmpty()) {
            this.replaceTokens(tokens, expanded);
        }
        return expanded;
    }

    public boolean matchSpecialChar(String s) {
        return this.reMatchingChars.matcher(s).matches();
    }

    protected boolean doPronounce(String specialChar) {
        SCEntry entry = (SCEntry)this.specialCharNames.get(specialChar);
        if (entry == null) {
            return false;
        }
        return entry.pronounce;
    }

    protected List expandSpecialChar(Document doc, String s) {
        ArrayList exp = new ArrayList();
        if (this.doPronounce(s)) {
            String specialCharName = this.expandSpecialChar(s);
            exp.addAll(this.makeNewTokens(doc, specialCharName, true, s));
        }
        return exp;
    }

    protected String expandSpecialChar(String s) {
        SCEntry entry = (SCEntry)this.specialCharNames.get(s);
        if (entry == null) {
            return null;
        }
        return entry.expand;
    }

    class SCEntry {
        protected String expand;
        protected boolean splitAt;
        protected boolean pronounce;

        protected SCEntry(String expand, boolean splitAt, boolean pronounce) {
            this.expand = expand;
            this.splitAt = splitAt;
            this.pronounce = pronounce;
        }
    }
}

