/*
 * Decompiled with CFR 0.152.
 */
package marytts.language.it.preprocess;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import marytts.language.it.preprocess.ExpansionPattern;
import marytts.language.it.preprocess.REPattern;
import marytts.util.MaryUtils;
import marytts.util.dom.MaryDomUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;

public class CompositeEP
extends ExpansionPattern {
    Pattern reTrailingHyphen = Pattern.compile("([A-Z\u00c0\u00c1\u00c8\u00c9\u00cc\u00cd\u00d2\u00d3\u00d9\u00daa-z\u00e0\u00e1\u00e8\u00e9\u00ec\u00ed\u00f2\u00f3\u00f9\u00fa])-$");
    Pattern reLeadingHyphen = Pattern.compile("^-([A-Z\u00c0\u00c1\u00c8\u00c9\u00cc\u00cd\u00d2\u00d3\u00d9\u00daa-z\u00e0\u00e1\u00e8\u00e9\u00ec\u00ed\u00f2\u00f3\u00f9\u00fa])");
    Pattern reLettersDigitsAndHyphens = Pattern.compile("([^-]*[A-Z\u00c0\u00c1\u00c8\u00c9\u00cc\u00cd\u00d2\u00d3\u00d9\u00daa-z\u00e0\u00e1\u00e8\u00e9\u00ec\u00ed\u00f2\u00f3\u00f9\u00fa0-9][^-]*)(-[^-]*[A-Z\u00c0\u00c1\u00c8\u00c9\u00cc\u00cd\u00d2\u00d3\u00d9\u00daa-z\u00e0\u00e1\u00e8\u00e9\u00ec\u00ed\u00f2\u00f3\u00f9\u00fa0-9][^-]*)+");
    Pattern reLettersDigitsAndApostrophe = Pattern.compile("([^']*[A-Z\u00c0\u00c1\u00c8\u00c9\u00cc\u00cd\u00d2\u00d3\u00d9\u00daa-z\u00e0\u00e1\u00e8\u00e9\u00ec\u00ed\u00f2\u00f3\u00f9\u00fa0-9][^']*)('[^']*[A-Z\u00c0\u00c1\u00c8\u00c9\u00cc\u00cd\u00d2\u00d3\u00d9\u00daa-z\u00e0\u00e1\u00e8\u00e9\u00ec\u00ed\u00f2\u00f3\u00f9\u00fa0-9][^']*)+");
    Pattern reOneLetterAndApostrophe = Pattern.compile("([^']*[^EIOUYaeiouy\u00c0\u00c1\u00c8\u00c9\u00cc\u00cd\u00d2\u00d3\u00c4\u00d6\u00dc\u00cb\u00cf\u00e4\u00f6\u00fc\u00eb\u00ef\u00d9\u00da\u00e0\u00e1\u00e8\u00e9\u00ec\u00ed\u00f2\u00f3\u00f9\u00fa])('[hH]?([AEIOUYaeiouy\u00c0\u00c1\u00c8\u00c9\u00cc\u00cd\u00d2\u00d3\u00c4\u00d6\u00dc\u00cb\u00cf\u00e4\u00f6\u00fc\u00eb\u00ef\u00d9\u00da\u00e0\u00e1\u00e8\u00e9\u00ec\u00ed\u00f2\u00f3\u00f9\u00fa][^']*)+)+");
    Pattern reLettersAndDigits = Pattern.compile("(?:(?:[A-Z\u00c0\u00c1\u00c8\u00c9\u00cc\u00cd\u00d2\u00d3\u00d9\u00daa-z\u00e0\u00e1\u00e8\u00e9\u00ec\u00ed\u00f2\u00f3\u00f9\u00fa]+[0-9]+)|(?:[0-9]+[A-Z\u00c0\u00c1\u00c8\u00c9\u00cc\u00cd\u00d2\u00d3\u00d9\u00daa-z\u00e0\u00e1\u00e8\u00e9\u00ec\u00ed\u00f2\u00f3\u00f9\u00fa]+))[A-Z\u00c4\u00d6\u00dca-z\u00e0\u00e1\u00e8\u00e9\u00ec\u00ed\u00f2\u00f3\u00f9\u00fa0-9]*");
    private final Pattern reMatchingChars = Pattern.compile("");
    private Logger logger = MaryUtils.getLogger((String)"CompositeEP");

    @Override
    public List knownTypes() {
        return new ArrayList();
    }

    @Override
    public Pattern reMatchingChars() {
        return this.reMatchingChars;
    }

    private List process(List tokens) {
        ArrayList<Element> result = new ArrayList<Element>();
        for (Element t : tokens) {
            if (!t.getTagName().equals("t")) {
                throw new DOMException(15, "Expected t element");
            }
            ArrayList expanded = new ArrayList();
            this.process(t, expanded);
            if (expanded.isEmpty()) {
                result.add(t);
                continue;
            }
            result.addAll(expanded);
        }
        return result;
    }

    @Override
    public boolean process(Element t, List expanded) {
        Element mtu;
        if (t == null || expanded == null) {
            throw new NullPointerException("Received null argument");
        }
        if (!t.getTagName().equals("t")) {
            throw new DOMException(15, "Expected t element");
        }
        if (!expanded.isEmpty()) {
            throw new IllegalArgumentException("Expected empty list, but list has " + expanded.size() + " elements.");
        }
        if (t.hasAttribute("ph") || t.hasAttribute("sounds_like")) {
            return false;
        }
        String s = MaryDomUtils.tokenText((Element)t);
        if (this.reTrailingHyphen.matcher(s).find()) {
            s = this.reTrailingHyphen.matcher(s).replaceFirst("$1");
            MaryDomUtils.setTokenText((Element)t, (String)s);
        }
        if (this.reLeadingHyphen.matcher(s).find()) {
            s = this.reLeadingHyphen.matcher(s).replaceFirst("$1");
            MaryDomUtils.setTokenText((Element)t, (String)s);
        }
        if (this.reLettersDigitsAndHyphens.matcher(s).matches()) {
            mtu = MaryDomUtils.encloseWithMTU((Element)t, (String)s, (String)"first");
            StringTokenizer st = new StringTokenizer(s, "-");
            assert (st.hasMoreTokens());
            MaryDomUtils.setTokenText((Element)t, (String)st.nextToken());
            expanded.add(t);
            while (st.hasMoreTokens()) {
                t = MaryDomUtils.appendToken((Element)t, (String)st.nextToken());
                expanded.add(t);
            }
        } else if (this.reOneLetterAndApostrophe.matcher(s).matches()) {
            mtu = MaryDomUtils.encloseWithMTU((Element)t, (String)s, (String)"last-proclitics");
            StringTokenizer st = new StringTokenizer(s, "'");
            assert (st.hasMoreTokens());
            MaryDomUtils.setTokenText((Element)t, (String)(st.nextToken() + "'"));
            expanded.add(t);
            while (st.hasMoreTokens()) {
                t = MaryDomUtils.appendToken((Element)t, (String)st.nextToken());
                expanded.add(t);
            }
        } else if (this.reLettersAndDigits.matcher(s).matches()) {
            mtu = MaryDomUtils.encloseWithMTU((Element)t, (String)s, (String)"first");
            String s1 = s;
            boolean isFirst = true;
            while (s1.length() > 0) {
                String part;
                Matcher reMatcher = REPattern.initialNonDigits.matcher(s1);
                if (reMatcher.find()) {
                    part = reMatcher.group();
                    s1 = reMatcher.replaceFirst("");
                } else {
                    reMatcher = REPattern.initialDigits.matcher(s1);
                    reMatcher.find();
                    part = reMatcher.group();
                    s1 = reMatcher.replaceFirst("");
                }
                if (isFirst) {
                    MaryDomUtils.setTokenText((Element)t, (String)part);
                } else {
                    t = MaryDomUtils.appendToken((Element)t, (String)part);
                }
                expanded.add(t);
                isFirst = false;
            }
        } else if (s.equals("'s")) {
            t.setAttribute("ph", "s");
            expanded.add(t);
        } else if (s.endsWith("'s")) {
            t.setAttribute("sounds_like", s.substring(0, s.length() - 2));
            t.setAttribute("ph", "*s");
            expanded.add(t);
        } else if (ExpansionPattern.reSplitAtChars().matcher(s).find() && (REPattern.letter.matcher(s).find() || REPattern.digit.matcher(s).find())) {
            mtu = MaryDomUtils.encloseWithMTU((Element)t, (String)s, (String)"last");
            StringTokenizer st = new StringTokenizer(s, ExpansionPattern.getSplitAtChars(), true);
            MaryDomUtils.setTokenText((Element)t, (String)st.nextToken());
            expanded.add(t);
            while (st.hasMoreTokens()) {
                t = MaryDomUtils.appendToken((Element)t, (String)st.nextToken());
                expanded.add(t);
            }
        }
        if (expanded.size() > 0) {
            List newExpanded = this.process(expanded);
            expanded.clear();
            expanded.addAll(newExpanded);
        }
        return false;
    }

    @Override
    protected int canDealWith(String input, int typeCode) {
        return this.match(input, typeCode);
    }

    @Override
    protected int match(String input, int typeCode) {
        throw new RuntimeException("This method should not be called.");
    }

    @Override
    protected List expand(List tokens, String text, int typeCode) {
        throw new RuntimeException("This method should not be called.");
    }
}

