/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.wikibaseapi.apierrors;

import org.wikidata.wdtk.wikibaseapi.apierrors.EditConflictErrorException;
import org.wikidata.wdtk.wikibaseapi.apierrors.MediaWikiApiErrorException;
import org.wikidata.wdtk.wikibaseapi.apierrors.NoSuchEntityErrorException;
import org.wikidata.wdtk.wikibaseapi.apierrors.TokenErrorException;

public class MediaWikiApiErrorHandler {
    public static final String ERROR_EDIT_CONFLICT = "editconflict";
    public static final String ERROR_NO_TOKEN = "notoken";
    public static final String ERROR_INVALID_TOKEN = "badtoken";
    public static final String ERROR_NO_SUCH_ENTITY = "no-such-entity";

    public static void throwMediaWikiApiErrorException(String errorCode, String errorMessage) throws MediaWikiApiErrorException {
        switch (errorCode) {
            case "notoken": 
            case "badtoken": {
                throw new TokenErrorException(errorCode, errorMessage);
            }
            case "editconflict": {
                throw new EditConflictErrorException(errorMessage);
            }
            case "no-such-entity": {
                throw new NoSuchEntityErrorException(errorMessage);
            }
        }
        throw new MediaWikiApiErrorException(errorCode, errorMessage);
    }
}

