/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.wikibaseapi;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wikidata.wdtk.datamodel.helpers.Datamodel;
import org.wikidata.wdtk.datamodel.interfaces.DocumentDataFilter;
import org.wikidata.wdtk.datamodel.interfaces.EntityDocument;
import org.wikidata.wdtk.wikibaseapi.ApiConnection;
import org.wikidata.wdtk.wikibaseapi.WbGetEntitiesAction;
import org.wikidata.wdtk.wikibaseapi.WbGetEntitiesActionData;
import org.wikidata.wdtk.wikibaseapi.apierrors.MediaWikiApiErrorException;

public class WikibaseDataFetcher {
    static final Logger logger = LoggerFactory.getLogger(WikibaseDataFetcher.class);
    final WbGetEntitiesAction wbGetEntitiesAction;
    final String siteIri;
    final ObjectMapper mapper = new ObjectMapper();
    private final DocumentDataFilter filter = new DocumentDataFilter();

    public static WikibaseDataFetcher getWikidataDataFetcher() {
        return new WikibaseDataFetcher(ApiConnection.getWikidataApiConnection(), Datamodel.SITE_WIKIDATA);
    }

    public WikibaseDataFetcher(ApiConnection connection, String siteUri) {
        this.wbGetEntitiesAction = new WbGetEntitiesAction(connection, siteUri);
        this.siteIri = siteUri;
    }

    public DocumentDataFilter getFilter() {
        return this.filter;
    }

    public EntityDocument getEntityDocument(String entityId) throws MediaWikiApiErrorException {
        return this.getEntityDocuments(entityId).get(entityId);
    }

    public Map<String, EntityDocument> getEntityDocuments(String ... entityIds) throws MediaWikiApiErrorException {
        return this.getEntityDocuments(Arrays.asList(entityIds));
    }

    public Map<String, EntityDocument> getEntityDocuments(List<String> entityIds) throws MediaWikiApiErrorException {
        String entityString;
        WbGetEntitiesActionData properties = new WbGetEntitiesActionData();
        properties.ids = entityString = ApiConnection.implodeObjects(entityIds);
        return this.getEntityDocumentMap(entityIds.size(), properties);
    }

    public EntityDocument getEntityDocumentByTitle(String siteKey, String title) throws MediaWikiApiErrorException {
        return this.getEntityDocumentsByTitle(siteKey, title).get(title);
    }

    public Map<String, EntityDocument> getEntityDocumentsByTitle(String siteKey, String ... titles) throws MediaWikiApiErrorException {
        return this.getEntityDocumentsByTitle(siteKey, Arrays.asList(titles));
    }

    public Map<String, EntityDocument> getEntityDocumentsByTitle(String siteKey, List<String> titles) throws MediaWikiApiErrorException {
        String titleString;
        WbGetEntitiesActionData properties = new WbGetEntitiesActionData();
        properties.titles = titleString = ApiConnection.implodeObjects(titles);
        properties.sites = siteKey;
        return this.getEntityDocumentMap(titles.size(), properties);
    }

    Map<String, EntityDocument> getEntityDocumentMap(int numOfEntities, WbGetEntitiesActionData properties) throws MediaWikiApiErrorException {
        if (numOfEntities == 0) {
            return Collections.emptyMap();
        }
        this.configureProperties(properties);
        Map<String, EntityDocument> result = this.wbGetEntitiesAction.wbGetEntities(properties);
        return result;
    }

    void configureProperties(WbGetEntitiesActionData properties) {
        this.setRequestProps(properties);
        this.setRequestLanguages(properties);
        this.setRequestSitefilter(properties);
    }

    private void setRequestProps(WbGetEntitiesActionData properties) {
        StringBuilder builder = new StringBuilder();
        builder.append("info|datatype");
        if (!this.filter.excludeAllLanguages()) {
            builder.append("|labels|aliases|descriptions");
        }
        if (!this.filter.excludeAllProperties()) {
            builder.append("|claims");
        }
        if (!this.filter.excludeAllSiteLinks()) {
            builder.append("|sitelinks");
        }
        properties.props = builder.toString();
    }

    private void setRequestLanguages(WbGetEntitiesActionData properties) {
        if (this.filter.excludeAllLanguages() || this.filter.getLanguageFilter() == null) {
            return;
        }
        properties.languages = ApiConnection.implodeObjects(this.filter.getLanguageFilter());
    }

    private void setRequestSitefilter(WbGetEntitiesActionData properties) {
        if (this.filter.excludeAllSiteLinks() || this.filter.getSiteLinkFilter() == null) {
            return;
        }
        properties.sitefilter = ApiConnection.implodeObjects(this.filter.getSiteLinkFilter());
    }
}

