/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.wikibaseapi;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wikidata.wdtk.datamodel.interfaces.EntityDocument;
import org.wikidata.wdtk.datamodel.json.jackson.JacksonTermedStatementDocument;
import org.wikidata.wdtk.wikibaseapi.ApiConnection;
import org.wikidata.wdtk.wikibaseapi.apierrors.MediaWikiApiErrorException;
import org.wikidata.wdtk.wikibaseapi.apierrors.TokenErrorException;

public class WbEditEntityAction {
    static final Logger logger = LoggerFactory.getLogger(WbEditEntityAction.class);
    final ApiConnection connection;
    final String siteIri;
    final ObjectMapper mapper = new ObjectMapper();
    String csrfToken = null;

    public WbEditEntityAction(ApiConnection connection, String siteUri) {
        this.connection = connection;
        this.siteIri = siteUri;
    }

    public EntityDocument wbEditEntity(String id, String site, String title, String newEntity, String data, boolean clear, boolean bot, long baserevid, String summary) throws IOException, MediaWikiApiErrorException {
        EntityDocument result;
        Validate.notNull(data, "Data parameter cannot be null when editing entity data", new Object[0]);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("action", "wbeditentity");
        if (newEntity != null) {
            parameters.put("new", newEntity);
            if (title != null || site != null || id != null) {
                throw new IllegalArgumentException("Cannot use parameters \"id\", \"site\", or \"title\" when creating a new entity.");
            }
        } else if (id != null) {
            parameters.put("id", id);
            if (title != null || site != null) {
                throw new IllegalArgumentException("Cannot use parameters \"site\" or \"title\" when using id to edit entity data");
            }
        } else if (title != null) {
            if (site == null) {
                throw new IllegalArgumentException("Site parameter is required when using title parameter to edit entity data.");
            }
            parameters.put("site", site);
            parameters.put("title", title);
        } else {
            throw new IllegalArgumentException("This action must create a new item, or specify an id, or specify a site and title.");
        }
        parameters.put("data", data);
        if (bot) {
            parameters.put("bot", "");
        }
        if (baserevid != 0L) {
            parameters.put("baserevid", Long.toString(baserevid));
        }
        if (clear) {
            parameters.put("clear", "");
        }
        if (summary != null) {
            parameters.put("summary", summary);
        }
        parameters.put("token", this.getCsrfToken());
        parameters.put("format", "json");
        try {
            result = this.doWbEditEntity(parameters);
        }
        catch (TokenErrorException e) {
            this.refreshCsrfToken();
            parameters.put("token", this.getCsrfToken());
            result = this.doWbEditEntity(parameters);
        }
        return result;
    }

    private EntityDocument doWbEditEntity(Map<String, String> parameters) throws IOException, MediaWikiApiErrorException {
        try (InputStream response = this.connection.sendRequest("POST", parameters);){
            JsonNode root = this.mapper.readTree(response);
            this.connection.checkErrors(root);
            this.connection.logWarnings(root);
            if (root.has("item")) {
                EntityDocument entityDocument = this.parseJsonResponse(root.path("item"));
                return entityDocument;
            }
            if (root.has("property")) {
                EntityDocument entityDocument = this.parseJsonResponse(root.path("property"));
                return entityDocument;
            }
            if (root.has("entity")) {
                EntityDocument entityDocument = this.parseJsonResponse(root.path("entity"));
                return entityDocument;
            }
            logger.error("No entity document found in API response.");
        }
        return null;
    }

    private String getCsrfToken() {
        if (this.csrfToken == null) {
            this.refreshCsrfToken();
        }
        return this.csrfToken;
    }

    private void refreshCsrfToken() {
        this.csrfToken = this.fetchCsrfToken();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String fetchCsrfToken() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("action", "query");
        params.put("meta", "tokens");
        params.put("format", "json");
        try (InputStream response = this.connection.sendRequest("POST", params);){
            String newToken;
            JsonNode root = this.mapper.readTree(response);
            this.connection.checkErrors(root);
            this.connection.logWarnings(root);
            String string = newToken = root.path("query").path("tokens").path("csrftoken").textValue();
            return string;
        }
        catch (IOException | MediaWikiApiErrorException e) {
            logger.error("Error when trying to fetch csrf token: " + e.toString());
            return null;
        }
    }

    private EntityDocument parseJsonResponse(JsonNode entityNode) {
        try {
            JacksonTermedStatementDocument ed = this.mapper.treeToValue(entityNode, JacksonTermedStatementDocument.class);
            ed.setSiteIri(this.siteIri);
            return ed;
        }
        catch (JsonProcessingException e) {
            logger.warn("Error when reading JSON for entity " + entityNode.path("id").asText("UNKNOWN") + ": " + e.toString() + "\nTrying to manually fix issue https://phabricator.wikimedia.org/T73349.");
            String jsonString = entityNode.toString();
            jsonString = jsonString.replace("\"sitelinks\":[]", "\"sitelinks\":{}").replace("\"labels\":[]", "\"labels\":{}").replace("\"aliases\":[]", "\"aliases\":{}").replace("\"claims\":[]", "\"claims\":{}").replace("\"descriptions\":[]", "\"descriptions\":{}");
            Object documentReader = this.mapper.reader(JacksonTermedStatementDocument.class);
            try {
                JacksonTermedStatementDocument ed = (JacksonTermedStatementDocument)((ObjectReader)documentReader).readValue(jsonString);
                ed.setSiteIri(this.siteIri);
                return ed;
            }
            catch (IOException e1) {
                logger.error("Failed to recover parsing of entity " + entityNode.path("id").asText("UNKNOWN") + ": " + e.toString() + "\nModified JSON data was: " + jsonString);
                return null;
            }
        }
    }
}

