/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.wikibaseapi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wikidata.wdtk.datamodel.helpers.Datamodel;
import org.wikidata.wdtk.datamodel.interfaces.Claim;
import org.wikidata.wdtk.datamodel.interfaces.PropertyIdValue;
import org.wikidata.wdtk.datamodel.interfaces.Reference;
import org.wikidata.wdtk.datamodel.interfaces.Snak;
import org.wikidata.wdtk.datamodel.interfaces.Statement;
import org.wikidata.wdtk.datamodel.interfaces.StatementDocument;
import org.wikidata.wdtk.datamodel.interfaces.StatementGroup;
import org.wikidata.wdtk.datamodel.interfaces.StatementRank;
import org.wikidata.wdtk.datamodel.json.jackson.JsonSerializer;

public class StatementUpdate {
    static final Logger logger = LoggerFactory.getLogger(StatementUpdate.class);
    final HashMap<PropertyIdValue, List<StatementWithUpdate>> toKeep = new HashMap();
    final List<String> toDelete = new ArrayList<String>();

    public StatementUpdate(StatementDocument currentDocument, List<Statement> addStatements, List<Statement> deleteStatements) {
        this.markStatementsForUpdate(currentDocument, addStatements, deleteStatements);
    }

    public String getJsonUpdateString() {
        StringBuilder jsonData = new StringBuilder("{\"claims\":[");
        boolean first = true;
        for (String string : this.toDelete) {
            if (first) {
                first = false;
            } else {
                jsonData.append(",");
            }
            jsonData.append("{\"id\":\"").append(string).append("\",\"remove\":\"\"}");
        }
        for (List list : this.toKeep.values()) {
            for (StatementWithUpdate swu : list) {
                if (!swu.write) continue;
                if (first) {
                    first = false;
                } else {
                    jsonData.append(",");
                }
                jsonData.append(JsonSerializer.getJsonString(swu.statement));
            }
        }
        jsonData.append("]}");
        return jsonData.toString();
    }

    protected void markStatementsForUpdate(StatementDocument currentDocument, List<Statement> addStatements, List<Statement> deleteStatements) {
        this.markStatementsForDeletion(currentDocument, deleteStatements);
        this.markStatementsForInsertion(currentDocument, addStatements);
    }

    protected void markStatementsForDeletion(StatementDocument currentDocument, List<Statement> deleteStatements) {
        for (Statement statement : deleteStatements) {
            boolean found = false;
            for (StatementGroup sg : currentDocument.getStatementGroups()) {
                if (!sg.getProperty().equals(statement.getClaim().getMainSnak().getPropertyId())) continue;
                Statement changedStatement = null;
                for (Statement existingStatement : sg.getStatements()) {
                    if (existingStatement.equals(statement)) {
                        found = true;
                        this.toDelete.add(statement.getStatementId());
                        continue;
                    }
                    if (!existingStatement.getStatementId().equals(statement.getStatementId())) continue;
                    changedStatement = existingStatement;
                    break;
                }
                if (found) continue;
                StringBuilder warning = new StringBuilder();
                warning.append("Cannot delete statement (id ").append(statement.getStatementId()).append(") since it is not present in data. Statement was:\n").append(statement);
                if (changedStatement != null) {
                    warning.append("\nThe data contains another statement with the same id: maybe it has been edited? Other statement was:\n").append(changedStatement);
                }
                logger.warn(warning.toString());
            }
        }
    }

    protected void markStatementsForInsertion(StatementDocument currentDocument, List<Statement> addStatements) {
        for (Statement statement : addStatements) {
            this.addStatement(statement, true);
        }
        for (StatementGroup sg : currentDocument.getStatementGroups()) {
            if (!this.toKeep.containsKey(sg.getProperty())) continue;
            for (Statement statement : sg.getStatements()) {
                if (this.toDelete.contains(statement.getStatementId())) continue;
                this.addStatement(statement, false);
            }
        }
    }

    protected void addStatement(Statement statement, boolean isNew) {
        PropertyIdValue pid = statement.getClaim().getMainSnak().getPropertyId();
        if (this.toKeep.containsKey(pid)) {
            List<StatementWithUpdate> statements = this.toKeep.get(pid);
            for (int i = 0; i < statements.size(); ++i) {
                Statement currentStatement = statements.get((int)i).statement;
                boolean currentIsNew = statements.get((int)i).write;
                if (!"".equals(currentStatement.getStatementId()) && currentStatement.getStatementId().equals(statement.getStatementId())) {
                    return;
                }
                Statement newStatement = this.mergeStatements(statement, currentStatement);
                if (newStatement == null) continue;
                boolean writeNewStatement = !(!isNew && newStatement.equals(statement) || !currentIsNew && newStatement.equals(currentStatement));
                statements.set(i, new StatementWithUpdate(newStatement, writeNewStatement));
                if (!"".equals(statement.getStatementId()) && !newStatement.getStatementId().equals(statement.getStatementId())) {
                    this.toDelete.add(statement.getStatementId());
                }
                if (!"".equals(currentStatement.getStatementId()) && !newStatement.getStatementId().equals(currentStatement.getStatementId())) {
                    this.toDelete.add(currentStatement.getStatementId());
                }
                return;
            }
            statements.add(new StatementWithUpdate(statement, isNew));
        } else {
            ArrayList<StatementWithUpdate> statements = new ArrayList<StatementWithUpdate>();
            statements.add(new StatementWithUpdate(statement, isNew));
            this.toKeep.put(pid, statements);
        }
    }

    private Statement mergeStatements(Statement statement1, Statement statement2) {
        if (!this.equivalentClaims(statement1.getClaim(), statement2.getClaim())) {
            return null;
        }
        StatementRank newRank = statement1.getRank();
        if (newRank == StatementRank.NORMAL) {
            newRank = statement2.getRank();
        } else if (statement2.getRank() != StatementRank.NORMAL && newRank != statement2.getRank()) {
            return null;
        }
        String newStatementId = statement1.getStatementId();
        if ("".equals(newStatementId)) {
            newStatementId = statement2.getStatementId();
        }
        List<Reference> newReferences = this.mergeReferences(statement1.getReferences(), statement2.getReferences());
        return Datamodel.makeStatement(statement1.getClaim(), newReferences, newRank, newStatementId);
    }

    protected List<Reference> mergeReferences(List<? extends Reference> references1, List<? extends Reference> references2) {
        ArrayList<Reference> result = new ArrayList<Reference>();
        for (Reference reference : references1) {
            this.addBestReferenceToList(reference, result);
        }
        for (Reference reference : references2) {
            this.addBestReferenceToList(reference, result);
        }
        return result;
    }

    protected void addBestReferenceToList(Reference reference, List<Reference> referenceList) {
        for (Reference existingReference : referenceList) {
            if (!this.isSameSnakSet(existingReference.getAllSnaks(), reference.getAllSnaks())) continue;
            return;
        }
        referenceList.add(reference);
    }

    protected boolean equivalentClaims(Claim claim1, Claim claim2) {
        return claim1.getMainSnak().equals(claim2.getMainSnak()) && this.isSameSnakSet(claim1.getAllQualifiers(), claim2.getAllQualifiers());
    }

    protected boolean isSameSnakSet(Iterator<Snak> snaks1, Iterator<Snak> snaks2) {
        ArrayList<Snak> snakList1 = new ArrayList<Snak>(5);
        while (snaks1.hasNext()) {
            snakList1.add(snaks1.next());
        }
        int snakCount2 = 0;
        while (snaks2.hasNext()) {
            ++snakCount2;
            Snak snak2 = snaks2.next();
            boolean found = false;
            for (int i = 0; i < snakList1.size(); ++i) {
                if (!snak2.equals(snakList1.get(i))) continue;
                snakList1.set(i, null);
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return snakCount2 == snakList1.size();
    }

    class StatementWithUpdate {
        public final Statement statement;
        public final boolean write;

        public StatementWithUpdate(Statement statement, boolean write) {
            this.statement = statement;
            this.write = write;
        }
    }
}

