/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.wikibaseapi;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wikidata.wdtk.wikibaseapi.LoginFailedException;
import org.wikidata.wdtk.wikibaseapi.NeedLoginTokenException;
import org.wikidata.wdtk.wikibaseapi.apierrors.MediaWikiApiErrorException;
import org.wikidata.wdtk.wikibaseapi.apierrors.MediaWikiApiErrorHandler;

public class ApiConnection {
    static final Logger logger = LoggerFactory.getLogger(ApiConnection.class);
    public static final String URL_WIKIDATA_API = "https://www.wikidata.org/w/api.php/";
    public static final String URL_TEST_WIKIDATA_API = "https://test.wikidata.org/w/api.php";
    public static final String PARAM_ACTION = "action";
    public static final String PARAM_LOGIN_USERNAME = "lgname";
    public static final String PARAM_LOGIN_PASSWORD = "lgpassword";
    public static final String PARAM_LOGIN_TOKEN = "lgtoken";
    public static final String PARAM_FORMAT = "format";
    public static final String PARAM_COOKIE = "Cookie";
    static final String HEADER_FIELD_SET_COOKIE = "Set-Cookie";
    static final String LOGIN_RESULT_SUCCESS = "Success";
    static final String LOGIN_WRONG_PASS = "WrongPass";
    static final String LOGIN_WRONG_PLUGIN_PASS = "WrongPluginPass";
    static final String LOGIN_NO_NAME = "NoName";
    static final String LOGIN_NOT_EXISTS = "NotExists";
    static final String LOGIN_ILLEGAL = "Illegal";
    static final String LOGIN_THROTTLED = "Throttled";
    static final String LOGIN_EMPTY_PASS = "EmptyPass";
    static final String LOGIN_CREATE_BLOCKED = "CreateBlocked";
    static final String LOGIN_BLOCKED = "Blocked";
    static final String LOGIN_NEEDTOKEN = "NeedToken";
    static final String LOGIN_WRONG_TOKEN = "WrongToken";
    final String apiBaseUrl;
    boolean loggedIn = false;
    String username = "";
    String password = "";
    final Map<String, String> cookies = new HashMap<String, String>();
    final ObjectMapper mapper = new ObjectMapper();

    public ApiConnection(String apiBaseUrl) {
        this.apiBaseUrl = apiBaseUrl;
    }

    public static ApiConnection getWikidataApiConnection() {
        return new ApiConnection(URL_WIKIDATA_API);
    }

    public static ApiConnection getTestWikidataApiConnection() {
        return new ApiConnection(URL_TEST_WIKIDATA_API);
    }

    public static String implodeObjects(Iterable<? extends Object> objects) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (Object object : objects) {
            if (first) {
                first = false;
            } else {
                builder.append("|");
            }
            builder.append(object.toString());
        }
        return builder.toString();
    }

    public void login(String username, String password) throws LoginFailedException {
        try {
            String token = this.getLoginToken(username, password);
            try {
                this.confirmLogin(token, username, password);
            }
            catch (NeedLoginTokenException e) {
                token = this.getLoginToken(username, password);
                this.confirmLogin(token, username, password);
            }
        }
        catch (IOException e1) {
            throw new LoginFailedException(e1.getMessage(), e1);
        }
    }

    public boolean isLoggedIn() {
        return this.loggedIn;
    }

    public String getCurrentUser() {
        return this.username;
    }

    public void logout() throws IOException {
        if (this.loggedIn) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put(PARAM_ACTION, "logout");
            params.put(PARAM_FORMAT, "json");
            this.sendRequest("POST", params);
            this.loggedIn = false;
            this.username = "";
            this.password = "";
        }
    }

    public void clearCookies() throws IOException {
        this.logout();
        this.cookies.clear();
    }

    public InputStream sendRequest(String requestMethod, Map<String, String> parameters) throws IOException {
        String queryString = this.getQueryString(parameters);
        URL url = new URL(this.apiBaseUrl);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        this.setupConnection(requestMethod, queryString, connection);
        OutputStreamWriter writer = new OutputStreamWriter(connection.getOutputStream());
        writer.write(queryString);
        writer.flush();
        writer.close();
        int rc = connection.getResponseCode();
        if (rc != 200) {
            logger.warn("Error: API request returned response code " + rc);
        }
        InputStream iStream = connection.getInputStream();
        this.fillCookies(connection.getHeaderFields());
        return iStream;
    }

    public void checkErrors(JsonNode root) throws MediaWikiApiErrorException {
        if (root.has("error")) {
            JsonNode errorNode = root.path("error");
            MediaWikiApiErrorHandler.throwMediaWikiApiErrorException(errorNode.path("code").asText("UNKNOWN"), errorNode.path("info").asText("No details provided"));
        }
    }

    public void logWarnings(JsonNode root) {
        for (String warning : this.getWarnings(root)) {
            logger.warn("API warning " + warning);
        }
    }

    List<String> getWarnings(JsonNode root) {
        ArrayList<String> warnings = new ArrayList<String>();
        if (root.has("warnings")) {
            JsonNode warningNode = root.path("warnings");
            Iterator<Map.Entry<String, JsonNode>> moduleIterator = warningNode.fields();
            while (moduleIterator.hasNext()) {
                Map.Entry<String, JsonNode> moduleNode = moduleIterator.next();
                Iterator<JsonNode> moduleOutputIterator = moduleNode.getValue().elements();
                while (moduleOutputIterator.hasNext()) {
                    JsonNode moduleOutputNode = moduleOutputIterator.next();
                    if (moduleOutputNode.isTextual()) {
                        warnings.add("[" + moduleNode.getKey() + "]: " + moduleOutputNode.textValue());
                        continue;
                    }
                    if (moduleOutputNode.isArray()) {
                        Iterator<JsonNode> messageIterator = moduleOutputNode.elements();
                        while (messageIterator.hasNext()) {
                            JsonNode messageNode = messageIterator.next();
                            warnings.add("[" + moduleNode.getKey() + "]: " + messageNode.path("html").path("*").asText(messageNode.toString()));
                        }
                        continue;
                    }
                    warnings.add("[" + moduleNode.getKey() + "]: " + "Warning was not understood. Please report this to Wikidata Toolkit. JSON source: " + moduleOutputNode.toString());
                }
            }
        }
        return warnings;
    }

    String getLoginToken(String username, String password) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(PARAM_ACTION, "login");
        params.put(PARAM_LOGIN_USERNAME, username);
        params.put(PARAM_LOGIN_PASSWORD, password);
        params.put(PARAM_FORMAT, "json");
        JsonNode root = this.mapper.readTree(this.sendRequest("POST", params));
        String token = root.path("login").path("token").textValue();
        return token;
    }

    void confirmLogin(String token, String username, String password) throws IOException, LoginFailedException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(PARAM_ACTION, "login");
        params.put(PARAM_LOGIN_USERNAME, username);
        params.put(PARAM_LOGIN_PASSWORD, password);
        params.put(PARAM_LOGIN_TOKEN, token);
        params.put(PARAM_FORMAT, "json");
        JsonNode root = this.mapper.readTree(this.sendRequest("POST", params));
        String result = root.path("login").path("result").textValue();
        if (!LOGIN_RESULT_SUCCESS.equals(result)) {
            String message = this.getLoginErrorMessage(result);
            logger.warn(message);
            if (LOGIN_WRONG_TOKEN.equals(result)) {
                throw new NeedLoginTokenException(message);
            }
            throw new LoginFailedException(message);
        }
        this.loggedIn = true;
        this.username = username;
        this.password = password;
    }

    String getLoginErrorMessage(String loginResult) {
        switch (loginResult) {
            case "WrongPass": {
                return loginResult + ": Wrong Password.";
            }
            case "WrongPluginPass": {
                return loginResult + ": Wrong Password. An authentication plugin rejected the password.";
            }
            case "NotExists": {
                return loginResult + ": Username does not exist.";
            }
            case "Blocked": {
                return loginResult + ": User is blocked.";
            }
            case "EmptyPass": {
                return loginResult + ": Password is empty.";
            }
            case "NoName": {
                return loginResult + ": No user name given.";
            }
            case "CreateBlocked": {
                return loginResult + ": The wiki tried to automatically create a new account for you," + "but your IP address has been blocked from account creation.";
            }
            case "Illegal": {
                return loginResult + ": Username is illegal.";
            }
            case "Throttled": {
                return loginResult + ": Too many login attempts in a short time.";
            }
            case "WrongToken": {
                return loginResult + ": Token is wrong.";
            }
            case "NeedToken": {
                return loginResult + ": Token or session ID is missing.";
            }
        }
        return "Login Error: " + loginResult;
    }

    void fillCookies(Map<String, List<String>> headerFields) {
        List<String> cookieList = headerFields.get(HEADER_FIELD_SET_COOKIE);
        for (int i = 0; i < cookieList.size(); ++i) {
            String[] cookieResponse;
            for (String cookieLine : cookieResponse = cookieList.get(i).split(";\\p{Space}??")) {
                String[] entry = cookieLine.split("=");
                if (entry.length == 2) {
                    this.cookies.put(entry[0], entry[1]);
                }
                if (entry.length != 1) continue;
                this.cookies.put(entry[0], "");
            }
        }
    }

    String getCookieString() {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> entry : this.cookies.entrySet()) {
            if (first) {
                first = false;
            } else {
                result.append("; ");
            }
            result.append(entry.getKey());
            if ("".equals(entry.getValue())) continue;
            result.append("=").append(entry.getValue());
        }
        return result.toString();
    }

    String getQueryString(Map<String, String> params) {
        StringBuilder builder = new StringBuilder();
        try {
            boolean first = true;
            for (String key : params.keySet()) {
                if (first) {
                    first = false;
                } else {
                    builder.append("&");
                }
                builder.append(URLEncoder.encode(key, "UTF-8"));
                builder.append("=");
                builder.append(URLEncoder.encode(params.get(key), "UTF-8"));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Your Java version does not support UTF-8 encoding.");
        }
        return builder.toString();
    }

    void setupConnection(String requestMethod, String queryString, HttpURLConnection connection) throws IOException {
        connection.setRequestMethod(requestMethod);
        connection.setDoInput(true);
        connection.setDoOutput(true);
        connection.setUseCaches(false);
        connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        connection.setRequestProperty("Content-Length", String.valueOf(queryString.length()));
        connection.setRequestProperty(PARAM_COOKIE, this.getCookieString());
    }
}

