/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.rdf.values;

import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.rio.RDFHandlerException;
import org.wikidata.wdtk.datamodel.interfaces.PropertyIdValue;
import org.wikidata.wdtk.datamodel.interfaces.TimeValue;
import org.wikidata.wdtk.rdf.OwlDeclarationBuffer;
import org.wikidata.wdtk.rdf.PropertyRegister;
import org.wikidata.wdtk.rdf.RdfWriter;
import org.wikidata.wdtk.rdf.Vocabulary;
import org.wikidata.wdtk.rdf.values.BufferedValueConverter;

public class TimeValueConverter
extends BufferedValueConverter<TimeValue> {
    public TimeValueConverter(RdfWriter rdfWriter, PropertyRegister PropertyRegister2, OwlDeclarationBuffer rdfConversionBuffer) {
        super(rdfWriter, PropertyRegister2, rdfConversionBuffer);
    }

    @Override
    public Value getRdfValue(TimeValue value, PropertyIdValue propertyIdValue, boolean simple) {
        String datatype;
        switch (datatype = this.propertyRegister.setPropertyTypeFromTimeValue(propertyIdValue, value)) {
            case "http://www.wikidata.org/ontology#propertyTypeTime": {
                if (simple) {
                    this.rdfConversionBuffer.addDatatypeProperty(propertyIdValue);
                    return TimeValueConverter.getTimeLiteral(value, this.rdfWriter);
                }
                URI valueUri = this.rdfWriter.getUri(Vocabulary.getTimeValueUri(value, this.propertyRegister.getUriPrefix()));
                this.rdfConversionBuffer.addObjectProperty(propertyIdValue);
                this.addValue(value, valueUri);
                return valueUri;
            }
        }
        this.logIncompatibleValueError(propertyIdValue, datatype, "time");
        return null;
    }

    @Override
    public void writeValue(TimeValue value, Resource resource) throws RDFHandlerException {
        this.rdfWriter.writeTripleValueObject(resource, RdfWriter.RDF_TYPE, (Value)RdfWriter.WB_TIME_VALUE);
        this.rdfWriter.writeTripleValueObject(resource, RdfWriter.WB_TIME, (Value)TimeValueConverter.getTimeLiteral(value, this.rdfWriter));
        this.rdfWriter.writeTripleIntegerObject(resource, RdfWriter.WB_TIME_PRECISION, value.getPrecision());
        this.rdfWriter.writeTripleUriObject(resource, RdfWriter.WB_PREFERRED_CALENDAR, value.getPreferredCalendarModel());
    }

    public static Literal getTimeLiteral(TimeValue value, RdfWriter rdfWriter) {
        String xsdYearString = value.getYear() == 0L || value.getYear() < 0L && value.getPrecision() >= 9 ? String.format("%05d", value.getYear() - 1L) : String.format("%04d", value.getYear());
        if (value.getPrecision() >= 11) {
            if (value.getPrecision() > 11) {
                logger.warn("Time values with times of day not supported yet. Exporting only date of " + value.toString());
            }
            return rdfWriter.getLiteral(xsdYearString + "-" + String.format("%02d", value.getMonth()) + "-" + String.format("%02d", value.getDay()), RdfWriter.XSD_DATE);
        }
        if (value.getPrecision() == 10) {
            return rdfWriter.getLiteral(xsdYearString + "-" + String.format("%02d", value.getMonth()), RdfWriter.XSD_G_YEAR_MONTH);
        }
        return rdfWriter.getLiteral(xsdYearString, RdfWriter.XSD_G_YEAR);
    }
}

