/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.rdf.values;

import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.rio.RDFHandlerException;
import org.wikidata.wdtk.datamodel.interfaces.GlobeCoordinatesValue;
import org.wikidata.wdtk.datamodel.interfaces.PropertyIdValue;
import org.wikidata.wdtk.rdf.OwlDeclarationBuffer;
import org.wikidata.wdtk.rdf.PropertyRegister;
import org.wikidata.wdtk.rdf.RdfWriter;
import org.wikidata.wdtk.rdf.Vocabulary;
import org.wikidata.wdtk.rdf.values.BufferedValueConverter;

public class GlobeCoordinatesValueConverter
extends BufferedValueConverter<GlobeCoordinatesValue> {
    public GlobeCoordinatesValueConverter(RdfWriter rdfWriter, PropertyRegister propertyRegister, OwlDeclarationBuffer rdfConversionBuffer) {
        super(rdfWriter, propertyRegister, rdfConversionBuffer);
    }

    @Override
    public Value getRdfValue(GlobeCoordinatesValue value, PropertyIdValue propertyIdValue, boolean simple) {
        String datatype;
        switch (datatype = this.propertyRegister.setPropertyTypeFromGlobeCoordinatesValue(propertyIdValue, value)) {
            case "http://www.wikidata.org/ontology#propertyTypeGlobeCoordinates": {
                URI valueUri = this.rdfWriter.getUri(Vocabulary.getGlobeCoordinatesValueUri(value, this.propertyRegister.getUriPrefix()));
                this.rdfConversionBuffer.addObjectProperty(propertyIdValue);
                this.addValue(value, valueUri);
                return valueUri;
            }
        }
        this.logIncompatibleValueError(propertyIdValue, datatype, "globe coordinates");
        return null;
    }

    @Override
    public void writeValue(GlobeCoordinatesValue value, Resource resource) throws RDFHandlerException {
        URI globeUri;
        this.rdfWriter.writeTripleValueObject(resource, RdfWriter.RDF_TYPE, (Value)RdfWriter.WB_GLOBE_COORDINATES_VALUE);
        this.rdfWriter.writeTripleLiteralObject(resource, RdfWriter.WB_LATITUDE, Double.valueOf(value.getLatitude()).toString(), RdfWriter.XSD_DOUBLE);
        this.rdfWriter.writeTripleLiteralObject(resource, RdfWriter.WB_LONGITUDE, Double.valueOf(value.getLongitude()).toString(), RdfWriter.XSD_DOUBLE);
        this.rdfWriter.writeTripleLiteralObject(resource, RdfWriter.WB_GC_PRECISION, Double.valueOf(value.getPrecision()).toString(), RdfWriter.XSD_DOUBLE);
        try {
            globeUri = this.rdfWriter.getUri(value.getGlobe());
        }
        catch (IllegalArgumentException e) {
            logger.warn("Invalid globe URI \"" + value.getGlobe() + "\". Assuming Earth (" + "http://www.wikidata.org/entity/Q2" + ").");
            globeUri = this.rdfWriter.getUri("http://www.wikidata.org/entity/Q2");
        }
        this.rdfWriter.writeTripleValueObject(resource, RdfWriter.WB_GLOBE, (Value)globeUri);
    }
}

