/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.rdf.extensions;

import java.util.HashMap;
import org.openrdf.model.Resource;
import org.openrdf.rio.RDFHandlerException;
import org.wikidata.wdtk.datamodel.interfaces.DatatypeIdValue;
import org.wikidata.wdtk.datamodel.interfaces.EntityIdValue;
import org.wikidata.wdtk.datamodel.interfaces.GlobeCoordinatesValue;
import org.wikidata.wdtk.datamodel.interfaces.MonolingualTextValue;
import org.wikidata.wdtk.datamodel.interfaces.PropertyIdValue;
import org.wikidata.wdtk.datamodel.interfaces.QuantityValue;
import org.wikidata.wdtk.datamodel.interfaces.StringValue;
import org.wikidata.wdtk.datamodel.interfaces.TimeValue;
import org.wikidata.wdtk.datamodel.interfaces.ValueSnak;
import org.wikidata.wdtk.datamodel.interfaces.ValueVisitor;
import org.wikidata.wdtk.rdf.OwlDeclarationBuffer;
import org.wikidata.wdtk.rdf.PropertyRegister;
import org.wikidata.wdtk.rdf.RdfWriter;
import org.wikidata.wdtk.rdf.extensions.FreebaseExportExtension;
import org.wikidata.wdtk.rdf.extensions.ValueExportExtension;

public class ExportExtensions
implements ValueVisitor<Void> {
    final RdfWriter rdfWriter;
    final OwlDeclarationBuffer owlDeclarationBuffer;
    final PropertyRegister propertyRegister;
    final HashMap<String, ValueExportExtension<StringValue>> stringExportExtensions;
    Resource currentResource;
    PropertyIdValue currentPropertyIdValue;

    public ExportExtensions(RdfWriter rdfWriter, OwlDeclarationBuffer owlDeclarationBuffer, PropertyRegister propertyRegister) {
        this.rdfWriter = rdfWriter;
        this.owlDeclarationBuffer = owlDeclarationBuffer;
        this.propertyRegister = propertyRegister;
        this.stringExportExtensions = new HashMap();
    }

    public void registerStringValueExportExtension(ValueExportExtension<StringValue> valueExportExtension, String propertyIri) {
        this.stringExportExtensions.put(propertyIri, valueExportExtension);
    }

    public void writeValueSnakExtensions(ValueSnak snak, Resource resource) {
        this.currentResource = resource;
        this.currentPropertyIdValue = snak.getPropertyId();
        snak.getValue().accept(this);
    }

    @Override
    public Void visit(DatatypeIdValue value) {
        return null;
    }

    @Override
    public Void visit(EntityIdValue value) {
        return null;
    }

    @Override
    public Void visit(GlobeCoordinatesValue value) {
        return null;
    }

    @Override
    public Void visit(MonolingualTextValue value) {
        return null;
    }

    @Override
    public Void visit(QuantityValue value) {
        return null;
    }

    @Override
    public Void visit(StringValue value) {
        ValueExportExtension<StringValue> vee = this.stringExportExtensions.get(this.currentPropertyIdValue.getIri());
        try {
            if (vee != null) {
                vee.writeExtensionData(this.currentResource, this.currentPropertyIdValue, value, this.rdfWriter, this.owlDeclarationBuffer);
            } else {
                this.writeUriPatternData(this.currentResource, this.currentPropertyIdValue, value);
            }
        }
        catch (RDFHandlerException e) {
            throw new RuntimeException(e.toString(), e);
        }
        return null;
    }

    @Override
    public Void visit(TimeValue value) {
        return null;
    }

    protected void writeUriPatternData(Resource resource, PropertyIdValue propertyIdValue, StringValue value) throws RDFHandlerException {
        String uriPattern = this.propertyRegister.getPropertyUriPattern(propertyIdValue);
        if (uriPattern == null) {
            return;
        }
        this.rdfWriter.writeTripleUriObject(resource, RdfWriter.RDFS_SEE_ALSO, uriPattern.replace("$1", value.getString()));
    }

    public static void registerWikidataExportExtensions(ExportExtensions exportExtensions) {
        exportExtensions.registerStringValueExportExtension(new FreebaseExportExtension(), "http://www.wikidata.org/entity/P646");
    }
}

