/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.rdf;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.wikidata.wdtk.datamodel.interfaces.GlobeCoordinatesValue;
import org.wikidata.wdtk.datamodel.interfaces.PropertyIdValue;
import org.wikidata.wdtk.datamodel.interfaces.QuantityValue;
import org.wikidata.wdtk.datamodel.interfaces.Reference;
import org.wikidata.wdtk.datamodel.interfaces.Snak;
import org.wikidata.wdtk.datamodel.interfaces.SnakGroup;
import org.wikidata.wdtk.datamodel.interfaces.Statement;
import org.wikidata.wdtk.datamodel.interfaces.TimeValue;
import org.wikidata.wdtk.rdf.PropertyContext;

public class Vocabulary {
    static final MessageDigest md;
    public static final String PREFIX_WBONTO = "http://www.wikidata.org/ontology#";
    public static final String PREFIX_RDF = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    public static final String PREFIX_RDFS = "http://www.w3.org/2000/01/rdf-schema#";
    public static final String PREFIX_OWL = "http://www.w3.org/2002/07/owl#";
    public static final String PREFIX_XSD = "http://www.w3.org/2001/XMLSchema#";
    public static final String PREFIX_SCHEMA = "http://schema.org/";
    public static final String PREFIX_SKOS = "http://www.w3.org/2004/02/skos/core#";
    public static final String PREFIX_PROV = "http://www.w3.org/ns/prov#";
    public static final String RDF_TYPE = "http://www.w3.org/1999/02/22-rdf-syntax-ns#type";
    public static final String RDFS_LABEL = "http://www.w3.org/2000/01/rdf-schema#label";
    public static final String RDFS_SEE_ALSO = "http://www.w3.org/2000/01/rdf-schema#seeAlso";
    public static final String RDFS_LITERAL = "http://www.w3.org/2000/01/rdf-schema#Literal";
    public static final String RDFS_SUBCLASS_OF = "http://www.w3.org/2000/01/rdf-schema#subClassOf";
    public static final String RDFS_SUBPROPERTY_OF = "http://www.w3.org/2000/01/rdf-schema#subPropertyOf";
    public static final String OWL_THING = "http://www.w3.org/2002/07/owl#Thing";
    public static final String OWL_CLASS = "http://www.w3.org/2002/07/owl#Class";
    public static final String OWL_OBJECT_PROPERTY = "http://www.w3.org/2002/07/owl#ObjectProperty";
    public static final String OWL_DATATYPE_PROPERTY = "http://www.w3.org/2002/07/owl#DatatypeProperty";
    public static final String OWL_RESTRICTION = "http://www.w3.org/2002/07/owl#Restriction";
    public static final String OWL_SOME_VALUES_FROM = "http://www.w3.org/2002/07/owl#someValuesFrom";
    public static final String OWL_ON_PROPERTY = "http://www.w3.org/2002/07/owl#onProperty";
    public static final String OWL_COMPLEMENT_OF = "http://www.w3.org/2002/07/owl#complementOf";
    public static final String XSD_DOUBLE = "http://www.w3.org/2001/XMLSchema#double";
    public static final String XSD_DECIMAL = "http://www.w3.org/2001/XMLSchema#decimal";
    public static final String XSD_INT = "http://www.w3.org/2001/XMLSchema#int";
    public static final String XSD_DATE = "http://www.w3.org/2001/XMLSchema#date";
    public static final String XSD_G_YEAR = "http://www.w3.org/2001/XMLSchema#gYear";
    public static final String XSD_G_YEAR_MONTH = "http://www.w3.org/2001/XMLSchema#gYearMonth";
    public static final String XSD_DATETIME = "http://www.w3.org/2001/XMLSchema#dateTime";
    public static final String XSD_STRING = "http://www.w3.org/2001/XMLSchema#string";
    static final String VALUE_PREFIX_GLOBECOORDS = "VC";
    static final String VALUE_PREFIX_QUANTITY = "VQ";
    static final String VALUE_PREFIX_TIME = "VT";
    static final String VALUE_PREFIX_REFERENCE = "R";
    static final Map<String, String> VOCABULARY_TYPES;
    public static final String SKOS_ALT_LABEL = "http://www.w3.org/2004/02/skos/core#altLabel";
    public static final String SCHEMA_ABOUT = "http://schema.org/about";
    public static final String SCHEMA_DESCRIPTION = "http://schema.org/description";
    public static final String SCHEMA_IN_LANGUAGE = "http://schema.org/inLanguage";
    public static final String PROV_WAS_DERIVED_FROM = "http://www.w3.org/ns/prov#wasDerivedFrom";
    public static final String WB_ITEM = "http://www.wikidata.org/ontology#Item";
    public static final String WB_REFERENCE = "http://www.wikidata.org/ontology#Reference";
    public static final String WB_PROPERTY = "http://www.wikidata.org/ontology#Property";
    public static final String WB_STATEMENT = "http://www.wikidata.org/ontology#Statement";
    public static final String WB_ARTICLE = "http://www.wikidata.org/ontology#Article";
    public static final String WB_QUANTITY_VALUE = "http://www.wikidata.org/ontology#QuantityValue";
    public static final String WB_TIME_VALUE = "http://www.wikidata.org/ontology#TimeValue";
    public static final String WB_GLOBE_COORDINATES_VALUE = "http://www.wikidata.org/ontology#GlobeCoordinatesValue";
    public static final String WB_PROPERTY_TYPE = "http://www.wikidata.org/ontology#propertyType";
    public static final String WB_RANK = "http://www.wikidata.org/ontology#rank";
    public static final String WB_GLOBE = "http://www.wikidata.org/ontology#globe";
    public static final String WB_LATITUDE = "http://www.wikidata.org/ontology#latitude";
    public static final String WB_LONGITUDE = "http://www.wikidata.org/ontology#longitude";
    public static final String WB_GC_PRECISION = "http://www.wikidata.org/ontology#gcPrecision";
    public static final String WB_TIME = "http://www.wikidata.org/ontology#time";
    public static final String WB_TIME_PRECISION = "http://www.wikidata.org/ontology#timePrecision";
    public static final String WB_PREFERRED_CALENDAR = "http://www.wikidata.org/ontology#preferredCalendar";
    public static final String WB_NUMERIC_VALUE = "http://www.wikidata.org/ontology#numericValue";
    public static final String WB_LOWER_BOUND = "http://www.wikidata.org/ontology#lowerBound";
    public static final String WB_UPPER_BOUND = "http://www.wikidata.org/ontology#upperBound";
    public static final String WB_QUANTITY_UNIT = "http://www.wikidata.org/ontology#quantityUnit";
    public static final String WB_NO_UNIT = "http://www.wikidata.org/entity/Q199";
    public static final String WB_NORMAL_RANK = "http://www.wikidata.org/ontology#NormalRank";
    public static final String WB_PREFERRED_RANK = "http://www.wikidata.org/ontology#PreferredRank";
    public static final String WB_DEPRECATED_RANK = "http://www.wikidata.org/ontology#DeprecatedRank";
    public static final String WB_PROPERTY_STATEMENT_LINKAGE = "http://www.wikidata.org/ontology#propertyStatementLinkage";
    public static final String WB_PROPERTY_VALUE_LINKAGE = "http://www.wikidata.org/ontology#propertyValueLinkage";
    public static final String WB_PROPERTY_QUALTIFIER_LINKAGE = "http://www.wikidata.org/ontology#propertyQualifierLinkage";
    public static final String WB_PROPERTY_REFERENCE_LINKAGE = "http://www.wikidata.org/ontology#propertyReferenceLinkage";
    public static final String WB_PROPERTY_SIMPLE_CLAIM = "http://www.wikidata.org/ontology#propertySimpleClaim";
    static ByteBuffer longByteBuffer;
    static ByteBuffer intByteBuffer;
    protected static final char[] hexArray;

    public static Map<String, String> getKnownVocabularyTypes() {
        return Collections.unmodifiableMap(VOCABULARY_TYPES);
    }

    public static String getStatementUri(Statement statement) {
        int i = statement.getStatementId().indexOf(36) + 1;
        return statement.getClaim().getSubject().getIri() + "S" + statement.getStatementId().substring(i);
    }

    public static String getPropertyUri(PropertyIdValue propertyIdValue, PropertyContext propertyContext) {
        switch (propertyContext) {
            case STATEMENT: {
                return propertyIdValue.getIri() + "s";
            }
            case VALUE: {
                return propertyIdValue.getIri() + "v";
            }
            case QUALIFIER: {
                return propertyIdValue.getIri() + "q";
            }
            case REFERENCE: {
                return propertyIdValue.getIri() + "r";
            }
            case SIMPLE_CLAIM: {
                return propertyIdValue.getIri() + "c";
            }
        }
        return null;
    }

    public static String getReferenceUri(Reference reference, String uriPrefix) {
        md.reset();
        for (SnakGroup snakgroup : reference.getSnakGroups()) {
            for (Snak snak : snakgroup.getSnaks()) {
                Vocabulary.updateMessageDigestWithInt(md, snak.hashCode());
            }
        }
        return uriPrefix + VALUE_PREFIX_REFERENCE + Vocabulary.bytesToHex(md.digest());
    }

    public static String getTimeValueUri(TimeValue value, String uriPrefix) {
        md.reset();
        Vocabulary.updateMessageDigestWithLong(md, value.getYear());
        md.update(value.getMonth());
        md.update(value.getDay());
        md.update(value.getHour());
        md.update(value.getMinute());
        md.update(value.getSecond());
        Vocabulary.updateMessageDigestWithString(md, value.getPreferredCalendarModel());
        Vocabulary.updateMessageDigestWithInt(md, value.getBeforeTolerance());
        Vocabulary.updateMessageDigestWithInt(md, value.getAfterTolerance());
        Vocabulary.updateMessageDigestWithInt(md, value.getTimezoneOffset());
        return uriPrefix + VALUE_PREFIX_TIME + Vocabulary.bytesToHex(md.digest());
    }

    public static String getGlobeCoordinatesValueUri(GlobeCoordinatesValue value, String uriPrefix) {
        md.reset();
        Vocabulary.updateMessageDigestWithString(md, value.getGlobe());
        Vocabulary.updateMessageDigestWithLong(md, Double.valueOf(value.getLatitude()).hashCode());
        Vocabulary.updateMessageDigestWithLong(md, Double.valueOf(value.getLongitude()).hashCode());
        Vocabulary.updateMessageDigestWithLong(md, Double.valueOf(value.getPrecision()).hashCode());
        return uriPrefix + VALUE_PREFIX_GLOBECOORDS + Vocabulary.bytesToHex(md.digest());
    }

    public static String getQuantityValueUri(QuantityValue value, String uriPrefix) {
        md.reset();
        Vocabulary.updateMessageDigestWithInt(md, value.getNumericValue().hashCode());
        Vocabulary.updateMessageDigestWithInt(md, value.getLowerBound().hashCode());
        Vocabulary.updateMessageDigestWithInt(md, value.getUpperBound().hashCode());
        return uriPrefix + VALUE_PREFIX_QUANTITY + Vocabulary.bytesToHex(md.digest());
    }

    static void updateMessageDigestWithLong(MessageDigest md, long x) {
        longByteBuffer.putLong(0, x);
        longByteBuffer.rewind();
        md.update(longByteBuffer);
    }

    static void updateMessageDigestWithInt(MessageDigest md, int x) {
        intByteBuffer.putInt(0, x);
        intByteBuffer.rewind();
        md.update(intByteBuffer);
    }

    static void updateMessageDigestWithString(MessageDigest md, String s) {
        if (s == null) {
            return;
        }
        md.update(s.getBytes(StandardCharsets.UTF_8));
    }

    static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    static {
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Your Java does not support MD5 hashes. You should be concerned.");
        }
        VOCABULARY_TYPES = new HashMap<String, String>();
        VOCABULARY_TYPES.put(SKOS_ALT_LABEL, OWL_DATATYPE_PROPERTY);
        VOCABULARY_TYPES.put(SCHEMA_ABOUT, OWL_OBJECT_PROPERTY);
        VOCABULARY_TYPES.put(SCHEMA_DESCRIPTION, OWL_DATATYPE_PROPERTY);
        VOCABULARY_TYPES.put(SCHEMA_IN_LANGUAGE, OWL_DATATYPE_PROPERTY);
        VOCABULARY_TYPES.put(PROV_WAS_DERIVED_FROM, OWL_OBJECT_PROPERTY);
        VOCABULARY_TYPES.put(WB_ITEM, OWL_CLASS);
        VOCABULARY_TYPES.put(WB_REFERENCE, OWL_CLASS);
        VOCABULARY_TYPES.put(WB_PROPERTY, OWL_CLASS);
        VOCABULARY_TYPES.put(WB_STATEMENT, OWL_CLASS);
        VOCABULARY_TYPES.put(WB_ARTICLE, OWL_CLASS);
        VOCABULARY_TYPES.put(WB_QUANTITY_VALUE, OWL_CLASS);
        VOCABULARY_TYPES.put(WB_TIME_VALUE, OWL_CLASS);
        VOCABULARY_TYPES.put(WB_GLOBE_COORDINATES_VALUE, OWL_CLASS);
        VOCABULARY_TYPES.put(WB_PROPERTY_TYPE, OWL_OBJECT_PROPERTY);
        VOCABULARY_TYPES.put(WB_RANK, OWL_OBJECT_PROPERTY);
        VOCABULARY_TYPES.put(WB_GLOBE, OWL_OBJECT_PROPERTY);
        VOCABULARY_TYPES.put(WB_LATITUDE, OWL_DATATYPE_PROPERTY);
        VOCABULARY_TYPES.put(WB_LONGITUDE, OWL_DATATYPE_PROPERTY);
        VOCABULARY_TYPES.put(WB_GC_PRECISION, OWL_DATATYPE_PROPERTY);
        VOCABULARY_TYPES.put(WB_TIME, OWL_DATATYPE_PROPERTY);
        VOCABULARY_TYPES.put(WB_TIME_PRECISION, OWL_DATATYPE_PROPERTY);
        VOCABULARY_TYPES.put(WB_PREFERRED_CALENDAR, OWL_OBJECT_PROPERTY);
        VOCABULARY_TYPES.put(WB_NUMERIC_VALUE, OWL_DATATYPE_PROPERTY);
        VOCABULARY_TYPES.put(WB_LOWER_BOUND, OWL_DATATYPE_PROPERTY);
        VOCABULARY_TYPES.put(WB_UPPER_BOUND, OWL_DATATYPE_PROPERTY);
        VOCABULARY_TYPES.put(WB_QUANTITY_UNIT, OWL_OBJECT_PROPERTY);
        VOCABULARY_TYPES.put(WB_PROPERTY_STATEMENT_LINKAGE, OWL_OBJECT_PROPERTY);
        VOCABULARY_TYPES.put(WB_PROPERTY_VALUE_LINKAGE, OWL_OBJECT_PROPERTY);
        VOCABULARY_TYPES.put(WB_PROPERTY_QUALTIFIER_LINKAGE, OWL_OBJECT_PROPERTY);
        VOCABULARY_TYPES.put(WB_PROPERTY_REFERENCE_LINKAGE, OWL_OBJECT_PROPERTY);
        VOCABULARY_TYPES.put(WB_PROPERTY_SIMPLE_CLAIM, OWL_OBJECT_PROPERTY);
        longByteBuffer = ByteBuffer.allocate(8);
        intByteBuffer = ByteBuffer.allocate(4);
        hexArray = "0123456789abcdef".toCharArray();
    }
}

