/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.rdf;

import java.util.ArrayList;
import java.util.List;
import org.openrdf.model.BNode;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.rio.RDFHandlerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wikidata.wdtk.datamodel.interfaces.NoValueSnak;
import org.wikidata.wdtk.datamodel.interfaces.PropertyIdValue;
import org.wikidata.wdtk.datamodel.interfaces.Snak;
import org.wikidata.wdtk.datamodel.interfaces.SnakVisitor;
import org.wikidata.wdtk.datamodel.interfaces.SomeValueSnak;
import org.wikidata.wdtk.datamodel.interfaces.ValueSnak;
import org.wikidata.wdtk.rdf.OwlDeclarationBuffer;
import org.wikidata.wdtk.rdf.PropertyContext;
import org.wikidata.wdtk.rdf.PropertyRegister;
import org.wikidata.wdtk.rdf.RdfWriter;
import org.wikidata.wdtk.rdf.Vocabulary;
import org.wikidata.wdtk.rdf.extensions.ExportExtensions;
import org.wikidata.wdtk.rdf.values.AnyValueConverter;

public class SnakRdfConverter
implements SnakVisitor<Void> {
    static final Logger logger = LoggerFactory.getLogger(SnakRdfConverter.class);
    final AnyValueConverter valueRdfConverter;
    final RdfWriter rdfWriter;
    final PropertyRegister propertyRegister;
    final OwlDeclarationBuffer rdfConversionBuffer;
    final ExportExtensions exportExtensions;
    final List<PropertyRestriction> someValuesQueue;
    final List<PropertyRestriction> noValuesQueue;
    Resource currentSubject;
    PropertyContext currentPropertyContext;
    boolean simple;

    public SnakRdfConverter(RdfWriter rdfWriter, OwlDeclarationBuffer owlDeclarationBuffer, PropertyRegister propertyRegister, AnyValueConverter valueRdfConverter) {
        this.rdfWriter = rdfWriter;
        this.rdfConversionBuffer = owlDeclarationBuffer;
        this.propertyRegister = propertyRegister;
        this.valueRdfConverter = valueRdfConverter;
        this.exportExtensions = new ExportExtensions(rdfWriter, owlDeclarationBuffer, propertyRegister);
        ExportExtensions.registerWikidataExportExtensions(this.exportExtensions);
        this.someValuesQueue = new ArrayList<PropertyRestriction>();
        this.noValuesQueue = new ArrayList<PropertyRestriction>();
    }

    public void writeSnak(Snak snak, Resource subject, PropertyContext propertyContext) {
        this.setSnakContext(subject, propertyContext);
        snak.accept(this);
    }

    public void setSnakContext(Resource subject, PropertyContext propertyContext) {
        this.currentSubject = subject;
        this.currentPropertyContext = propertyContext;
        this.simple = this.currentPropertyContext == PropertyContext.SIMPLE_CLAIM;
    }

    @Override
    public Void visit(ValueSnak snak) {
        String propertyUri = Vocabulary.getPropertyUri(snak.getPropertyId(), this.currentPropertyContext);
        URI property = this.rdfWriter.getUri(propertyUri);
        Value value = this.valueRdfConverter.getRdfValue(snak.getValue(), snak.getPropertyId(), this.simple);
        if (value == null) {
            logger.error("Could not serialize snak: missing value (Snak: " + snak.toString() + ")");
            return null;
        }
        try {
            this.rdfWriter.writeTripleValueObject(this.currentSubject, property, value);
        }
        catch (RDFHandlerException e) {
            throw new RuntimeException(e.toString(), e);
        }
        this.exportExtensions.writeValueSnakExtensions(snak, this.currentSubject);
        return null;
    }

    @Override
    public Void visit(SomeValueSnak snak) {
        String rangeUri = this.getRangeUri(snak.getPropertyId());
        if (rangeUri == null) {
            logger.error("Count not export SomeValueSnak for property " + snak.getPropertyId().getId() + ": OWL range not known.");
            return null;
        }
        String propertyUri = Vocabulary.getPropertyUri(snak.getPropertyId(), this.currentPropertyContext);
        BNode bnode = this.rdfWriter.getFreshBNode();
        this.addSomeValuesRestriction(bnode, propertyUri, rangeUri);
        try {
            this.rdfWriter.writeTripleValueObject(this.currentSubject, RdfWriter.RDF_TYPE, (Value)bnode);
        }
        catch (RDFHandlerException e) {
            throw new RuntimeException(e.toString(), e);
        }
        return null;
    }

    @Override
    public Void visit(NoValueSnak snak) {
        String rangeUri = this.getRangeUri(snak.getPropertyId());
        if (rangeUri == null) {
            logger.error("Count not export NoValueSnak for property " + snak.getPropertyId().getId() + ": OWL range not known.");
            return null;
        }
        if (!"http://www.w3.org/2002/07/owl#Thing".equals(rangeUri)) {
            rangeUri = "http://www.w3.org/2000/01/rdf-schema#Literal";
        }
        String propertyUri = Vocabulary.getPropertyUri(snak.getPropertyId(), this.currentPropertyContext);
        BNode bnode = this.rdfWriter.getFreshBNode();
        this.addNoValuesRestriction(bnode, propertyUri, rangeUri);
        try {
            this.rdfWriter.writeTripleValueObject(this.currentSubject, RdfWriter.RDF_TYPE, (Value)bnode);
        }
        catch (RDFHandlerException e) {
            throw new RuntimeException(e.toString(), e);
        }
        return null;
    }

    public void writeAuxiliaryTriples() throws RDFHandlerException {
        for (PropertyRestriction pr : this.someValuesQueue) {
            this.writeSomeValueRestriction(pr.propertyUri, pr.rangeUri, pr.subject);
        }
        this.someValuesQueue.clear();
        for (PropertyRestriction pr : this.noValuesQueue) {
            this.writeNoValueRestriction(pr.propertyUri, pr.rangeUri, pr.subject);
        }
        this.noValuesQueue.clear();
        this.valueRdfConverter.writeAuxiliaryTriples();
    }

    void writeSomeValueRestriction(String propertyUri, String rangeUri, Resource bnode) throws RDFHandlerException {
        this.rdfWriter.writeTripleValueObject(bnode, RdfWriter.RDF_TYPE, (Value)RdfWriter.OWL_RESTRICTION);
        this.rdfWriter.writeTripleUriObject(bnode, RdfWriter.OWL_ON_PROPERTY, propertyUri);
        this.rdfWriter.writeTripleUriObject(bnode, RdfWriter.OWL_SOME_VALUES_FROM, rangeUri);
    }

    void writeNoValueRestriction(String propertyUri, String rangeUri, Resource bnode) throws RDFHandlerException {
        BNode bnodeSome = this.rdfWriter.getFreshBNode();
        this.rdfWriter.writeTripleValueObject(bnode, RdfWriter.RDF_TYPE, (Value)RdfWriter.OWL_CLASS);
        this.rdfWriter.writeTripleValueObject(bnode, RdfWriter.OWL_COMPLEMENT_OF, (Value)bnodeSome);
        this.rdfWriter.writeTripleValueObject(bnodeSome, RdfWriter.RDF_TYPE, (Value)RdfWriter.OWL_RESTRICTION);
        this.rdfWriter.writeTripleUriObject(bnodeSome, RdfWriter.OWL_ON_PROPERTY, propertyUri);
        this.rdfWriter.writeTripleUriObject(bnodeSome, RdfWriter.OWL_SOME_VALUES_FROM, rangeUri);
    }

    String getRangeUri(PropertyIdValue propertyIdValue) {
        String datatype;
        switch (datatype = this.propertyRegister.getPropertyType(propertyIdValue)) {
            case "http://www.wikidata.org/ontology#propertyTypeString": {
                this.rdfConversionBuffer.addDatatypeProperty(propertyIdValue);
                return "http://www.w3.org/2001/XMLSchema#string";
            }
            case "http://www.wikidata.org/ontology#propertyTypeCommonsMedia": 
            case "http://www.wikidata.org/ontology#propertyTypeGlobeCoordinates": 
            case "http://www.wikidata.org/ontology#propertyTypeItem": 
            case "http://www.wikidata.org/ontology#propertyTypeQuantity": 
            case "http://www.wikidata.org/ontology#propertyTypeTime": 
            case "http://www.wikidata.org/ontology#propertyTypeUrl": {
                this.rdfConversionBuffer.addObjectProperty(propertyIdValue);
                return "http://www.w3.org/2002/07/owl#Thing";
            }
        }
        return null;
    }

    void addSomeValuesRestriction(Resource subject, String propertyUri, String rangeUri) {
        this.someValuesQueue.add(new PropertyRestriction(subject, propertyUri, rangeUri));
    }

    void addNoValuesRestriction(Resource subject, String propertyUri, String rangeUri) {
        this.noValuesQueue.add(new PropertyRestriction(subject, propertyUri, rangeUri));
    }

    private class PropertyRestriction {
        final Resource subject;
        final String propertyUri;
        final String rangeUri;

        PropertyRestriction(Resource subject, String propertyUri, String rangeUri) {
            this.subject = subject;
            this.propertyUri = propertyUri;
            this.rangeUri = rangeUri;
        }
    }
}

