/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.rdf;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.rio.RDFHandlerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wikidata.wdtk.datamodel.interfaces.Claim;
import org.wikidata.wdtk.datamodel.interfaces.EntityIdValue;
import org.wikidata.wdtk.datamodel.interfaces.ItemDocument;
import org.wikidata.wdtk.datamodel.interfaces.MonolingualTextValue;
import org.wikidata.wdtk.datamodel.interfaces.PropertyDocument;
import org.wikidata.wdtk.datamodel.interfaces.PropertyIdValue;
import org.wikidata.wdtk.datamodel.interfaces.Reference;
import org.wikidata.wdtk.datamodel.interfaces.SiteLink;
import org.wikidata.wdtk.datamodel.interfaces.Sites;
import org.wikidata.wdtk.datamodel.interfaces.Snak;
import org.wikidata.wdtk.datamodel.interfaces.SnakGroup;
import org.wikidata.wdtk.datamodel.interfaces.Statement;
import org.wikidata.wdtk.datamodel.interfaces.StatementDocument;
import org.wikidata.wdtk.datamodel.interfaces.StatementGroup;
import org.wikidata.wdtk.datamodel.interfaces.StatementRank;
import org.wikidata.wdtk.datamodel.interfaces.TermedDocument;
import org.wikidata.wdtk.datamodel.interfaces.ValueSnak;
import org.wikidata.wdtk.datamodel.interfaces.WikimediaLanguageCodes;
import org.wikidata.wdtk.rdf.OwlDeclarationBuffer;
import org.wikidata.wdtk.rdf.PropertyContext;
import org.wikidata.wdtk.rdf.PropertyRegister;
import org.wikidata.wdtk.rdf.RdfWriter;
import org.wikidata.wdtk.rdf.ReferenceRdfConverter;
import org.wikidata.wdtk.rdf.SnakRdfConverter;
import org.wikidata.wdtk.rdf.Vocabulary;
import org.wikidata.wdtk.rdf.values.AnyValueConverter;

public class RdfConverter {
    static final Logger logger = LoggerFactory.getLogger(RdfConverter.class);
    final RdfWriter rdfWriter;
    final AnyValueConverter valueRdfConverter;
    final SnakRdfConverter snakRdfConverter;
    final OwlDeclarationBuffer owlDeclarationBuffer;
    final ReferenceRdfConverter referenceRdfConverter;
    final PropertyRegister propertyRegister;
    final Sites sites;
    int tasks = 1015;

    public RdfConverter(RdfWriter rdfWriter, Sites sites, PropertyRegister propertyRegister) {
        this.sites = sites;
        this.rdfWriter = rdfWriter;
        this.propertyRegister = propertyRegister;
        this.owlDeclarationBuffer = new OwlDeclarationBuffer();
        this.valueRdfConverter = new AnyValueConverter(rdfWriter, this.owlDeclarationBuffer, this.propertyRegister);
        this.snakRdfConverter = new SnakRdfConverter(rdfWriter, this.owlDeclarationBuffer, this.propertyRegister, this.valueRdfConverter);
        this.referenceRdfConverter = new ReferenceRdfConverter(rdfWriter, this.snakRdfConverter, this.propertyRegister.siteUri);
    }

    public void setTasks(int tasks) {
        this.tasks = tasks;
    }

    public int getTasks() {
        return this.tasks;
    }

    public void writeBasicDeclarations() throws RDFHandlerException {
        for (Map.Entry<String, String> uriType : Vocabulary.getKnownVocabularyTypes().entrySet()) {
            this.rdfWriter.writeTripleUriObject(uriType.getKey(), RdfWriter.RDF_TYPE, uriType.getValue());
        }
    }

    public void writeNamespaceDeclarations() throws RDFHandlerException {
        this.rdfWriter.writeNamespaceDeclaration("id", this.propertyRegister.getUriPrefix());
        this.rdfWriter.writeNamespaceDeclaration("wo", "http://www.wikidata.org/ontology#");
        this.rdfWriter.writeNamespaceDeclaration("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        this.rdfWriter.writeNamespaceDeclaration("rdfs", "http://www.w3.org/2000/01/rdf-schema#");
        this.rdfWriter.writeNamespaceDeclaration("owl", "http://www.w3.org/2002/07/owl#");
        this.rdfWriter.writeNamespaceDeclaration("xsd", "http://www.w3.org/2001/XMLSchema#");
        this.rdfWriter.writeNamespaceDeclaration("schema", "http://schema.org/");
        this.rdfWriter.writeNamespaceDeclaration("skos", "http://www.w3.org/2004/02/skos/core#");
        this.rdfWriter.writeNamespaceDeclaration("prov", "http://www.w3.org/ns/prov#");
    }

    public void writeItemDocument(ItemDocument document) throws RDFHandlerException {
        if (!this.hasTask(256)) {
            return;
        }
        String subjectUri = document.getEntityId().getIri();
        URI subject = this.rdfWriter.getUri(subjectUri);
        if ((this.tasks & 0x400F7) != 0) {
            this.rdfWriter.writeTripleValueObject(subject, RdfWriter.RDF_TYPE, (Value)RdfWriter.WB_ITEM);
        }
        this.writeDocumentTerms(subject, document);
        if (this.hasTask(262144)) {
            this.writeSimpleStatements(subject, document);
        }
        if (this.hasTask(131072)) {
            this.writeInstanceOfStatements(subject, document);
        }
        if (this.hasTask(65536)) {
            this.writeSubclassOfStatements(subject, document);
        }
        if (this.hasTask(1)) {
            this.writeStatements(subject, document);
        }
        this.writeSiteLinks(subject, document.getSiteLinks());
        if (this.hasTask(65536)) {
            this.owlDeclarationBuffer.writeClassDeclarations(this.rdfWriter);
        }
        this.snakRdfConverter.writeAuxiliaryTriples();
        this.owlDeclarationBuffer.writePropertyDeclarations(this.rdfWriter, this.hasTask(1), this.hasTask(262144));
        this.referenceRdfConverter.writeReferences();
    }

    public void writePropertyDocument(PropertyDocument document) throws RDFHandlerException {
        this.propertyRegister.setPropertyType(document.getPropertyId(), document.getDatatype().getIri());
        if (!this.hasTask(512)) {
            return;
        }
        String propertyUri = document.getEntityId().getIri();
        URI subject = this.rdfWriter.getUri(propertyUri);
        this.rdfWriter.writeTripleValueObject(subject, RdfWriter.RDF_TYPE, (Value)RdfWriter.WB_PROPERTY);
        this.writeDocumentTerms(subject, document);
        if (this.hasTask(4)) {
            this.rdfWriter.writeTripleValueObject(subject, RdfWriter.WB_PROPERTY_TYPE, (Value)this.rdfWriter.getUri(document.getDatatype().getIri()));
        }
        if (this.hasTask(1)) {
            this.writeStatements(subject, document);
        }
        if (this.hasTask(128)) {
            this.writeInterPropertyLinks(document);
        }
        if (this.hasTask(0x100000)) {
            this.writeSubpropertyOfStatements(subject, document);
        }
        this.snakRdfConverter.writeAuxiliaryTriples();
        this.owlDeclarationBuffer.writePropertyDeclarations(this.rdfWriter, this.hasTask(1), this.hasTask(262144));
        this.referenceRdfConverter.writeReferences();
    }

    void writeInterPropertyLinks(PropertyDocument document) throws RDFHandlerException {
        URI subject = this.rdfWriter.getUri(document.getEntityId().getIri());
        this.rdfWriter.writeTripleUriObject(subject, this.rdfWriter.getUri("http://www.wikidata.org/ontology#propertyStatementLinkage"), Vocabulary.getPropertyUri(document.getPropertyId(), PropertyContext.STATEMENT));
        this.rdfWriter.writeTripleUriObject(subject, this.rdfWriter.getUri("http://www.wikidata.org/ontology#propertyQualifierLinkage"), Vocabulary.getPropertyUri(document.getPropertyId(), PropertyContext.QUALIFIER));
        this.rdfWriter.writeTripleUriObject(subject, this.rdfWriter.getUri("http://www.wikidata.org/ontology#propertyReferenceLinkage"), Vocabulary.getPropertyUri(document.getPropertyId(), PropertyContext.REFERENCE));
        this.rdfWriter.writeTripleUriObject(subject, this.rdfWriter.getUri("http://www.wikidata.org/ontology#propertySimpleClaim"), Vocabulary.getPropertyUri(document.getPropertyId(), PropertyContext.SIMPLE_CLAIM));
        this.rdfWriter.writeTripleUriObject(subject, this.rdfWriter.getUri("http://www.wikidata.org/ontology#propertyValueLinkage"), Vocabulary.getPropertyUri(document.getPropertyId(), PropertyContext.VALUE));
    }

    void writeStatements(Resource subject, StatementDocument statementDocument) throws RDFHandlerException {
        for (StatementGroup statementGroup : statementDocument.getStatementGroups()) {
            URI property = this.rdfWriter.getUri(Vocabulary.getPropertyUri(statementGroup.getProperty(), PropertyContext.STATEMENT));
            for (Statement statement : statementGroup.getStatements()) {
                this.rdfWriter.writeTripleUriObject(subject, property, Vocabulary.getStatementUri(statement));
            }
        }
        for (StatementGroup statementGroup : statementDocument.getStatementGroups()) {
            for (Statement statement : statementGroup.getStatements()) {
                this.writeStatement(statement);
            }
        }
    }

    void writeSimpleStatements(Resource subject, StatementDocument statementDocument) {
        for (StatementGroup statementGroup : statementDocument.getStatementGroups()) {
            for (Statement statement : statementGroup.getStatements()) {
                if (statement.getClaim().getQualifiers().size() != 0) continue;
                this.snakRdfConverter.setSnakContext(subject, PropertyContext.SIMPLE_CLAIM);
                statement.getClaim().getMainSnak().accept(this.snakRdfConverter);
            }
        }
    }

    void writeInstanceOfStatements(Resource subject, ItemDocument itemDocument) {
        for (StatementGroup statementGroup : itemDocument.getStatementGroups()) {
            if (!"P31".equals(statementGroup.getProperty().getId())) continue;
            for (Statement statement : statementGroup.getStatements()) {
                if (!(statement.getClaim().getMainSnak() instanceof ValueSnak) || statement.getClaim().getQualifiers().size() != 0) continue;
                ValueSnak mainSnak = (ValueSnak)statement.getClaim().getMainSnak();
                Value value = this.valueRdfConverter.getRdfValue(mainSnak.getValue(), mainSnak.getPropertyId(), true);
                if (value == null) {
                    logger.error("Could not serialize instance of snak: missing value (Snak: " + mainSnak.toString() + ")");
                    continue;
                }
                try {
                    this.rdfWriter.writeTripleValueObject(subject, RdfWriter.RDF_TYPE, value);
                }
                catch (RDFHandlerException e) {
                    throw new RuntimeException(e.toString(), e);
                }
            }
        }
    }

    void writeSubclassOfStatements(Resource subject, ItemDocument itemDocument) {
        for (StatementGroup statementGroup : itemDocument.getStatementGroups()) {
            boolean isSubClassOf = "P279".equals(statementGroup.getProperty().getId());
            boolean isInstanceOf = "P31".equals(statementGroup.getProperty().getId());
            if (!isInstanceOf && !isSubClassOf) continue;
            for (Statement statement : statementGroup.getStatements()) {
                if (!(statement.getClaim().getMainSnak() instanceof ValueSnak)) continue;
                ValueSnak mainSnak = (ValueSnak)statement.getClaim().getMainSnak();
                if (isSubClassOf) {
                    this.owlDeclarationBuffer.addClass(itemDocument.getEntityId());
                }
                if (mainSnak.getValue() instanceof EntityIdValue) {
                    this.owlDeclarationBuffer.addClass((EntityIdValue)mainSnak.getValue());
                }
                if (statement.getClaim().getQualifiers().size() != 0 || !isSubClassOf) continue;
                Value value = this.valueRdfConverter.getRdfValue(mainSnak.getValue(), mainSnak.getPropertyId(), true);
                if (value == null) {
                    logger.error("Could not serialize subclass of snak: missing value (Snak: " + mainSnak.toString() + ")");
                    continue;
                }
                try {
                    this.rdfWriter.writeTripleValueObject(subject, RdfWriter.RDFS_SUBCLASS_OF, value);
                }
                catch (RDFHandlerException e) {
                    throw new RuntimeException(e.toString(), e);
                }
            }
        }
    }

    void writeSubpropertyOfStatements(Resource subject, PropertyDocument propertyDocument) {
        for (StatementGroup statementGroup : propertyDocument.getStatementGroups()) {
            boolean isSubPropertyOf = "P1647".equals(statementGroup.getProperty().getId());
            if (!isSubPropertyOf) continue;
            for (Statement statement : statementGroup.getStatements()) {
                if (!(statement.getClaim().getMainSnak() instanceof ValueSnak)) continue;
                ValueSnak mainSnak = (ValueSnak)statement.getClaim().getMainSnak();
                if (statement.getClaim().getQualifiers().size() != 0) continue;
                Value value = this.valueRdfConverter.getRdfValue(mainSnak.getValue(), mainSnak.getPropertyId(), true);
                if (value == null) {
                    logger.error("Clould not serialize subclass of snak: missing value (Snak: " + mainSnak.toString() + ")");
                    continue;
                }
                if (mainSnak.getValue() instanceof EntityIdValue) {
                    String id = ((EntityIdValue)mainSnak.getValue()).getId();
                    if (id.startsWith("P")) {
                        String datatype = this.propertyRegister.getPropertyType((PropertyIdValue)mainSnak.getValue());
                        if (!propertyDocument.getDatatype().getIri().equals(datatype)) {
                            logger.warn("Datatype of subproperty " + propertyDocument.getDatatype().toString() + " is different from superproperty " + datatype.toString());
                            continue;
                        }
                    } else {
                        logger.warn(value.toString() + " is not a Property");
                    }
                } else {
                    logger.warn("Not a valid EntityIdValue: " + value.toString());
                    continue;
                }
                try {
                    this.rdfWriter.writeTripleValueObject(subject, RdfWriter.RDFS_SUBPROPERTY_OF, value);
                }
                catch (RDFHandlerException e) {
                    throw new RuntimeException(e.toString(), e);
                }
            }
        }
    }

    void writeDocumentTerms(Resource subject, TermedDocument document) throws RDFHandlerException {
        if (this.hasTask(16)) {
            this.writeTermTriples(subject, RdfWriter.RDFS_LABEL, document.getLabels().values());
        }
        if (this.hasTask(32)) {
            this.writeTermTriples(subject, RdfWriter.SCHEMA_DESCRIPTION, document.getDescriptions().values());
        }
        if (this.hasTask(64)) {
            for (List<MonolingualTextValue> aliases : document.getAliases().values()) {
                this.writeTermTriples(subject, RdfWriter.SKOS_ALT_LABEL, aliases);
            }
        }
    }

    void writeTermTriples(Resource subject, URI predicate, Collection<MonolingualTextValue> terms) throws RDFHandlerException {
        for (MonolingualTextValue mtv : terms) {
            this.rdfWriter.writeTripleValueObject(subject, predicate, RdfConverter.getMonolingualTextValueLiteral(mtv, this.rdfWriter));
        }
    }

    void writeStatementRankTriple(Resource subject, StatementRank rank) {
        try {
            this.rdfWriter.writeTripleUriObject(subject, RdfWriter.WB_RANK, this.getUriStringForRank(rank));
        }
        catch (RDFHandlerException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    void writeStatement(Statement statement) throws RDFHandlerException {
        String statementUri = Vocabulary.getStatementUri(statement);
        URI statementResource = this.rdfWriter.getUri(statementUri);
        this.rdfWriter.writeTripleValueObject(statementResource, RdfWriter.RDF_TYPE, (Value)RdfWriter.WB_STATEMENT);
        this.writeClaim(statementResource, statement.getClaim());
        this.writeReferences(statementResource, statement.getReferences());
        this.writeStatementRankTriple(statementResource, statement.getRank());
    }

    void writeReferences(Resource statementResource, List<? extends Reference> references) throws RDFHandlerException {
        for (Reference reference : references) {
            Resource resource = this.referenceRdfConverter.addReference(reference);
            this.rdfWriter.writeTripleValueObject(statementResource, RdfWriter.PROV_WAS_DERIVED_FROM, (Value)resource);
        }
    }

    void writeClaim(Resource claimResource, Claim claim) {
        this.snakRdfConverter.setSnakContext(claimResource, PropertyContext.VALUE);
        claim.getMainSnak().accept(this.snakRdfConverter);
        this.snakRdfConverter.setSnakContext(claimResource, PropertyContext.QUALIFIER);
        for (SnakGroup snakGroup : claim.getQualifiers()) {
            for (Snak snak : snakGroup.getSnaks()) {
                snak.accept(this.snakRdfConverter);
            }
        }
    }

    void writeSiteLinks(Resource subject, Map<String, SiteLink> siteLinks) throws RDFHandlerException {
        if (!this.hasTask(2)) {
            return;
        }
        for (String key : siteLinks.keySet()) {
            SiteLink siteLink = siteLinks.get(key);
            String siteLinkUrl = this.sites.getSiteLinkUrl(siteLink);
            if (siteLinkUrl != null) {
                String languageCode;
                URI siteLinkUri = this.rdfWriter.getUri(siteLinkUrl);
                this.rdfWriter.writeTripleValueObject(siteLinkUri, RdfWriter.RDF_TYPE, (Value)RdfWriter.WB_ARTICLE);
                this.rdfWriter.writeTripleValueObject(siteLinkUri, RdfWriter.SCHEMA_ABOUT, (Value)subject);
                if ("commonswiki".equals(siteLink.getSiteKey())) continue;
                String siteLanguageCode = this.sites.getLanguageCode(siteLink.getSiteKey());
                try {
                    languageCode = WikimediaLanguageCodes.getLanguageCode(siteLanguageCode);
                }
                catch (IllegalArgumentException e) {
                    languageCode = siteLanguageCode;
                    logger.warn("Unknown Wikimedia language code \"" + languageCode + "\". Using this code in RDF now, but this might be wrong.");
                }
                this.rdfWriter.writeTripleStringObject(siteLinkUri, RdfWriter.SCHEMA_IN_LANGUAGE, languageCode);
                continue;
            }
            logger.warn("Failed to find URL for page \"" + siteLink.getPageTitle() + "\" on site \"" + siteLink.getSiteKey() + "\"");
        }
    }

    public static Value getMonolingualTextValueLiteral(MonolingualTextValue value, RdfWriter rdfWriter) {
        String languageCode;
        try {
            languageCode = WikimediaLanguageCodes.getLanguageCode(value.getLanguageCode());
        }
        catch (IllegalArgumentException e) {
            languageCode = value.getLanguageCode();
            logger.warn("Unknown Wikimedia language code \"" + languageCode + "\". Using this code in RDF now, but this might be wrong.");
        }
        return rdfWriter.getLiteral(value.getText(), languageCode);
    }

    boolean hasTask(int task) {
        return (this.tasks & task) == task;
    }

    String getUriStringForRank(StatementRank rank) {
        switch (rank) {
            case NORMAL: {
                return "http://www.wikidata.org/ontology#NormalRank";
            }
            case PREFERRED: {
                return "http://www.wikidata.org/ontology#PreferredRank";
            }
            case DEPRECATED: {
                return "http://www.wikidata.org/ontology#DeprecatedRank";
            }
        }
        throw new IllegalArgumentException();
    }
}

