/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.rdf;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wikidata.wdtk.datamodel.helpers.Datamodel;
import org.wikidata.wdtk.datamodel.interfaces.EntityDocument;
import org.wikidata.wdtk.datamodel.interfaces.EntityIdValue;
import org.wikidata.wdtk.datamodel.interfaces.GlobeCoordinatesValue;
import org.wikidata.wdtk.datamodel.interfaces.MonolingualTextValue;
import org.wikidata.wdtk.datamodel.interfaces.PropertyDocument;
import org.wikidata.wdtk.datamodel.interfaces.PropertyIdValue;
import org.wikidata.wdtk.datamodel.interfaces.QuantityValue;
import org.wikidata.wdtk.datamodel.interfaces.Statement;
import org.wikidata.wdtk.datamodel.interfaces.StatementGroup;
import org.wikidata.wdtk.datamodel.interfaces.StringValue;
import org.wikidata.wdtk.datamodel.interfaces.TimeValue;
import org.wikidata.wdtk.datamodel.interfaces.ValueSnak;
import org.wikidata.wdtk.wikibaseapi.ApiConnection;
import org.wikidata.wdtk.wikibaseapi.WikibaseDataFetcher;
import org.wikidata.wdtk.wikibaseapi.apierrors.MediaWikiApiErrorException;

public class PropertyRegister {
    static final Logger logger = LoggerFactory.getLogger(PropertyRegister.class);
    WikibaseDataFetcher dataFetcher;
    protected final Map<String, String> datatypes = new HashMap<String, String>();
    protected final Map<String, String> uriPatterns = new HashMap<String, String>();
    final String uriPatternPropertyId;
    final String siteUri;
    final int API_MAX_ENTITY_DOCUMENT_NUMBER = 50;
    int smallestUnfetchedPropertyIdNumber = 1;
    static final PropertyRegister WIKIDATA_PROPERTY_REGISTER = new PropertyRegister("P1921", ApiConnection.getWikidataApiConnection(), Datamodel.SITE_WIKIDATA);

    public PropertyRegister(String uriPatternPropertyId, ApiConnection apiConnection, String siteUri) {
        this.uriPatternPropertyId = uriPatternPropertyId;
        this.siteUri = siteUri;
        this.dataFetcher = new WikibaseDataFetcher(apiConnection, siteUri);
    }

    public static PropertyRegister getWikidataPropertyRegister() {
        return WIKIDATA_PROPERTY_REGISTER;
    }

    public String getUriPrefix() {
        return this.siteUri;
    }

    public String getPropertyType(PropertyIdValue propertyIdValue) {
        if (!this.datatypes.containsKey(propertyIdValue.getId())) {
            this.fetchPropertyInformation(propertyIdValue);
        }
        return this.datatypes.get(propertyIdValue.getId());
    }

    public void setPropertyType(PropertyIdValue propertyIdValue, String datatypeIri) {
        this.datatypes.put(propertyIdValue.getId(), datatypeIri);
    }

    public String getPropertyUriPattern(PropertyIdValue propertyIdValue) {
        if (!this.datatypes.containsKey(propertyIdValue.getId())) {
            this.fetchPropertyInformation(propertyIdValue);
        }
        return this.uriPatterns.get(propertyIdValue.getId());
    }

    public String setPropertyTypeFromEntityIdValue(PropertyIdValue propertyIdValue, EntityIdValue value) {
        switch (value.getId().charAt(0)) {
            case 'Q': {
                return "http://www.wikidata.org/ontology#propertyTypeItem";
            }
            case 'P': {
                return "http://www.wikidata.org/ontology#propertyTypeProperty";
            }
        }
        logger.warn("Could not determine Type of " + propertyIdValue.getId() + ". It is not a valid EntityDocument Id");
        return null;
    }

    public String setPropertyTypeFromGlobeCoordinatesValue(PropertyIdValue propertyIdValue, GlobeCoordinatesValue value) {
        return "http://www.wikidata.org/ontology#propertyTypeGlobeCoordinates";
    }

    public String setPropertyTypeFromQuantityValue(PropertyIdValue propertyIdValue, QuantityValue value) {
        return "http://www.wikidata.org/ontology#propertyTypeQuantity";
    }

    public String setPropertyTypeFromStringValue(PropertyIdValue propertyIdValue, StringValue value) {
        String datatype = this.getPropertyType(propertyIdValue);
        if (datatype == null) {
            logger.warn("Could not fetch datatype of " + propertyIdValue.getIri() + ". Assuming type " + "http://www.wikidata.org/ontology#propertyTypeString");
            return "http://www.wikidata.org/ontology#propertyTypeString";
        }
        return datatype;
    }

    public String setPropertyTypeFromTimeValue(PropertyIdValue propertyIdValue, TimeValue value) {
        return "http://www.wikidata.org/ontology#propertyTypeTime";
    }

    public String setPropertyTypeFromMonolingualTextValue(PropertyIdValue propertyIdValue, MonolingualTextValue value) {
        return "http://www.wikidata.org/ontology#propertyTypeMonolingualText";
    }

    protected void fetchPropertyInformation(PropertyIdValue property) {
        Map<String, EntityDocument> properties;
        int propertyIdNumber = new Integer(property.getId().substring(1));
        if (this.smallestUnfetchedPropertyIdNumber > propertyIdNumber) {
            return;
        }
        ArrayList<String> propertyIds = new ArrayList<String>(50);
        propertyIds.add(property.getId());
        for (int i = 1; i < 50; ++i) {
            propertyIds.add("P" + this.smallestUnfetchedPropertyIdNumber);
            ++this.smallestUnfetchedPropertyIdNumber;
        }
        this.dataFetcher.getFilter().setLanguageFilter(Collections.emptySet());
        this.dataFetcher.getFilter().setSiteLinkFilter(Collections.emptySet());
        try {
            properties = this.dataFetcher.getEntityDocuments(propertyIds);
        }
        catch (MediaWikiApiErrorException e) {
            logger.error("Error when trying to fetch property data: " + e.toString());
            properties = Collections.emptyMap();
        }
        for (Map.Entry<String, EntityDocument> entry : properties.entrySet()) {
            EntityDocument propertyDocument = entry.getValue();
            if (!(propertyDocument instanceof PropertyDocument)) continue;
            String datatype = ((PropertyDocument)propertyDocument).getDatatype().getIri();
            this.datatypes.put(entry.getKey(), datatype);
            logger.info("Fetched type information for property " + entry.getKey() + " online: " + datatype);
            if (!"http://www.wikidata.org/ontology#propertyTypeString".equals(datatype)) continue;
            for (StatementGroup sg : ((PropertyDocument)propertyDocument).getStatementGroups()) {
                if (!sg.getProperty().getId().equals(this.uriPatternPropertyId)) continue;
                for (Statement statement : sg.getStatements()) {
                    if (!(statement.getClaim().getMainSnak() instanceof ValueSnak) || !(((ValueSnak)statement.getClaim().getMainSnak()).getValue() instanceof StringValue)) continue;
                    String uriPattern = ((StringValue)((ValueSnak)statement.getClaim().getMainSnak()).getValue()).getString();
                    if (this.uriPatterns.containsKey(entry.getKey())) {
                        logger.info("Found multiple URI patterns for property " + entry.getKey() + " but only one is supported in current code.");
                    }
                    this.uriPatterns.put(entry.getKey(), uriPattern);
                }
            }
        }
        if (!this.datatypes.containsKey(property.getId())) {
            logger.error("Failed to fetch type information for property " + property.getId() + " online.");
        }
    }
}

