/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.dumpfiles;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wikidata.wdtk.dumpfiles.MwRevision;
import org.wikidata.wdtk.dumpfiles.MwRevisionProcessor;
import org.wikidata.wdtk.util.Timer;

public class StatisticsMwRevisionProcessor
implements MwRevisionProcessor {
    static final Logger logger = LoggerFactory.getLogger(StatisticsMwRevisionProcessor.class);
    final String name;
    final int logFrequency;
    long totalRevisionCount = 0L;
    long currentRevisionCount = 0L;
    final Timer totalTimer;
    final Timer currentTimer;

    public StatisticsMwRevisionProcessor(String name, int logFrequency) {
        this.name = name;
        this.logFrequency = logFrequency;
        this.totalTimer = Timer.getNamedTimer(name + "-totalTimer", 3);
        this.currentTimer = Timer.getNamedTimer(name + "-currentTimer", 3);
    }

    public long getTotalRevisionCount() {
        return this.totalRevisionCount;
    }

    public long getCurrentRevisionCount() {
        return this.currentRevisionCount;
    }

    @Override
    public void startRevisionProcessing(String siteName, String baseUrl, Map<Integer, String> namespaces) {
        this.currentRevisionCount = 0L;
        if (!this.totalTimer.isRunning()) {
            this.totalTimer.reset();
            this.totalTimer.start();
        }
        this.currentTimer.reset();
        this.currentTimer.start();
        logger.info("[" + this.name + "] Starting processing run for \"" + siteName + "\" (" + baseUrl + ").");
        logger.info("[" + this.name + "] Namespaces: " + namespaces.toString());
    }

    @Override
    public void processRevision(MwRevision mwRevision) {
        ++this.currentRevisionCount;
        ++this.totalRevisionCount;
        if (this.logFrequency > 0 && this.totalRevisionCount % (long)this.logFrequency == 0L) {
            this.logProgress();
        }
    }

    @Override
    public void finishRevisionProcessing() {
        this.logProgress();
        logger.info("[" + this.name + "] Finished processing run.");
    }

    void logProgress() {
        this.currentTimer.stop();
        this.totalTimer.stop();
        if (this.totalRevisionCount > 0L) {
            logger.info("[" + this.name + "] Processed " + this.totalRevisionCount + " revisions (total) in " + this.totalTimer.getTotalWallTime() / 1000000000L + "s (wall)/" + this.totalTimer.getTotalCpuTime() / 1000000000L + "s (cpu). " + "Time per revision (mics): " + this.totalTimer.getTotalWallTime() / this.totalRevisionCount / 1000L + "/" + this.totalTimer.getTotalCpuTime() / this.totalRevisionCount / 1000L);
        }
        if (this.currentRevisionCount > 0L) {
            logger.info("[" + this.name + "] Processed " + this.currentRevisionCount + " revisions (current run) in " + this.currentTimer.getTotalWallTime() / 1000000000L + "s (wall)/" + this.currentTimer.getTotalCpuTime() / 1000000000L + "s (cpu)." + " Time per revision (mics): " + this.currentTimer.getTotalWallTime() / this.currentRevisionCount / 1000L + "/" + this.currentTimer.getTotalCpuTime() / this.currentRevisionCount / 1000L);
        }
        this.currentTimer.start();
        this.totalTimer.start();
    }
}

