/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.dumpfiles;

import org.wikidata.wdtk.dumpfiles.MwRevision;

public class MwRevisionImpl
implements MwRevision {
    String prefixedTitle;
    String timeStamp;
    String text;
    String model;
    String format;
    String comment;
    String contributor;
    int contributorId;
    int namespace;
    int pageId;
    long revisionId;

    public MwRevisionImpl() {
        this.resetCurrentPageData();
        this.resetCurrentRevisionData();
    }

    public MwRevisionImpl(MwRevision mwRevision) {
        this.prefixedTitle = mwRevision.getPrefixedTitle();
        this.timeStamp = mwRevision.getTimeStamp();
        this.text = mwRevision.getText();
        this.model = mwRevision.getModel();
        this.format = mwRevision.getFormat();
        this.comment = mwRevision.getComment();
        this.contributor = mwRevision.getContributor();
        this.contributorId = mwRevision.getContributorId();
        this.namespace = mwRevision.getNamespace();
        this.pageId = mwRevision.getPageId();
        this.revisionId = mwRevision.getRevisionId();
    }

    @Override
    public String getPrefixedTitle() {
        return this.prefixedTitle;
    }

    @Override
    public String getTitle() {
        if (this.namespace == 0) {
            return this.prefixedTitle;
        }
        return this.prefixedTitle.substring(this.prefixedTitle.indexOf(58) + 1);
    }

    @Override
    public int getNamespace() {
        return this.namespace;
    }

    @Override
    public int getPageId() {
        return this.pageId;
    }

    @Override
    public long getRevisionId() {
        return this.revisionId;
    }

    @Override
    public String getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public String getModel() {
        return this.model;
    }

    @Override
    public String getFormat() {
        return this.format;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public String getContributor() {
        return this.contributor;
    }

    @Override
    public int getContributorId() {
        return this.contributorId;
    }

    @Override
    public boolean hasRegisteredContributor() {
        return this.contributorId >= 0;
    }

    void resetCurrentPageData() {
        this.prefixedTitle = null;
        this.pageId = -1;
        this.namespace = 0;
    }

    void resetCurrentRevisionData() {
        this.revisionId = -1L;
        this.text = null;
        this.comment = null;
        this.format = null;
        this.timeStamp = null;
        this.model = null;
    }

    public String toString() {
        return "Revision " + this.revisionId + " of page " + this.prefixedTitle + " (ns " + this.namespace + ", id " + this.pageId + "). Created at " + this.timeStamp + " by " + this.contributor + " (" + this.contributorId + ") with comment \"" + this.comment + "\". Model " + this.model + " (" + this.format + "). Text length: " + this.text.length();
    }
}

