/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.dumpfiles;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wikidata.wdtk.dumpfiles.MwDumpFile;
import org.wikidata.wdtk.dumpfiles.MwDumpFileProcessor;
import org.wikidata.wdtk.dumpfiles.MwDumpFormatException;
import org.wikidata.wdtk.dumpfiles.MwRevisionImpl;
import org.wikidata.wdtk.dumpfiles.MwRevisionProcessor;

public class MwRevisionDumpFileProcessor
implements MwDumpFileProcessor {
    static final String E_MEDIAWIKI = "mediawiki";
    static final String E_SITEINFO = "siteinfo";
    static final String E_SITENAME = "sitename";
    static final String E_BASEURL = "base";
    static final String E_NAMESPACE = "namespace";
    static final String A_NSKEY = "key";
    static final String E_PAGE = "page";
    static final String E_PAGE_TITLE = "title";
    static final String E_PAGE_ID = "id";
    static final String E_PAGE_NAMESPACE = "ns";
    static final String E_PAGE_REVISION = "revision";
    static final String E_PAGE_REDIRECT = "redirect";
    static final String E_REV_ID = "id";
    static final String E_REV_PARENT_ID = "parentid";
    static final String E_REV_TIMESTAMP = "timestamp";
    static final String E_REV_COMMENT = "comment";
    static final String E_REV_MODEL = "model";
    static final String E_REV_TEXT = "text";
    static final String E_REV_CONTRIBUTOR = "contributor";
    static final String E_REV_FORMAT = "format";
    static final String E_REV_SHA1 = "sha1";
    static final String E_REV_MINOR = "minor";
    static final String E_CONTRIBUTOR_NAME = "username";
    static final String E_CONTRIBUTOR_ID = "id";
    static final String E_CONTRIBUTOR_IP = "ip";
    static final Logger logger = LoggerFactory.getLogger(MwRevisionDumpFileProcessor.class);
    XMLInputFactory xmlFactory = XMLInputFactory.newInstance();
    XMLStreamReader xmlReader;
    final Map<Integer, String> namespaces = new HashMap<Integer, String>();
    String sitename = "";
    String baseUrl = "";
    final MwRevisionImpl mwRevision = new MwRevisionImpl();
    final MwRevisionProcessor mwRevisionProcessor;

    public MwRevisionDumpFileProcessor(MwRevisionProcessor mwRevisionProcessor) {
        this.mwRevisionProcessor = mwRevisionProcessor;
        this.reset();
    }

    public void reset() {
        this.namespaces.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processDumpFileContents(InputStream inputStream, MwDumpFile dumpFile) {
        logger.info("Processing revision dump file " + dumpFile.toString());
        this.namespaces.clear();
        this.sitename = "";
        this.baseUrl = "";
        this.xmlReader = null;
        try {
            this.xmlReader = this.xmlFactory.createXMLStreamReader(inputStream);
            this.processXmlMediawiki();
        }
        catch (XMLStreamException | MwDumpFormatException e) {
            logger.error(e.toString());
        }
        finally {
            if (this.xmlReader != null) {
                try {
                    this.xmlReader.close();
                }
                catch (XMLStreamException e) {
                    throw new RuntimeException("Problem closing XML Reader. This hides an earlier exception.", e);
                }
            }
        }
        this.mwRevisionProcessor.finishRevisionProcessing();
    }

    void processXmlMediawiki() throws XMLStreamException, MwDumpFormatException {
        while (this.xmlReader.hasNext()) {
            switch (this.xmlReader.getEventType()) {
                case 1: {
                    switch (this.xmlReader.getLocalName()) {
                        case "mediawiki": {
                            break;
                        }
                        case "siteinfo": {
                            this.processXmlSiteinfo();
                            this.mwRevisionProcessor.startRevisionProcessing(this.sitename, this.baseUrl, this.namespaces);
                            break;
                        }
                        case "page": {
                            this.tryProcessXmlPage();
                        }
                    }
                    break;
                }
                case 2: {
                    if (E_MEDIAWIKI.equals(this.xmlReader.getLocalName())) break;
                    throw new MwDumpFormatException("Unexpected end element </" + this.xmlReader.getLocalName() + ">.");
                }
            }
            this.xmlReader.next();
        }
    }

    void processXmlSiteinfo() throws XMLStreamException {
        this.xmlReader.next();
        while (this.xmlReader.hasNext()) {
            switch (this.xmlReader.getEventType()) {
                case 1: {
                    switch (this.xmlReader.getLocalName()) {
                        case "sitename": {
                            this.sitename = this.xmlReader.getElementText();
                            break;
                        }
                        case "namespace": {
                            Integer namespaceKey = new Integer(this.xmlReader.getAttributeValue(null, A_NSKEY));
                            this.namespaces.put(namespaceKey, this.xmlReader.getElementText());
                            break;
                        }
                        case "base": {
                            this.baseUrl = this.xmlReader.getElementText();
                        }
                    }
                    break;
                }
                case 2: {
                    if (!E_SITEINFO.equals(this.xmlReader.getLocalName())) break;
                    return;
                }
            }
            this.xmlReader.next();
        }
    }

    void tryProcessXmlPage() throws XMLStreamException {
        try {
            this.processXmlPage();
        }
        catch (MwDumpFormatException e) {
            logger.error("Error when trying to process revision block for page \"" + this.mwRevision.getPrefixedTitle() + "\" (namespace " + this.mwRevision.getNamespace() + ", id " + this.mwRevision.getPageId() + "): " + e.toString());
            logger.info("Trying to recover ...");
            while (this.xmlReader.hasNext()) {
                this.xmlReader.next();
                if (this.xmlReader.getEventType() != 2 || this.xmlReader.getLocalName() != E_PAGE) continue;
                logger.info("... recovery successful. Continuing processing.");
                return;
            }
            logger.error("Recovery failed. Could not process remaining XML.");
        }
    }

    void processXmlPage() throws XMLStreamException, MwDumpFormatException {
        this.mwRevision.resetCurrentPageData();
        this.xmlReader.next();
        while (this.xmlReader.hasNext()) {
            block0 : switch (this.xmlReader.getEventType()) {
                case 1: {
                    switch (this.xmlReader.getLocalName()) {
                        case "title": {
                            this.mwRevision.prefixedTitle = this.xmlReader.getElementText();
                            break block0;
                        }
                        case "ns": {
                            this.mwRevision.namespace = new Integer(this.xmlReader.getElementText());
                            break block0;
                        }
                        case "id": {
                            this.mwRevision.pageId = new Integer(this.xmlReader.getElementText());
                            break block0;
                        }
                        case "revision": {
                            this.processXmlRevision();
                            break block0;
                        }
                        case "redirect": {
                            break block0;
                        }
                    }
                    throw new MwDumpFormatException("Unexpected element \"" + this.xmlReader.getLocalName() + "\" in page.");
                }
                case 2: {
                    if (!E_PAGE.equals(this.xmlReader.getLocalName())) break;
                    return;
                }
            }
            this.xmlReader.next();
        }
    }

    void processXmlRevision() throws XMLStreamException, MwDumpFormatException {
        this.mwRevision.resetCurrentRevisionData();
        this.xmlReader.next();
        while (this.xmlReader.hasNext()) {
            block0 : switch (this.xmlReader.getEventType()) {
                case 1: {
                    switch (this.xmlReader.getLocalName()) {
                        case "comment": {
                            this.mwRevision.comment = this.xmlReader.getElementText();
                            break block0;
                        }
                        case "text": {
                            this.mwRevision.text = this.xmlReader.getElementText();
                            break block0;
                        }
                        case "timestamp": {
                            this.mwRevision.timeStamp = this.xmlReader.getElementText();
                            break block0;
                        }
                        case "format": {
                            this.mwRevision.format = this.xmlReader.getElementText();
                            break block0;
                        }
                        case "model": {
                            this.mwRevision.model = this.xmlReader.getElementText();
                            break block0;
                        }
                        case "contributor": {
                            this.processXmlContributor();
                            break block0;
                        }
                        case "id": {
                            this.mwRevision.revisionId = new Long(this.xmlReader.getElementText());
                            break block0;
                        }
                        case "parentid": 
                        case "sha1": 
                        case "minor": {
                            break block0;
                        }
                    }
                    throw new MwDumpFormatException("Unexpected element \"" + this.xmlReader.getLocalName() + "\" in revision.");
                }
                case 2: {
                    if (!E_PAGE_REVISION.equals(this.xmlReader.getLocalName())) break;
                    this.mwRevisionProcessor.processRevision(this.mwRevision);
                    return;
                }
            }
            this.xmlReader.next();
        }
    }

    void processXmlContributor() throws XMLStreamException, MwDumpFormatException {
        this.xmlReader.next();
        while (this.xmlReader.hasNext()) {
            block0 : switch (this.xmlReader.getEventType()) {
                case 1: {
                    switch (this.xmlReader.getLocalName()) {
                        case "username": {
                            this.mwRevision.contributor = this.xmlReader.getElementText();
                            break block0;
                        }
                        case "id": {
                            this.mwRevision.contributorId = new Integer(this.xmlReader.getElementText());
                            break block0;
                        }
                        case "ip": {
                            this.mwRevision.contributor = this.xmlReader.getElementText();
                            this.mwRevision.contributorId = -1;
                            break block0;
                        }
                    }
                    throw new MwDumpFormatException("Unexpected element \"" + this.xmlReader.getLocalName() + "\" in contributor.");
                }
                case 2: {
                    if (!E_REV_CONTRIBUTOR.equals(this.xmlReader.getLocalName())) break;
                    return;
                }
            }
            this.xmlReader.next();
        }
    }
}

