/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.dumpfiles;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wikidata.wdtk.datamodel.interfaces.EntityDocumentProcessor;
import org.wikidata.wdtk.datamodel.json.jackson.JacksonItemDocument;
import org.wikidata.wdtk.datamodel.json.jackson.JacksonPropertyDocument;
import org.wikidata.wdtk.datamodel.json.jackson.JacksonTermedStatementDocument;
import org.wikidata.wdtk.dumpfiles.MwDumpFile;
import org.wikidata.wdtk.dumpfiles.MwDumpFileProcessor;

public class JsonDumpFileProcessor
implements MwDumpFileProcessor {
    static final Logger logger = LoggerFactory.getLogger(JsonDumpFileProcessor.class);
    private final ObjectMapper mapper = new ObjectMapper();
    private final ObjectReader documentReader = this.mapper.reader(JacksonTermedStatementDocument.class);
    private final EntityDocumentProcessor entityDocumentProcessor;
    private final String siteIri;

    public JsonDumpFileProcessor(EntityDocumentProcessor entityDocumentProcessor, String siteIri) {
        this.entityDocumentProcessor = entityDocumentProcessor;
        this.siteIri = siteIri;
    }

    @Override
    public void processDumpFileContents(InputStream inputStream, MwDumpFile dumpFile) {
        logger.info("Processing JSON dump file " + dumpFile.toString());
        try {
            try {
                MappingIterator documentIterator = this.documentReader.readValues(inputStream);
                documentIterator.getParser().disable(JsonParser.Feature.AUTO_CLOSE_SOURCE);
                while (documentIterator.hasNextValue()) {
                    JacksonTermedStatementDocument document = (JacksonTermedStatementDocument)documentIterator.nextValue();
                    this.handleDocument(document);
                }
                documentIterator.close();
            }
            catch (JsonProcessingException e) {
                this.logJsonProcessingException(e);
                this.processDumpFileContentsRecovery(inputStream);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot read JSON input: " + e.getMessage(), e);
        }
    }

    private void logJsonProcessingException(JsonProcessingException exception) {
        logger.error("Error when reading JSON for entity: " + exception.getMessage());
    }

    private void handleDocument(JacksonTermedStatementDocument document) {
        document.setSiteIri(this.siteIri);
        if (document != null) {
            if (document instanceof JacksonItemDocument) {
                this.entityDocumentProcessor.processItemDocument((JacksonItemDocument)document);
            } else if (document instanceof JacksonPropertyDocument) {
                this.entityDocumentProcessor.processPropertyDocument((JacksonPropertyDocument)document);
            }
        }
    }

    private void processDumpFileContentsRecovery(InputStream inputStream) throws IOException {
        logger.warn("Entering recovery mode to parse rest of file. This might be slightly slower.");
        BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
        String line = br.readLine();
        if (line == null) {
            return;
        }
        if (line.length() >= 100) {
            line = line.substring(0, 100) + "[...]" + line.substring(line.length() - 50);
        }
        logger.warn("Skipping rest of current line: " + line);
        line = br.readLine();
        while (line != null && line.length() > 1) {
            try {
                JacksonTermedStatementDocument document = line.charAt(line.length() - 1) == ',' ? (JacksonTermedStatementDocument)this.documentReader.readValue(line.substring(0, line.length() - 1)) : (JacksonTermedStatementDocument)this.documentReader.readValue(line);
                this.handleDocument(document);
            }
            catch (JsonProcessingException e) {
                this.logJsonProcessingException(e);
                logger.error("Problematic line was: " + line.substring(0, Math.min(50, line.length())) + "...");
            }
            line = br.readLine();
        }
    }
}

