/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.json.jackson.datavalues;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;

@JsonIgnoreProperties(ignoreUnknown=true)
public class JacksonInnerQuantity {
    private BigDecimal amount;
    private BigDecimal upperBound;
    private BigDecimal lowerBound;
    private String jsonUnit;

    public JacksonInnerQuantity() {
    }

    public JacksonInnerQuantity(BigDecimal amount, BigDecimal upperBound, BigDecimal lowerBound, String unit) {
        this.amount = amount;
        this.upperBound = upperBound;
        this.lowerBound = lowerBound;
        this.jsonUnit = "".equals(unit) ? "1" : unit;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public BigDecimal getUpperBound() {
        return this.upperBound;
    }

    public void setUpperBound(BigDecimal upperBound) {
        this.upperBound = upperBound;
    }

    public BigDecimal getLowerBound() {
        return this.lowerBound;
    }

    public void setLowerBound(BigDecimal lowerBound) {
        this.lowerBound = lowerBound;
    }

    @JsonProperty(value="amount")
    public String getAmountAsString() {
        return this.bigDecimalToSignedString(this.amount);
    }

    @JsonProperty(value="upperBound")
    public String getUpperBoundAsString() {
        return this.bigDecimalToSignedString(this.upperBound);
    }

    @JsonProperty(value="lowerBound")
    public String getLowerBoundAsString() {
        return this.bigDecimalToSignedString(this.lowerBound);
    }

    @JsonProperty(value="unit")
    public String getJsonUnit() {
        return this.jsonUnit;
    }

    @JsonProperty(value="unit")
    public void setJsonUnit(String unit) {
        this.jsonUnit = unit;
    }

    public String getUnit() {
        if ("1".equals(this.jsonUnit)) {
            return "";
        }
        return this.jsonUnit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JacksonInnerQuantity)) {
            return false;
        }
        JacksonInnerQuantity other = (JacksonInnerQuantity)o;
        return this.amount.equals(other.amount) && this.lowerBound.equals(other.lowerBound) && this.upperBound.equals(other.upperBound) && this.jsonUnit.equals(other.jsonUnit);
    }

    private String bigDecimalToSignedString(BigDecimal value) {
        if (value.signum() < 0) {
            return value.toString();
        }
        return "+" + value.toString();
    }
}

