/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.json.jackson;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.wikidata.wdtk.datamodel.helpers.Equality;
import org.wikidata.wdtk.datamodel.helpers.Hash;
import org.wikidata.wdtk.datamodel.helpers.ToString;
import org.wikidata.wdtk.datamodel.interfaces.PropertyIdValue;
import org.wikidata.wdtk.datamodel.interfaces.Snak;
import org.wikidata.wdtk.datamodel.interfaces.SnakGroup;
import org.wikidata.wdtk.datamodel.json.jackson.JacksonSnak;

public class SnakGroupFromJson
implements SnakGroup {
    private final List<Snak> snaks;

    public SnakGroupFromJson(List<JacksonSnak> snaks) {
        this.snaks = Collections.unmodifiableList(snaks);
    }

    @Override
    public List<Snak> getSnaks() {
        return this.snaks;
    }

    @Override
    public PropertyIdValue getProperty() {
        return this.snaks.get(0).getPropertyId();
    }

    @Override
    public Iterator<Snak> iterator() {
        return this.snaks.iterator();
    }

    public static List<SnakGroup> makeSnakGroups(Map<String, List<JacksonSnak>> snaks, List<String> propertyOrder) {
        ArrayList<SnakGroup> result = new ArrayList<SnakGroup>(snaks.size());
        for (String propertyName : propertyOrder) {
            result.add(new SnakGroupFromJson(snaks.get(propertyName)));
        }
        return result;
    }

    public int hashCode() {
        return Hash.hashCode(this);
    }

    public boolean equals(Object obj) {
        return Equality.equalsSnakGroup(this, obj);
    }

    public String toString() {
        return ToString.toString(this);
    }
}

