/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.implementation;

import java.io.Serializable;
import org.apache.commons.lang3.Validate;
import org.wikidata.wdtk.datamodel.helpers.Equality;
import org.wikidata.wdtk.datamodel.helpers.Hash;
import org.wikidata.wdtk.datamodel.interfaces.EntityIdValue;
import org.wikidata.wdtk.datamodel.interfaces.ValueVisitor;

public abstract class NumericEntityIdValueImpl
implements EntityIdValue,
Serializable {
    private static final long serialVersionUID = -4151826012979199651L;
    final int id;
    final String siteIri;

    NumericEntityIdValueImpl(int id, String siteIri) {
        Validate.notNull(siteIri, "Entity site IRIs cannot be null", new Object[0]);
        this.id = id;
        this.siteIri = siteIri;
    }

    @Override
    public String getIri() {
        return this.siteIri.concat(this.getId());
    }

    @Override
    public String getSiteIri() {
        return this.siteIri;
    }

    @Override
    public <T> T accept(ValueVisitor<T> valueVisitor) {
        return valueVisitor.visit(this);
    }

    public int hashCode() {
        return Hash.hashCode(this);
    }

    public boolean equals(Object obj) {
        return Equality.equalsEntityIdValue(this, obj);
    }
}

