/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.implementation;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.wikidata.wdtk.datamodel.helpers.Equality;
import org.wikidata.wdtk.datamodel.helpers.Hash;
import org.wikidata.wdtk.datamodel.helpers.ToString;
import org.wikidata.wdtk.datamodel.implementation.TermedStatementDocumentImpl;
import org.wikidata.wdtk.datamodel.interfaces.EntityIdValue;
import org.wikidata.wdtk.datamodel.interfaces.ItemDocument;
import org.wikidata.wdtk.datamodel.interfaces.ItemIdValue;
import org.wikidata.wdtk.datamodel.interfaces.MonolingualTextValue;
import org.wikidata.wdtk.datamodel.interfaces.SiteLink;
import org.wikidata.wdtk.datamodel.interfaces.StatementGroup;

public class ItemDocumentImpl
extends TermedStatementDocumentImpl
implements ItemDocument,
Serializable {
    private static final long serialVersionUID = -2189045553879194935L;
    final ItemIdValue itemId;
    final Map<String, SiteLink> siteLinks;

    ItemDocumentImpl(ItemIdValue itemIdValue, List<MonolingualTextValue> labels, List<MonolingualTextValue> descriptions, List<MonolingualTextValue> aliases, List<StatementGroup> statementGroups, Map<String, SiteLink> siteLinks, long revisionId) {
        super(itemIdValue, labels, descriptions, aliases, statementGroups, revisionId);
        Validate.notNull(itemIdValue, "item ID cannot be null", new Object[0]);
        Validate.notNull(siteLinks, "site links cannot be null", new Object[0]);
        this.itemId = itemIdValue;
        this.siteLinks = siteLinks;
    }

    @Override
    public EntityIdValue getEntityId() {
        return this.itemId;
    }

    @Override
    public ItemIdValue getItemId() {
        return this.itemId;
    }

    @Override
    public Map<String, SiteLink> getSiteLinks() {
        return Collections.unmodifiableMap(this.siteLinks);
    }

    public int hashCode() {
        return Hash.hashCode(this);
    }

    public boolean equals(Object obj) {
        return Equality.equalsItemDocument(this, obj);
    }

    public String toString() {
        return ToString.toString(this);
    }
}

