/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.client;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.text.WordUtils;
import org.openrdf.rio.RDFFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wikidata.wdtk.client.DumpProcessingOutputAction;
import org.wikidata.wdtk.datamodel.interfaces.ItemDocument;
import org.wikidata.wdtk.datamodel.interfaces.PropertyDocument;
import org.wikidata.wdtk.rdf.PropertyRegister;
import org.wikidata.wdtk.rdf.RdfSerializer;

public class RdfSerializationAction
extends DumpProcessingOutputAction {
    static final Logger logger = LoggerFactory.getLogger(DumpProcessingOutputAction.class);
    public static final String OPTION_RDF_TASKS = "rdftasks";
    public static final Map<String, Integer> KNOWN_TASKS = new HashMap<String, Integer>();
    public static final Map<String, String> TASK_HELP;
    public static final String DEFAULT_FILE_NAME = "{PROJECT}-{DATE}.rdf";
    public static final String DEFAULT_ACTION_NAME = "RdfSerializationAction";
    RdfSerializer serializer;
    String taskName = "";
    int tasks = 0;

    public RdfSerializationAction() {
        this.outputDestination = DEFAULT_FILE_NAME;
    }

    @Override
    public boolean setOption(String option, String value) {
        if (super.setOption(option, value)) {
            return true;
        }
        switch (option) {
            case "rdftasks": {
                this.setTasks(value);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean needsSites() {
        return this.tasks != 0;
    }

    @Override
    public boolean isReady() {
        if (this.tasks == 0) {
            this.printHelp();
            return false;
        }
        return true;
    }

    @Override
    public void open() {
        try {
            this.serializer = this.createRdfSerializer();
            this.serializer.open();
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public void processItemDocument(ItemDocument itemDocument) {
        this.serializer.processItemDocument(itemDocument);
    }

    @Override
    public void processPropertyDocument(PropertyDocument propertyDocument) {
        this.serializer.processPropertyDocument(propertyDocument);
    }

    @Override
    public void close() {
        this.serializer.close();
        super.close();
    }

    protected RdfSerializer createRdfSerializer() throws IOException {
        String outputDestinationFinal = this.outputDestination != null ? this.outputDestination : "{PROJECT}" + this.taskName + "{DATE}" + ".nt";
        OutputStream exportOutputStream = this.getOutputStream(this.useStdOut, this.insertDumpInformation(outputDestinationFinal), this.compressionType);
        RdfSerializer serializer = new RdfSerializer(RDFFormat.NTRIPLES, exportOutputStream, this.sites, PropertyRegister.getWikidataPropertyRegister());
        serializer.setTasks(this.tasks);
        return serializer;
    }

    private void setTasks(String tasks) {
        for (String task : tasks.split(",")) {
            if (KNOWN_TASKS.containsKey(task)) {
                this.tasks |= KNOWN_TASKS.get(task).intValue();
                this.taskName = this.taskName + (this.taskName.isEmpty() ? "" : "-") + task;
                continue;
            }
            logger.warn("Unsupported RDF serialization task \"" + task + "\". Run without specifying any tasks for help.");
        }
    }

    private void printHelp() {
        ArrayList<String> rdfTasks = new ArrayList<String>(KNOWN_TASKS.keySet());
        Collections.sort(rdfTasks);
        System.out.println("---");
        System.out.println(WordUtils.wrap("Use option --rdftasks to select the supported tasks for RDF export. Tasks may select which entities to consider, and which data to include.", 75) + "\nExample: \"items,labels,aliases\" exports labels and aliases of items." + "\n\nAvailable tasks:");
        for (String supportedTask : rdfTasks) {
            System.out.println(WordUtils.wrap("* \"" + supportedTask + "\": " + TASK_HELP.get(supportedTask), 75, "\n   ", true));
        }
    }

    @Override
    public String getReport() {
        String message = "Finished serialization of " + this.serializer.getTripleCount() + " RDF triples in file " + this.insertDumpInformation(this.outputDestination);
        if (this.compressionType != "") {
            message = message + "." + this.compressionType;
        }
        return message;
    }

    @Override
    public String getDefaultActionName() {
        return DEFAULT_ACTION_NAME;
    }

    static {
        KNOWN_TASKS.put("items", 256);
        KNOWN_TASKS.put("properties", 512);
        KNOWN_TASKS.put("entities", 768);
        KNOWN_TASKS.put("alldata", 247);
        KNOWN_TASKS.put("statements", 1);
        KNOWN_TASKS.put("sitelinks", 2);
        KNOWN_TASKS.put("datatypes", 4);
        KNOWN_TASKS.put("labels", 16);
        KNOWN_TASKS.put("descriptions", 32);
        KNOWN_TASKS.put("aliases", 64);
        KNOWN_TASKS.put("terms", 112);
        KNOWN_TASKS.put("taxonomy", 65536);
        KNOWN_TASKS.put("instanceof", 131072);
        KNOWN_TASKS.put("interpropertylinks", 128);
        KNOWN_TASKS.put("simplestatements", 262144);
        KNOWN_TASKS.put("subproperties", 0x100000);
        TASK_HELP = new HashMap<String, String>();
        TASK_HELP.put("items", "consider items when exporting data");
        TASK_HELP.put("properties", "consider properties when exporting data");
        TASK_HELP.put("entities", "consider all entities when exporting data");
        TASK_HELP.put("alldata", "export all data available for the considered entities");
        TASK_HELP.put("statements", "export statements for the considered entities");
        TASK_HELP.put("sitelinks", "export site links for the considered entities");
        TASK_HELP.put("datatypes", "export datatypes for the considered entities");
        TASK_HELP.put("labels", "export labels for the considered entities");
        TASK_HELP.put("descriptions", "export descriptions for the considered entities");
        TASK_HELP.put("aliases", "export labels for the considered entities");
        TASK_HELP.put("terms", "shortcut for labels,descriptions,aliases");
        TASK_HELP.put("taxonomy", "export unqualified subclass information for the considered entities");
        TASK_HELP.put("instanceof", "export unqualified instanceof information for the considered entities");
        TASK_HELP.put("simplestatements", "export unqualified statements without references as single triples");
        TASK_HELP.put("interpropertylinks", "export triples which connect wikidata properties and there respective rdf properties in different contexts");
        TASK_HELP.put("subproperties", "export unqualified subpropertyof information in the considered entities");
    }
}

