/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.client;

import java.io.IOException;
import java.io.OutputStream;
import org.wikidata.wdtk.client.DumpProcessingOutputAction;
import org.wikidata.wdtk.datamodel.interfaces.ItemDocument;
import org.wikidata.wdtk.datamodel.interfaces.PropertyDocument;
import org.wikidata.wdtk.datamodel.json.jackson.JsonSerializer;

public class JsonSerializationAction
extends DumpProcessingOutputAction {
    public static final String DEFAULT_FILE_NAME = "{PROJECT}-{DATE}.json";
    public static final String DEFAULT_ACTION_NAME = "JsonSerializationAction";
    JsonSerializer serializer;

    public JsonSerializationAction() {
        this.outputDestination = DEFAULT_FILE_NAME;
    }

    @Override
    public boolean needsSites() {
        return false;
    }

    @Override
    public boolean isReady() {
        return true;
    }

    @Override
    public void open() {
        try {
            OutputStream outputStream = this.getOutputStream(this.useStdOut, this.getOutputFilename(), this.compressionType);
            this.serializer = new JsonSerializer(outputStream);
            this.serializer.open();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void processItemDocument(ItemDocument itemDocument) {
        this.serializer.processItemDocument(itemDocument);
    }

    @Override
    public void processPropertyDocument(PropertyDocument propertyDocument) {
        this.serializer.processPropertyDocument(propertyDocument);
    }

    @Override
    public void close() {
        this.serializer.close();
        super.close();
    }

    @Override
    public String getReport() {
        String message = "Finished serialization of " + this.serializer.getEntityDocumentCount() + " EntityDocuments in file " + this.getOutputFilename();
        if (this.compressionType != "") {
            message = message + "." + this.compressionType;
        }
        return message;
    }

    @Override
    public String getDefaultActionName() {
        return DEFAULT_ACTION_NAME;
    }
}

