/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.client;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wikidata.wdtk.client.DumpProcessingAction;
import org.wikidata.wdtk.datamodel.interfaces.Sites;
import org.wikidata.wdtk.util.DirectoryManager;
import org.wikidata.wdtk.util.DirectoryManagerFactory;

public abstract class DumpProcessingOutputAction
implements DumpProcessingAction {
    static final Logger logger = LoggerFactory.getLogger(DumpProcessingAction.class);
    public static final String OPTION_COMPRESSION = "compression";
    public static final String OPTION_DESTINATION = "output";
    public static final String OPTION_USE_STDOUT = "stdout";
    public static final String COMPRESS_BZ2 = "bz2";
    public static final String COMPRESS_GZIP = "gz";
    public static final String COMPRESS_NONE = "";
    protected Set<Closeable> outputStreams = new HashSet<Closeable>();
    protected String name;
    protected Sites sites;
    protected String outputDestination = null;
    protected boolean useStdOut = false;
    protected String compressionType = "";
    protected String dateStamp = "UNKNOWN";
    protected String project = "UNKNOWN";

    @Override
    public void setSites(Sites sites) {
        this.sites = sites;
    }

    @Override
    public boolean setOption(String option, String value) {
        switch (option) {
            case "output": {
                this.outputDestination = value;
                return true;
            }
            case "compression": {
                this.compressionType = value.toLowerCase();
                return true;
            }
            case "stdout": {
                this.useStdOut = value == null || "true".equals(value);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean useStdOut() {
        return this.useStdOut;
    }

    @Override
    public void setDumpInformation(String project, String dateStamp) {
        this.project = project;
        this.dateStamp = dateStamp;
    }

    @Override
    public void setActionName(String name) {
        this.name = name;
    }

    @Override
    public String getActionName() {
        if (this.name != null) {
            return this.name;
        }
        return this.getDefaultActionName();
    }

    public String getOutputFilename() {
        if (this.outputDestination == null) {
            return "unnamed.out";
        }
        return this.insertDumpInformation(this.outputDestination);
    }

    public String insertDumpInformation(String pattern) {
        return pattern.replace("{DATE}", this.dateStamp).replace("{PROJECT}", this.project);
    }

    @Override
    public void close() {
        for (Closeable closeable : this.outputStreams) {
            DumpProcessingOutputAction.close(closeable);
        }
    }

    protected OutputStream getOutputStream(boolean useStdOut, String filePath, String compressionType) throws IOException {
        Path outputDirectory;
        if (useStdOut) {
            return System.out;
        }
        if (!compressionType.isEmpty()) {
            filePath = filePath + "." + compressionType;
        }
        if ((outputDirectory = Paths.get(filePath, new String[0]).getParent()) == null) {
            outputDirectory = Paths.get(".", new String[0]);
        }
        DirectoryManager dm = DirectoryManagerFactory.createDirectoryManager(outputDirectory, false);
        OutputStream out = dm.getOutputStreamForFile(Paths.get(filePath, new String[0]).getFileName().toString());
        BufferedOutputStream bufferedFileOutputStream = new BufferedOutputStream(out, 0x500000);
        switch (compressionType) {
            case "bz2": {
                return this.getAsynchronousOutputStream(new BZip2CompressorOutputStream(bufferedFileOutputStream));
            }
            case "gz": {
                GzipParameters gzipParameters = new GzipParameters();
                gzipParameters.setCompressionLevel(7);
                return this.getAsynchronousOutputStream(new GzipCompressorOutputStream(bufferedFileOutputStream, gzipParameters));
            }
            case "": {
                return bufferedFileOutputStream;
            }
        }
        ((OutputStream)bufferedFileOutputStream).close();
        throw new IllegalArgumentException("Unsupported compression format: " + compressionType);
    }

    protected OutputStream getAsynchronousOutputStream(final OutputStream outputStream) throws IOException {
        int SIZE = 0xA00000;
        PipedOutputStream pos = new PipedOutputStream();
        final PipedInputStream pis = new PipedInputStream(pos, 0xA00000);
        final FinishableRunnable run = new FinishableRunnable(){
            volatile boolean finish = false;
            volatile boolean hasFinished = false;

            @Override
            public void finish() {
                this.finish = true;
                while (!this.hasFinished) {
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    int len;
                    byte[] bytes = new byte[0xA00000];
                    while (!(this.finish && pis.available() <= 0 || (len = pis.read(bytes)) <= 0)) {
                        outputStream.write(bytes, 0, len);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    DumpProcessingOutputAction.close(pis);
                    DumpProcessingOutputAction.close(outputStream);
                    this.hasFinished = true;
                }
            }
        };
        new Thread((Runnable)run, "async-output-stream").start();
        this.outputStreams.add(new Closeable(){

            @Override
            public void close() throws IOException {
                run.finish();
            }
        });
        return pos;
    }

    private static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException ignored) {
                logger.error("Failed to close output stream: " + ignored.getMessage());
            }
        }
    }

    protected static interface FinishableRunnable
    extends Runnable {
        public void finish();
    }
}

