/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.client;

import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.ini4j.Ini;
import org.ini4j.Profile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wikidata.wdtk.client.DumpProcessingAction;
import org.wikidata.wdtk.client.DumpProcessingOutputAction;
import org.wikidata.wdtk.client.JsonSerializationAction;
import org.wikidata.wdtk.client.RdfSerializationAction;
import org.wikidata.wdtk.datamodel.helpers.Datamodel;
import org.wikidata.wdtk.datamodel.interfaces.PropertyIdValue;
import org.wikidata.wdtk.dumpfiles.MwLocalDumpFile;

public class ClientConfiguration {
    static final Logger logger = LoggerFactory.getLogger(ClientConfiguration.class);
    public static final String CMD_OPTION_HELP = "h";
    public static final String CMD_OPTION_CONFIG_FILE = "c";
    public static final String CMD_OPTION_DUMP_LOCATION = "d";
    public static final String CMD_OPTION_QUIET = "q";
    public static final String CMD_OPTION_OFFLINE_MODE = "n";
    public static final String CMD_OPTION_ACTION = "a";
    public static final String CMD_OPTION_OUTPUT_DESTINATION = "o";
    public static final String CMD_OPTION_OUTPUT_COMPRESSION = "z";
    public static final String CMD_OPTION_OUTPUT_STDOUT = "s";
    public static final String CMD_OPTION_CREATE_REPORT = "r";
    public static final String CMD_OPTION_LOCAL_DUMPFILE = "i";
    public static final String OPTION_HELP = "help";
    public static final String OPTION_CONFIG_FILE = "config";
    public static final String OPTION_DUMP_LOCATION = "dumps";
    public static final String OPTION_OFFLINE_MODE = "offline";
    public static final String OPTION_QUIET = "quiet";
    public static final String OPTION_ACTION = "action";
    public static final String OPTION_FILTER_LANGUAGES = "fLang";
    public static final String OPTION_FILTER_SITES = "fSite";
    public static final String OPTION_FILTER_PROPERTIES = "fProp";
    public static final String OPTION_CREATE_REPORT = "report";
    public static final String OPTION_OUTPUT_DESTINATION = "output";
    public static final String OPTION_OUTPUT_COMPRESSION = "compression";
    public static final String OPTION_OUTPUT_STDOUT = "stdout";
    public static final String OPTION_OUTPUT_RDF_TYPE = "rdftasks";
    public static final String OPTION_LOCAL_DUMPFILE = "input";
    static final Map<String, Class<? extends DumpProcessingOutputAction>> KNOWN_ACTIONS = new HashMap<String, Class<? extends DumpProcessingOutputAction>>();
    static final Options options;
    final List<DumpProcessingAction> actions;
    boolean offlineMode = false;
    String dumpDirectoryLocation = null;
    String inputDumpLocation = null;
    String reportFilename = null;
    boolean quiet = false;
    Set<String> filterLanguages = null;
    Set<String> filterSites = null;
    Set<PropertyIdValue> filterProperties = null;

    public ClientConfiguration(String[] args) {
        this.actions = this.handleArguments(args);
    }

    public List<DumpProcessingAction> getActions() {
        return this.actions;
    }

    public String getDumpDirectoryLocation() {
        return this.dumpDirectoryLocation;
    }

    public boolean getOfflineMode() {
        return this.offlineMode;
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    public String getReportFileName() {
        return this.reportFilename;
    }

    public Set<String> getFilterLanguages() {
        return this.filterLanguages;
    }

    public Set<String> getFilterSiteKeys() {
        return this.filterSites;
    }

    public Set<PropertyIdValue> getFilterProperties() {
        return this.filterProperties;
    }

    public String getInputDumpLocation() {
        return this.inputDumpLocation;
    }

    public MwLocalDumpFile getLocalDumpFile() {
        if (this.inputDumpLocation != null) {
            return new MwLocalDumpFile(this.inputDumpLocation);
        }
        return null;
    }

    public void printHelp() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("wdtk-client", options);
    }

    private List<DumpProcessingAction> handleArguments(String[] args) {
        DumpProcessingAction action;
        CommandLine cmd;
        GnuParser parser = new GnuParser();
        try {
            cmd = parser.parse(options, args);
        }
        catch (ParseException e) {
            logger.error("Failed to parse arguments: " + e.getMessage());
            return Collections.emptyList();
        }
        if (cmd.hasOption(CMD_OPTION_HELP) || args.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<DumpProcessingAction> configuration = new ArrayList<DumpProcessingAction>();
        this.handleGlobalArguments(cmd);
        if (cmd.hasOption(CMD_OPTION_ACTION) && (action = this.handleActionArguments(cmd)) != null) {
            configuration.add(action);
        }
        if (cmd.hasOption(CMD_OPTION_CONFIG_FILE)) {
            try {
                List<DumpProcessingAction> configFile = this.readConfigFile(cmd.getOptionValue(CMD_OPTION_CONFIG_FILE));
                configuration.addAll(configFile);
            }
            catch (IOException e) {
                logger.error("Failed to read configuration file \"" + cmd.getOptionValue(CMD_OPTION_CONFIG_FILE) + "\": " + e.toString());
            }
        }
        return configuration;
    }

    private List<DumpProcessingAction> readConfigFile(String path) throws IOException {
        ArrayList<DumpProcessingAction> result = new ArrayList<DumpProcessingAction>();
        FileReader reader = new FileReader(path);
        Ini ini = new Ini(reader);
        for (Profile.Section section : ini.values()) {
            if (section.getName().toLowerCase().equals("general")) {
                this.handleGlobalArguments(section);
                continue;
            }
            DumpProcessingAction action = this.handleActionArguments(section);
            if (action == null) continue;
            action.setActionName(section.getName());
            result.add(action);
        }
        return result;
    }

    private void handleGlobalArguments(CommandLine cmd) {
        if (cmd.hasOption(CMD_OPTION_DUMP_LOCATION)) {
            this.dumpDirectoryLocation = cmd.getOptionValue(CMD_OPTION_DUMP_LOCATION);
        }
        if (cmd.hasOption(CMD_OPTION_OFFLINE_MODE)) {
            this.offlineMode = true;
        }
        if (cmd.hasOption(CMD_OPTION_QUIET)) {
            this.quiet = true;
        }
        if (cmd.hasOption(CMD_OPTION_CREATE_REPORT)) {
            this.reportFilename = cmd.getOptionValue(CMD_OPTION_CREATE_REPORT);
        }
        if (cmd.hasOption(OPTION_FILTER_LANGUAGES)) {
            this.setLanguageFilters(cmd.getOptionValue(OPTION_FILTER_LANGUAGES));
        }
        if (cmd.hasOption(OPTION_FILTER_SITES)) {
            this.setSiteFilters(cmd.getOptionValue(OPTION_FILTER_SITES));
        }
        if (cmd.hasOption(OPTION_FILTER_PROPERTIES)) {
            this.setPropertyFilters(cmd.getOptionValue(OPTION_FILTER_PROPERTIES));
        }
        if (cmd.hasOption(CMD_OPTION_LOCAL_DUMPFILE)) {
            this.inputDumpLocation = cmd.getOptionValue(OPTION_LOCAL_DUMPFILE);
        }
    }

    private void handleGlobalArguments(Profile.Section section) {
        Iterator i$ = section.keySet().iterator();
        block20: while (i$.hasNext()) {
            String key;
            switch (key = (String)i$.next()) {
                case "offline": {
                    if (!((String)section.get(key)).toLowerCase().equals("true")) continue block20;
                    this.offlineMode = true;
                    continue block20;
                }
                case "quiet": {
                    if (!((String)section.get(key)).toLowerCase().equals("true")) continue block20;
                    this.quiet = true;
                    continue block20;
                }
                case "report": {
                    this.reportFilename = (String)section.get(key);
                    continue block20;
                }
                case "dumps": {
                    this.dumpDirectoryLocation = (String)section.get(key);
                    continue block20;
                }
                case "fLang": {
                    this.setLanguageFilters((String)section.get(key));
                    continue block20;
                }
                case "fSite": {
                    this.setSiteFilters((String)section.get(key));
                    continue block20;
                }
                case "fProp": {
                    this.setPropertyFilters((String)section.get(key));
                    continue block20;
                }
                case "input": {
                    this.inputDumpLocation = (String)section.get(key);
                    continue block20;
                }
            }
            logger.warn("Unrecognized option: " + key);
        }
    }

    private DumpProcessingAction handleActionArguments(CommandLine cmd) {
        DumpProcessingAction result = this.makeDumpProcessingAction(cmd.getOptionValue(CMD_OPTION_ACTION).toLowerCase());
        if (result == null) {
            return null;
        }
        for (Option option : cmd.getOptions()) {
            result.setOption(option.getLongOpt(), option.getValue());
        }
        this.checkDuplicateStdOutOutput(result);
        return result;
    }

    private DumpProcessingAction handleActionArguments(Profile.Section section) {
        DumpProcessingAction result = this.makeDumpProcessingAction(((String)section.get(OPTION_ACTION)).toLowerCase());
        if (result == null) {
            return null;
        }
        for (String key : section.keySet()) {
            if (result.setOption(key.toLowerCase(), (String)section.get(key)) || OPTION_ACTION.equals(key.toLowerCase())) continue;
            logger.warn("Unrecognized option: " + key);
        }
        this.checkDuplicateStdOutOutput(result);
        return result;
    }

    private void checkDuplicateStdOutOutput(DumpProcessingAction newAction) {
        if (newAction.useStdOut()) {
            if (this.quiet) {
                logger.warn("Multiple actions are using stdout as output destination.");
            }
            this.quiet = true;
        }
    }

    private DumpProcessingAction makeDumpProcessingAction(String name) {
        if (!KNOWN_ACTIONS.containsKey(name)) {
            logger.error("Unknown action \"" + name + "\".");
            return null;
        }
        try {
            Constructor<? extends DumpProcessingOutputAction> constructor = KNOWN_ACTIONS.get(name).getConstructor(new Class[0]);
            return constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException e) {
            logger.error("Class \"" + KNOWN_ACTIONS.get(name) + "\" that was registered to handle action \"" + name + "\" does not have an appropriate constructor.");
            return null;
        }
        catch (InstantiationException | InvocationTargetException e) {
            logger.error("Error when trying to instantiate handler for action \"" + name + "\":" + e.getMessage());
            return null;
        }
    }

    private void setLanguageFilters(String filters) {
        this.filterLanguages = new HashSet<String>();
        if (!"-".equals(filters)) {
            for (String lang : filters.split(",")) {
                this.filterLanguages.add(lang);
            }
        }
    }

    private void setSiteFilters(String filters) {
        this.filterSites = new HashSet<String>();
        if (!"-".equals(filters)) {
            for (String siteKey : filters.split(",")) {
                this.filterSites.add(siteKey);
            }
        }
    }

    private void setPropertyFilters(String filters) {
        this.filterProperties = new HashSet<PropertyIdValue>();
        if (!"-".equals(filters)) {
            for (String pid : filters.split(",")) {
                this.filterProperties.add(Datamodel.makeWikidataPropertyIdValue(pid));
            }
        }
    }

    private static void initOptions() {
        ArrayList<String> actions = new ArrayList<String>(KNOWN_ACTIONS.keySet());
        Collections.sort(actions);
        OptionBuilder.hasArg();
        OptionBuilder.withArgName(OPTION_ACTION);
        OptionBuilder.withDescription("define the action that should be performed; avaible actions: " + actions);
        OptionBuilder.withLongOpt(OPTION_ACTION);
        Option action = OptionBuilder.create(CMD_OPTION_ACTION);
        OptionBuilder.withArgName("path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("place the output into the file at <path>");
        OptionBuilder.withLongOpt(OPTION_OUTPUT_DESTINATION);
        Option destination = OptionBuilder.create(CMD_OPTION_OUTPUT_DESTINATION);
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("path");
        OptionBuilder.withDescription("set the directory where downloaded dump files are stored");
        OptionBuilder.withLongOpt(OPTION_DUMP_LOCATION);
        Option dumplocation = OptionBuilder.create(CMD_OPTION_DUMP_LOCATION);
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("file");
        OptionBuilder.withDescription("set a config file; use this to define multiple actions for a single run");
        OptionBuilder.withLongOpt(OPTION_CONFIG_FILE);
        Option config = OptionBuilder.create(CMD_OPTION_CONFIG_FILE);
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName("task");
        OptionBuilder.withDescription("specify which data to include in RDF dump (use with action \"rdf\"); run with options \"-a rdf -n\" for help");
        OptionBuilder.withLongOpt(OPTION_OUTPUT_RDF_TYPE);
        Option rdfdump = OptionBuilder.create();
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName("languages");
        OptionBuilder.withDescription("specifies a list of language codes; if given, only terms in languages in this list will be processed; the value \"-\" denotes the empty list (no terms are processed)");
        OptionBuilder.withLongOpt(OPTION_FILTER_LANGUAGES);
        Option filterLanguages = OptionBuilder.create();
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName("sites");
        OptionBuilder.withDescription("specifies a list of site keys; if given, only site links to sites in this list will be processed; the value \"-\" denotes the empty list (no site links are processed)");
        OptionBuilder.withLongOpt(OPTION_FILTER_SITES);
        Option filterSites = OptionBuilder.create();
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName("ids");
        OptionBuilder.withDescription("specifies a list of property ids; if given, only statements for properties in this list will be processed; the value \"-\" denotes the empty list (no statements are processed)");
        OptionBuilder.withLongOpt(OPTION_FILTER_PROPERTIES);
        Option filterProperties = OptionBuilder.create();
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("type");
        OptionBuilder.withDescription("define a compression format to be used for the output; possible values: gz, bz2");
        OptionBuilder.withLongOpt(OPTION_OUTPUT_COMPRESSION);
        Option compressionExtention = OptionBuilder.create(CMD_OPTION_OUTPUT_COMPRESSION);
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("path");
        OptionBuilder.withDescription("specifies a path to print a final report after dump generations");
        OptionBuilder.withLongOpt(OPTION_CREATE_REPORT);
        Option report = OptionBuilder.create(CMD_OPTION_CREATE_REPORT);
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("path");
        OptionBuilder.withDescription("select a dump file for processing; if omitted, then the latest dump from Wikidata will be used (and possibly downloaded)");
        OptionBuilder.withLongOpt(OPTION_LOCAL_DUMPFILE);
        Option localDump = OptionBuilder.create(CMD_OPTION_LOCAL_DUMPFILE);
        options.addOption(config);
        options.addOption(action);
        options.addOption(CMD_OPTION_QUIET, OPTION_QUIET, false, "perform all actions quietly, without printing status messages to the console; errors/warnings are still printed to stderr");
        options.addOption(destination);
        options.addOption(dumplocation);
        options.addOption(filterLanguages);
        options.addOption(filterSites);
        options.addOption(filterProperties);
        options.addOption(compressionExtention);
        options.addOption(report);
        options.addOption(localDump);
        options.addOption(rdfdump);
        options.addOption(CMD_OPTION_OFFLINE_MODE, OPTION_OFFLINE_MODE, false, "execute all operations in offline mode, especially do not download new dumps");
        options.addOption(CMD_OPTION_HELP, OPTION_HELP, false, "print this message");
        options.addOption(CMD_OPTION_OUTPUT_STDOUT, OPTION_OUTPUT_STDOUT, false, "write output to stdout");
    }

    static {
        KNOWN_ACTIONS.put("rdf", RdfSerializationAction.class);
        KNOWN_ACTIONS.put("json", JsonSerializationAction.class);
        options = new Options();
        ClientConfiguration.initOptions();
    }
}

