/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.nativerdf;

import java.io.IOException;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.query.algebra.StatementPattern;
import org.openrdf.query.algebra.Var;
import org.openrdf.query.algebra.evaluation.impl.EvaluationStatistics;
import org.openrdf.sail.nativerdf.NativeStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NativeEvaluationStatistics
extends EvaluationStatistics {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final NativeStore nativeStore;

    public NativeEvaluationStatistics(NativeStore nativeStore) {
        this.nativeStore = nativeStore;
    }

    @Override
    protected EvaluationStatistics.CardinalityCalculator createCardinalityCalculator() {
        return new NativeCardinalityCalculator();
    }

    protected class NativeCardinalityCalculator
    extends EvaluationStatistics.CardinalityCalculator {
        protected NativeCardinalityCalculator() {
        }

        @Override
        protected double getCardinality(StatementPattern sp) {
            try {
                Value pred;
                Value subj = this.getConstantValue(sp.getSubjectVar());
                if (!(subj instanceof Resource)) {
                    subj = null;
                }
                if (!((pred = this.getConstantValue(sp.getPredicateVar())) instanceof URI)) {
                    pred = null;
                }
                Value obj = this.getConstantValue(sp.getObjectVar());
                Value context = this.getConstantValue(sp.getContextVar());
                if (!(context instanceof Resource)) {
                    context = null;
                }
                return NativeEvaluationStatistics.this.nativeStore.cardinality((Resource)subj, (URI)pred, obj, (Resource)context);
            }
            catch (IOException e) {
                NativeEvaluationStatistics.this.log.error("Failed to estimate statement pattern cardinality, falling back to generic implementation", (Throwable)e);
                return super.getCardinality(sp);
            }
        }

        protected Value getConstantValue(Var var) {
            return var != null ? var.getValue() : null;
        }
    }
}

