/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.federation.evaluation;

import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.LookAheadIteration;
import info.aduna.iteration.SingletonIteration;
import java.util.Set;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.algebra.LeftJoin;
import org.openrdf.query.algebra.ValueExpr;
import org.openrdf.query.algebra.evaluation.EvaluationStrategy;
import org.openrdf.sail.federation.evaluation.AlternativeCursor;
import org.openrdf.sail.federation.evaluation.FilterCursor;
import org.openrdf.sail.federation.evaluation.QueueCursor;

public class ParallelLeftJoinCursor
extends LookAheadIteration<BindingSet, QueryEvaluationException>
implements Runnable {
    private static final String LF_TAB = "\n\t";
    private final EvaluationStrategy strategy;
    private final LeftJoin join;
    private final Set<String> scopeBindingNames;
    private volatile Thread evaluationThread;
    private final CloseableIteration<BindingSet, QueryEvaluationException> leftIter;
    private CloseableIteration<BindingSet, QueryEvaluationException> rightIter;
    private volatile boolean closed;
    private final QueueCursor<CloseableIteration<BindingSet, QueryEvaluationException>> rightQueue = new QueueCursor(1024);

    public ParallelLeftJoinCursor(EvaluationStrategy strategy, LeftJoin join, BindingSet bindings) throws QueryEvaluationException {
        this.strategy = strategy;
        this.join = join;
        this.scopeBindingNames = join.getBindingNames();
        this.leftIter = strategy.evaluate(join.getLeftArg(), bindings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.evaluationThread = Thread.currentThread();
        try {
            ValueExpr condition = this.join.getCondition();
            while (!this.closed && this.leftIter.hasNext()) {
                BindingSet leftBindings = (BindingSet)this.leftIter.next();
                this.addToRightQueue(condition, leftBindings);
            }
        }
        catch (RuntimeException e) {
            this.rightQueue.toss(e);
        }
        catch (QueryEvaluationException e) {
            this.rightQueue.toss(e);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.evaluationThread = null;
            this.rightQueue.done();
        }
    }

    private void addToRightQueue(ValueExpr condition, BindingSet leftBindings) throws QueryEvaluationException, InterruptedException {
        FilterCursor result = this.strategy.evaluate(this.join.getRightArg(), leftBindings);
        if (condition != null) {
            result = new FilterCursor(result, condition, this.scopeBindingNames, this.strategy);
        }
        SingletonIteration alt = new SingletonIteration(leftBindings);
        this.rightQueue.put(new AlternativeCursor<BindingSet>(result, alt));
    }

    @Override
    public synchronized BindingSet getNextElement() throws QueryEvaluationException {
        BindingSet result = null;
        while (this.rightIter != null || this.rightQueue.hasNext()) {
            if (this.rightIter == null) {
                this.rightIter = (CloseableIteration)this.rightQueue.next();
            }
            if (this.rightIter.hasNext()) {
                result = (BindingSet)this.rightIter.next();
                break;
            }
            this.rightIter.close();
            this.rightIter = null;
        }
        return result;
    }

    @Override
    public synchronized void handleClose() throws QueryEvaluationException {
        this.closed = true;
        if (this.evaluationThread != null) {
            this.evaluationThread.interrupt();
        }
        if (this.rightIter != null) {
            this.rightIter.close();
            this.rightIter = null;
        }
        this.leftIter.close();
    }

    public String toString() {
        String left = this.leftIter.toString().replace("\n", LF_TAB);
        String right = null == this.rightIter ? this.join.getRightArg().toString() : this.rightIter.toString();
        ValueExpr condition = this.join.getCondition();
        String filter = null == condition ? "" : condition.toString().trim().replace("\n", LF_TAB);
        return "ParallelLeftJoin " + filter + LF_TAB + left + LF_TAB + right.replace("\n", LF_TAB);
    }
}

