/*
 * Decompiled with CFR 0.152.
 */
package org.saintandreas.math;

import java.nio.FloatBuffer;
import javax.annotation.Nonnull;
import org.saintandreas.math.FastMath;

public abstract class Vector<ResultType extends Vector<ResultType>> {
    private final ResultType This() {
        return (ResultType)this;
    }

    protected abstract ResultType build(float[] var1);

    protected abstract ResultType build(float var1);

    public abstract float[] toArray();

    public abstract float angleBetween(@Nonnull ResultType var1);

    public final boolean isUnitVector() {
        return FastMath.isWithinEpsilon(this.lengthSquared(), 1.0f);
    }

    public final float length() {
        return FastMath.sqrt(this.lengthSquared());
    }

    public final boolean equalsEpsilon(ResultType v) {
        return this.equalsEpsilon(v, 1.0E-4f);
    }

    public final ResultType scale(float scalar) {
        return this.mult((ResultType)scalar);
    }

    public final ResultType divide(float scalar) {
        return this.mult((ResultType)(1.0f / scalar));
    }

    public final ResultType negate() {
        return this.mult((ResultType)-1.0f);
    }

    public final ResultType subtract(ResultType vec) {
        return this.add(((Vector)vec).negate());
    }

    public final ResultType normalize() {
        float lengthSquared = this.lengthSquared();
        if (lengthSquared == 0.0f && FastMath.isWithinEpsilon(lengthSquared, 1.0f)) {
            return this.This();
        }
        return this.divide((ResultType)FastMath.sqrt(lengthSquared));
    }

    public final float distance(ResultType v) {
        return FastMath.sqrt(this.distanceSquared(v));
    }

    public final ResultType divide(ResultType v) {
        return this.mult(((Vector)v).inverse());
    }

    public final void fillBuffer(FloatBuffer buffer) {
        buffer.put(this.toArray());
    }

    public final ResultType scaleAdd(float scalar, ResultType add) {
        return this.mult((ResultType)scalar).add(add);
    }

    public final ResultType project(ResultType other) {
        float n = this.dot(other);
        float d = ((Vector)other).lengthSquared();
        return ((Vector)other).normalize().mult((ResultType)(n / d));
    }

    public final ResultType add(@Nonnull ResultType v) {
        float[] a = this.toArray();
        float[] b = ((Vector)v).toArray();
        for (int i = 0; i < a.length; ++i) {
            int n = i;
            a[n] = a[n] + b[i];
        }
        return this.build(a);
    }

    public final ResultType add(@Nonnull float s) {
        float[] a = this.toArray();
        int i = 0;
        while (i < a.length) {
            int n = i++;
            a[n] = a[n] + s;
        }
        return this.build(a);
    }

    public final ResultType subtract(@Nonnull float s) {
        return this.add(-s);
    }

    public final ResultType mult(float scalar) {
        float[] a = this.toArray();
        int i = 0;
        while (i < a.length) {
            int n = i++;
            a[n] = a[n] * scalar;
        }
        return this.build(a);
    }

    public ResultType mult(@Nonnull ResultType v) {
        float[] a = this.toArray();
        float[] b = ((Vector)v).toArray();
        for (int i = 0; i < a.length; ++i) {
            int n = i;
            a[n] = a[n] * b[i];
        }
        return this.build(a);
    }

    public ResultType inverse() {
        float[] a = this.toArray();
        for (int i = 0; i < a.length; ++i) {
            a[i] = 1.0f / a[i];
        }
        return this.build(a);
    }

    public final float dot(@Nonnull ResultType v) {
        float[] a = this.toArray();
        float[] b = ((Vector)v).toArray();
        float result = 0.0f;
        for (int i = 0; i < a.length; ++i) {
            result += a[i] * b[i];
        }
        return result;
    }

    public final ResultType interpolate(@Nonnull ResultType v, float changeAmnt) {
        float[] a = this.toArray();
        float[] b = ((Vector)v).toArray();
        for (int i = 0; i < a.length; ++i) {
            a[i] = FastMath.interpolateLinear(changeAmnt, a[i], b[i]);
        }
        return this.build(a);
    }

    public final ResultType max(ResultType v) {
        float[] a = this.toArray();
        float[] b = ((Vector)v).toArray();
        for (int i = 0; i < a.length; ++i) {
            a[i] = Math.max(a[i], b[i]);
        }
        return this.build(a);
    }

    public final ResultType min(ResultType v) {
        float[] a = this.toArray();
        float[] b = ((Vector)v).toArray();
        for (int i = 0; i < a.length; ++i) {
            a[i] = Math.min(a[i], b[i]);
        }
        return this.build(a);
    }

    public final boolean equalsEpsilon(ResultType v, float epsilon) {
        float[] a = this.toArray();
        float[] b = ((Vector)v).toArray();
        for (int i = 0; i < a.length; ++i) {
            if (FastMath.isWithinEpsilon(a[i], b[i], epsilon)) continue;
            return false;
        }
        return true;
    }

    public final float distanceSquared(@Nonnull ResultType v) {
        float[] a = this.toArray();
        float[] b = ((Vector)v).toArray();
        float result = 0.0f;
        for (int i = 0; i < a.length; ++i) {
            float f = a[i] - b[i];
            result += f * f;
        }
        return result;
    }

    public final float lengthSquared() {
        float[] a = this.toArray();
        float result = 0.0f;
        for (int i = 0; i < a.length; ++i) {
            float f = a[i];
            result += f * f;
        }
        return result;
    }

    public final boolean isValid() {
        for (float f : this.toArray()) {
            if (!Float.isNaN(f) && !Float.isInfinite(f)) continue;
            return false;
        }
        return true;
    }

    public final int hashCode() {
        int hash = 37;
        for (float f : this.toArray()) {
            hash += 37 * hash + Float.floatToIntBits(f);
        }
        return hash;
    }
}

