/*
 * Decompiled with CFR 0.152.
 */
package org.saintandreas.math;

import java.io.Serializable;
import org.saintandreas.math.FastMath;
import org.saintandreas.math.Vector3f;

public final class Matrix3f
implements Serializable {
    static final long serialVersionUID = 1L;
    protected final float m00;
    protected final float m01;
    protected final float m02;
    protected final float m10;
    protected final float m11;
    protected final float m12;
    protected final float m20;
    protected final float m21;
    protected final float m22;
    public static final Matrix3f ZERO = new Matrix3f(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    public static final Matrix3f IDENTITY = new Matrix3f();

    public Matrix3f() {
        this.m21 = 0.0f;
        this.m20 = 0.0f;
        this.m12 = 0.0f;
        this.m10 = 0.0f;
        this.m02 = 0.0f;
        this.m01 = 0.0f;
        this.m22 = 1.0f;
        this.m11 = 1.0f;
        this.m00 = 1.0f;
    }

    public Matrix3f(float m00, float m01, float m02, float m10, float m11, float m12, float m20, float m21, float m22) {
        this.m00 = m00;
        this.m01 = m01;
        this.m02 = m02;
        this.m10 = m10;
        this.m11 = m11;
        this.m12 = m12;
        this.m20 = m20;
        this.m21 = m21;
        this.m22 = m22;
    }

    public Matrix3f(Vector3f uAxis, Vector3f vAxis, Vector3f wAxis) {
        this.m00 = uAxis.x;
        this.m10 = uAxis.y;
        this.m20 = uAxis.z;
        this.m01 = vAxis.x;
        this.m11 = vAxis.y;
        this.m21 = vAxis.z;
        this.m02 = wAxis.x;
        this.m12 = wAxis.y;
        this.m22 = wAxis.z;
    }

    public Matrix3f(Matrix3f m) {
        this.m00 = m.m00;
        this.m01 = m.m01;
        this.m02 = m.m02;
        this.m10 = m.m10;
        this.m11 = m.m11;
        this.m12 = m.m12;
        this.m20 = m.m20;
        this.m21 = m.m21;
        this.m22 = m.m22;
    }

    protected Matrix3f(Matrix3fTemp m) {
        this.m00 = m.m00;
        this.m01 = m.m01;
        this.m02 = m.m02;
        this.m10 = m.m10;
        this.m11 = m.m11;
        this.m12 = m.m12;
        this.m20 = m.m20;
        this.m21 = m.m21;
        this.m22 = m.m22;
    }

    public Matrix3f(float angle, Vector3f axis) {
        float fCos = FastMath.cos(angle);
        float fSin = FastMath.sin(angle);
        float fOneMinusCos = 1.0f - fCos;
        float fX2 = axis.x * axis.x;
        float fY2 = axis.y * axis.y;
        float fZ2 = axis.z * axis.z;
        float fXYM = axis.x * axis.y * fOneMinusCos;
        float fXZM = axis.x * axis.z * fOneMinusCos;
        float fYZM = axis.y * axis.z * fOneMinusCos;
        float fXSin = axis.x * fSin;
        float fYSin = axis.y * fSin;
        float fZSin = axis.z * fSin;
        this.m00 = fX2 * fOneMinusCos + fCos;
        this.m01 = fXYM - fZSin;
        this.m02 = fXZM + fYSin;
        this.m10 = fXYM + fZSin;
        this.m11 = fY2 * fOneMinusCos + fCos;
        this.m12 = fYZM - fXSin;
        this.m20 = fXZM - fYSin;
        this.m21 = fYZM + fXSin;
        this.m22 = fZ2 * fOneMinusCos + fCos;
    }

    public float get(int i, int j) {
        switch (i) {
            case 0: {
                switch (j) {
                    case 0: {
                        return this.m00;
                    }
                    case 1: {
                        return this.m01;
                    }
                    case 2: {
                        return this.m02;
                    }
                }
            }
            case 1: {
                switch (j) {
                    case 0: {
                        return this.m10;
                    }
                    case 1: {
                        return this.m11;
                    }
                    case 2: {
                        return this.m12;
                    }
                }
            }
            case 2: {
                switch (j) {
                    case 0: {
                        return this.m20;
                    }
                    case 1: {
                        return this.m21;
                    }
                    case 2: {
                        return this.m22;
                    }
                }
            }
        }
        throw new IllegalArgumentException("Invalid indices into matrix.");
    }

    public void get(float[] data, boolean rowMajor) {
        if (data.length == 9) {
            if (rowMajor) {
                data[0] = this.m00;
                data[1] = this.m01;
                data[2] = this.m02;
                data[3] = this.m10;
                data[4] = this.m11;
                data[5] = this.m12;
                data[6] = this.m20;
                data[7] = this.m21;
                data[8] = this.m22;
            } else {
                data[0] = this.m00;
                data[1] = this.m10;
                data[2] = this.m20;
                data[3] = this.m01;
                data[4] = this.m11;
                data[5] = this.m21;
                data[6] = this.m02;
                data[7] = this.m12;
                data[8] = this.m22;
            }
        } else if (data.length == 16) {
            if (rowMajor) {
                data[0] = this.m00;
                data[1] = this.m01;
                data[2] = this.m02;
                data[4] = this.m10;
                data[5] = this.m11;
                data[6] = this.m12;
                data[8] = this.m20;
                data[9] = this.m21;
                data[10] = this.m22;
            } else {
                data[0] = this.m00;
                data[1] = this.m10;
                data[2] = this.m20;
                data[4] = this.m01;
                data[5] = this.m11;
                data[6] = this.m21;
                data[8] = this.m02;
                data[9] = this.m12;
                data[10] = this.m22;
            }
        } else {
            throw new IndexOutOfBoundsException("Array size must be 9 or 16 in Matrix3f.get().");
        }
    }

    public Vector3f getColumn(int i) {
        float vz;
        float vy;
        float vx;
        switch (i) {
            case 0: {
                vx = this.m00;
                vy = this.m10;
                vz = this.m20;
                break;
            }
            case 1: {
                vx = this.m01;
                vy = this.m11;
                vz = this.m21;
                break;
            }
            case 2: {
                vx = this.m02;
                vy = this.m12;
                vz = this.m22;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid column index. " + i);
            }
        }
        return new Vector3f(vx, vy, vz);
    }

    public Vector3f getRow(int i) {
        float vz;
        float vy;
        float vx;
        switch (i) {
            case 0: {
                vx = this.m00;
                vy = this.m01;
                vz = this.m02;
                break;
            }
            case 1: {
                vx = this.m10;
                vy = this.m11;
                vz = this.m12;
                break;
            }
            case 2: {
                vx = this.m20;
                vy = this.m21;
                vz = this.m22;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid row index. " + i);
            }
        }
        return new Vector3f(vx, vy, vz);
    }

    public void fillFloatArray(float[] f, boolean columnMajor) {
        if (columnMajor) {
            f[0] = this.m00;
            f[1] = this.m10;
            f[2] = this.m20;
            f[3] = this.m01;
            f[4] = this.m11;
            f[5] = this.m21;
            f[6] = this.m02;
            f[7] = this.m12;
            f[8] = this.m22;
        } else {
            f[0] = this.m00;
            f[1] = this.m01;
            f[2] = this.m02;
            f[3] = this.m10;
            f[4] = this.m11;
            f[5] = this.m12;
            f[6] = this.m20;
            f[7] = this.m21;
            f[8] = this.m22;
        }
    }

    public boolean isIdentity() {
        return this.m00 == 1.0f && this.m01 == 0.0f && this.m02 == 0.0f && this.m10 == 0.0f && this.m11 == 1.0f && this.m12 == 0.0f && this.m20 == 0.0f && this.m21 == 0.0f && this.m22 == 1.0f;
    }

    public Matrix3f mult(Matrix3f mat) {
        float temp00 = this.m00 * mat.m00 + this.m01 * mat.m10 + this.m02 * mat.m20;
        float temp01 = this.m00 * mat.m01 + this.m01 * mat.m11 + this.m02 * mat.m21;
        float temp02 = this.m00 * mat.m02 + this.m01 * mat.m12 + this.m02 * mat.m22;
        float temp10 = this.m10 * mat.m00 + this.m11 * mat.m10 + this.m12 * mat.m20;
        float temp11 = this.m10 * mat.m01 + this.m11 * mat.m11 + this.m12 * mat.m21;
        float temp12 = this.m10 * mat.m02 + this.m11 * mat.m12 + this.m12 * mat.m22;
        float temp20 = this.m20 * mat.m00 + this.m21 * mat.m10 + this.m22 * mat.m20;
        float temp21 = this.m20 * mat.m01 + this.m21 * mat.m11 + this.m22 * mat.m21;
        float temp22 = this.m20 * mat.m02 + this.m21 * mat.m12 + this.m22 * mat.m22;
        return new Matrix3f(temp00, temp01, temp02, temp10, temp11, temp12, temp20, temp21, temp22);
    }

    public Vector3f mult(Vector3f v) {
        return new Vector3f(this.m00 * v.x + this.m01 * v.y + this.m02 * v.z, this.m10 * v.x + this.m11 * v.y + this.m12 * v.z, this.m20 * v.x + this.m21 * v.y + this.m22 * v.z);
    }

    public Matrix3f invert() {
        float det = this.determinant();
        if (FastMath.abs(det) <= 1.1920929E-7f) {
            return ZERO;
        }
        float idet = 1.0f / det;
        Matrix3fTemp store = new Matrix3fTemp();
        store.m00 = this.m11 * this.m22 - this.m12 * this.m21;
        store.m01 = this.m02 * this.m21 - this.m01 * this.m22;
        store.m02 = this.m01 * this.m12 - this.m02 * this.m11;
        store.m10 = this.m12 * this.m20 - this.m10 * this.m22;
        store.m11 = this.m00 * this.m22 - this.m02 * this.m20;
        store.m12 = this.m02 * this.m10 - this.m00 * this.m12;
        store.m20 = this.m10 * this.m21 - this.m11 * this.m20;
        store.m21 = this.m01 * this.m20 - this.m00 * this.m21;
        store.m22 = this.m00 * this.m11 - this.m01 * this.m10;
        store.m00 *= idet;
        store.m01 *= idet;
        store.m02 *= idet;
        store.m10 *= idet;
        store.m11 *= idet;
        store.m12 *= idet;
        store.m20 *= idet;
        store.m21 *= idet;
        store.m22 *= idet;
        return new Matrix3f(store);
    }

    public Matrix3f adjoint() {
        Matrix3fTemp store = new Matrix3fTemp();
        store.m00 = this.m11 * this.m22 - this.m12 * this.m21;
        store.m01 = this.m02 * this.m21 - this.m01 * this.m22;
        store.m02 = this.m01 * this.m12 - this.m02 * this.m11;
        store.m10 = this.m12 * this.m20 - this.m10 * this.m22;
        store.m11 = this.m00 * this.m22 - this.m02 * this.m20;
        store.m12 = this.m02 * this.m10 - this.m00 * this.m12;
        store.m20 = this.m10 * this.m21 - this.m11 * this.m20;
        store.m21 = this.m01 * this.m20 - this.m00 * this.m21;
        store.m22 = this.m00 * this.m11 - this.m01 * this.m10;
        return new Matrix3f(store);
    }

    public float determinant() {
        float fCo00 = this.m11 * this.m22 - this.m12 * this.m21;
        float fCo10 = this.m12 * this.m20 - this.m10 * this.m22;
        float fCo20 = this.m10 * this.m21 - this.m11 * this.m20;
        float fDet = this.m00 * fCo00 + this.m01 * fCo10 + this.m02 * fCo20;
        return fDet;
    }

    public Matrix3f transpose() {
        return new Matrix3f(this.m00, this.m10, this.m20, this.m01, this.m11, this.m21, this.m02, this.m12, this.m22);
    }

    public int hashCode() {
        int hash = 37;
        hash = 37 * hash + Float.floatToIntBits(this.m00);
        hash = 37 * hash + Float.floatToIntBits(this.m01);
        hash = 37 * hash + Float.floatToIntBits(this.m02);
        hash = 37 * hash + Float.floatToIntBits(this.m10);
        hash = 37 * hash + Float.floatToIntBits(this.m11);
        hash = 37 * hash + Float.floatToIntBits(this.m12);
        hash = 37 * hash + Float.floatToIntBits(this.m20);
        hash = 37 * hash + Float.floatToIntBits(this.m21);
        hash = 37 * hash + Float.floatToIntBits(this.m22);
        return hash;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Matrix3f) || o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        Matrix3f comp = (Matrix3f)o;
        if (Float.compare(this.m00, comp.m00) != 0) {
            return false;
        }
        if (Float.compare(this.m01, comp.m01) != 0) {
            return false;
        }
        if (Float.compare(this.m02, comp.m02) != 0) {
            return false;
        }
        if (Float.compare(this.m10, comp.m10) != 0) {
            return false;
        }
        if (Float.compare(this.m11, comp.m11) != 0) {
            return false;
        }
        if (Float.compare(this.m12, comp.m12) != 0) {
            return false;
        }
        if (Float.compare(this.m20, comp.m20) != 0) {
            return false;
        }
        if (Float.compare(this.m21, comp.m21) != 0) {
            return false;
        }
        return Float.compare(this.m22, comp.m22) == 0;
    }

    public Matrix3f scale(Vector3f scale) {
        return new Matrix3f(this.m00 * scale.x, this.m01 * scale.y, this.m02 * scale.z, this.m10 * scale.x, this.m11 * scale.y, this.m12 * scale.z, this.m20 * scale.x, this.m21 * scale.y, this.m22 * scale.z);
    }

    static boolean equalIdentity(Matrix3f mat) {
        if ((double)Math.abs(mat.m00 - 1.0f) > 1.0E-4) {
            return false;
        }
        if ((double)Math.abs(mat.m11 - 1.0f) > 1.0E-4) {
            return false;
        }
        if ((double)Math.abs(mat.m22 - 1.0f) > 1.0E-4) {
            return false;
        }
        if ((double)Math.abs(mat.m01) > 1.0E-4) {
            return false;
        }
        if ((double)Math.abs(mat.m02) > 1.0E-4) {
            return false;
        }
        if ((double)Math.abs(mat.m10) > 1.0E-4) {
            return false;
        }
        if ((double)Math.abs(mat.m12) > 1.0E-4) {
            return false;
        }
        if ((double)Math.abs(mat.m20) > 1.0E-4) {
            return false;
        }
        return !((double)Math.abs(mat.m21) > 1.0E-4);
    }

    private static class Matrix3fTemp {
        public float m00;
        public float m01;
        public float m02;
        public float m10;
        public float m11;
        public float m12;
        public float m20;
        public float m21;
        public float m22;

        private Matrix3fTemp() {
        }
    }
}

