/*
 * Decompiled with CFR 0.152.
 */
package org.saintandreas.math;

import java.io.Serializable;
import org.saintandreas.math.FastMath;
import org.saintandreas.math.Vector;

public abstract class Vector4<ResultType extends Vector4<ResultType>>
extends Vector<ResultType>
implements Serializable {
    static final long serialVersionUID = 1L;
    public final float x;
    public final float y;
    public final float z;
    public final float w;

    protected abstract ResultType build(float var1, float var2, float var3, float var4);

    public Vector4(float s) {
        this.z = this.w = s;
        this.y = this.w;
        this.x = this.w;
    }

    public Vector4(float x, float y, float z, float w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public final boolean equals(Object o) {
        if (!(o instanceof Vector4)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        Vector4 comp = (Vector4)o;
        if (Float.compare(this.x, comp.x) != 0) {
            return false;
        }
        if (Float.compare(this.y, comp.y) != 0) {
            return false;
        }
        if (Float.compare(this.z, comp.z) != 0) {
            return false;
        }
        return Float.compare(this.w, comp.w) == 0;
    }

    public final String toString() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ", " + this.w + ")";
    }

    public final float getX() {
        return this.x;
    }

    public final float getY() {
        return this.y;
    }

    public final float getZ() {
        return this.z;
    }

    public final float getW() {
        return this.w;
    }

    @Override
    public final float angleBetween(ResultType otherVector) {
        float dotProduct = this.dot(otherVector);
        float angle = FastMath.acos(dotProduct);
        return angle;
    }

    @Override
    public final float[] toArray() {
        return new float[]{this.x, this.y, this.z, this.w};
    }

    public final float get(int index) {
        switch (index) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
            case 3: {
                return this.w;
            }
        }
        throw new IllegalArgumentException("index must be either 0, 1, 2 or 3");
    }

    @Override
    protected ResultType build(float[] v) {
        return this.build(v[0], v[1], v[2], v[3]);
    }

    @Override
    protected ResultType build(float s) {
        return (ResultType)this.build(s);
    }
}

